import java.awt.*;
import java.awt.event.*;
import java.applet.*;

public class Draw extends Applet implements MouseMotionListener {  
  Image offscreenImage;
  Graphics offscreenGraphics;

  int oldx,oldy;
  boolean moved;

  int color;

  Button clear;

  public void init() {
    offscreenImage = createImage(getSize().width,getSize().height);
    offscreenGraphics = offscreenImage.getGraphics();

    offscreenGraphics.setColor(Color.black);
    offscreenGraphics.fillRect(0,0,getSize().width,getSize().height);
    offscreenGraphics.setColor(Color.white);

    addMouseMotionListener(this);
    
    clear=new Button("Clear");
    
    clear.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        offscreenGraphics.setColor(Color.black);
        offscreenGraphics.fillRect(0,0,getSize().width,getSize().height);
        offscreenGraphics.setColor(Color.white);
        repaint();
      }
    });
     
    add(clear); 

    moved=false;
    color=0;

    repaint();
  }
   
  public void paint(Graphics g) {
    g.drawImage(offscreenImage, 0, 0, this);
  }
  
  public void update(Graphics g) {
    paint(g);
  }

  public void destroy() {
    offscreenGraphics.dispose();
  }

  // MouseListener part:
  public void mouseMoved(MouseEvent e) {
    oldx=e.getX();
    oldy=e.getY();
    moved=true;
  }

  public void mouseDragged(MouseEvent e) { 
    int x,y;
   
    x=e.getX();
    y=e.getY();

    color=(color+1)%96;
    offscreenGraphics.setColor(computeColor(color));

    if (moved)
      offscreenGraphics.drawLine(oldx,oldy,x,y);
    else 
      moved=true;

    oldx=x; 
    oldy=y;        

    repaint();   
  }

  private Color computeColor(int x) {
    if (x<32) 
      return new Color(255-7*x,31+7*x,31);
    else if (x<64)
      return new Color(31,255-7*(x-32),31+7*(x-32));
    else
      return new Color(31+7*(x-64),31,255-7*(x-64));
  }
}