/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.requests;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.ProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpRoutedConnection;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecRegistry;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class RequestExtractCookiesInterceptor
implements HttpRequestInterceptor {
    private static final List<String> DATE_PATTERNS = Arrays.asList("EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy", "EEE, dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MMM-yyyy HH-mm-ss z", "EEE, dd MMM yy HH:mm:ss z", "EEE dd-MMM-yyyy HH:mm:ss z", "EEE dd MMM yyyy HH:mm:ss z", "EEE dd-MMM-yyyy HH-mm-ss z", "EEE dd-MMM-yy HH:mm:ss z", "EEE dd MMM yy HH:mm:ss z", "EEE,dd-MMM-yy HH:mm:ss z", "EEE,dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MM-yyyy HH:mm:ss z", "EEE, dd MMM yyyy HH:mm:ss");
    private final String defaultPolicy;

    public RequestExtractCookiesInterceptor(String string) {
        this.defaultPolicy = string;
    }

    public RequestExtractCookiesInterceptor() {
        this("compatibility");
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        CookieOrigin cookieOrigin = this.getTrueOrigin(httpRequest, httpContext);
        if (cookieOrigin == null) {
            return;
        }
        CookieOrigin cookieOrigin2 = this.toCookieOrigin(cookieOrigin);
        CookieStore cookieStore = (CookieStore)httpContext.getAttribute("http.cookie-store");
        if (cookieStore == null) {
            return;
        }
        CookieSpec cookieSpec = this.getCookieSpec(httpRequest, httpContext);
        if (cookieSpec == null) {
            return;
        }
        Header[] headerArray = httpRequest.getHeaders("Cookie");
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            this.addCookiesForHeader(header, cookieSpec, cookieOrigin2, cookieStore);
            ++n2;
        }
        httpContext.setAttribute("http.cookie-spec", (Object)cookieSpec);
        httpContext.setAttribute("http.cookie-origin", (Object)cookieOrigin);
    }

    private void addCookiesForHeader(Header header, CookieSpec cookieSpec, CookieOrigin cookieOrigin, CookieStore cookieStore) throws MalformedCookieException {
        for (Cookie cookie : this.processCookieHeader(header, cookieSpec, cookieOrigin)) {
            cookieStore.addCookie(cookie);
        }
    }

    private List<Cookie> processCookieHeader(Header header, CookieSpec cookieSpec, CookieOrigin cookieOrigin) {
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        String[] stringArray = header.getValue().split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            try {
                BasicHeader basicHeader = new BasicHeader("Set-Cookie", string);
                List list = cookieSpec.parse((Header)basicHeader, cookieOrigin);
                arrayList.addAll(list);
            }
            catch (MalformedCookieException malformedCookieException) {}
            ++n2;
        }
        return arrayList;
    }

    private CookieSpec getCookieSpec(HttpRequest httpRequest, HttpContext httpContext) {
        CookieSpecRegistry cookieSpecRegistry = (CookieSpecRegistry)httpContext.getAttribute("http.cookiespec-registry");
        if (cookieSpecRegistry == null) {
            return null;
        }
        DefaultedHttpParams defaultedHttpParams = new DefaultedHttpParams((HttpParams)new BasicHttpParams(), httpRequest.getParams());
        defaultedHttpParams.setParameter("http.protocol.cookie-datepatterns", DATE_PATTERNS);
        String string = this.getCookiePolicy((HttpParams)defaultedHttpParams);
        return cookieSpecRegistry.getCookieSpec(string, (HttpParams)defaultedHttpParams);
    }

    private String getCookiePolicy(HttpParams httpParams) {
        String string = (String)httpParams.getParameter("http.protocol.cookie-policy");
        if (string == null) {
            return this.defaultPolicy;
        }
        return string;
    }

    private CookieOrigin getTrueOrigin(HttpRequest httpRequest, HttpContext httpContext) throws ProtocolException {
        HttpHost httpHost = (HttpHost)httpContext.getAttribute("http.target_host");
        if (httpHost == null) {
            return null;
        }
        HttpRoutedConnection httpRoutedConnection = (HttpRoutedConnection)httpContext.getAttribute("http.connection");
        if (httpRoutedConnection == null) {
            return null;
        }
        return new CookieOrigin(httpHost.getHostName(), this.getPort(httpHost, httpRoutedConnection), this.getPathForRequest(httpRequest), httpRoutedConnection.isSecure());
    }

    private CookieOrigin toCookieOrigin(CookieOrigin cookieOrigin) {
        return new CookieOrigin(cookieOrigin.getHost(), cookieOrigin.getPort(), "/", false);
    }

    private String getPathForRequest(HttpRequest httpRequest) {
        if (httpRequest instanceof HttpUriRequest) {
            URI uRI = ((HttpUriRequest)httpRequest).getURI();
            return uRI.getPath();
        }
        return httpRequest.getRequestLine().getUri();
    }

    private int getPort(HttpHost httpHost, HttpRoutedConnection httpRoutedConnection) {
        if (httpHost.getPort() >= 0) {
            return httpHost.getPort();
        }
        if (httpRoutedConnection.getRoute().getHopCount() == 1) {
            return httpRoutedConnection.getRemotePort();
        }
        return this.getPortForScheme(httpHost.getSchemeName());
    }

    private int getPortForScheme(String string) {
        if (string.equalsIgnoreCase("http")) {
            return 80;
        }
        if (string.equalsIgnoreCase("https")) {
            return 443;
        }
        return 0;
    }
}

