/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.requests;

import com.subgraph.vega.api.html.IHTMLParseResult;
import com.subgraph.vega.api.html.IHTMLParser;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.http.requests.IHttpResponseCookie;
import com.subgraph.vega.api.http.requests.IPageFingerprint;
import com.subgraph.vega.api.model.requests.IRequestOrigin;
import com.subgraph.vega.api.model.tags.ITag;
import com.subgraph.vega.http.requests.custom.VegaHttpEntityEnclosingUriRequest;
import com.subgraph.vega.http.requests.custom.VegaHttpUriRequest;
import com.subgraph.vega.internal.http.requests.PageFingerprint;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EntityUtils;

public class EngineHttpResponse
implements IHttpResponse {
    private final Logger logger = Logger.getLogger("request-engine");
    private final URI requestUri;
    private final HttpHost host;
    private final HttpRequest originalRequest;
    private final List<Cookie> requestCookies;
    private final List<IHttpResponseCookie> responseCookies;
    private final IRequestOrigin requestOrigin;
    private HttpResponse rawResponse;
    private final long requestTime;
    private final IHTMLParser htmlParser;
    private final List<ITag> tagList = new ArrayList<ITag>();
    private String cachedString;
    private PageFingerprint cachedFingerprint;
    private boolean htmlParseFailed;
    private IHTMLParseResult htmlParseResult;
    private boolean isMostlyAsciiTestDone;
    private boolean isMostlyAscii;
    private long requestId = -1L;

    EngineHttpResponse(URI uRI, HttpHost httpHost, HttpRequest httpRequest, List<Cookie> list, List<IHttpResponseCookie> list2, IRequestOrigin iRequestOrigin, HttpResponse httpResponse, long l, IHTMLParser iHTMLParser) {
        this.requestUri = uRI;
        this.host = httpHost;
        this.originalRequest = EngineHttpResponse.cloneOriginalRequest(httpHost, httpRequest);
        this.requestCookies = list;
        this.responseCookies = list2;
        this.requestOrigin = iRequestOrigin;
        this.rawResponse = httpResponse;
        this.requestTime = l;
        this.htmlParser = iHTMLParser;
    }

    private static HttpRequest cloneOriginalRequest(HttpHost httpHost, HttpRequest httpRequest) {
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            return VegaHttpEntityEnclosingUriRequest.createFrom(httpHost, (HttpEntityEnclosingRequest)httpRequest);
        }
        return VegaHttpUriRequest.createFrom(httpHost, httpRequest);
    }

    public HttpRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public List<Cookie> getSentCookies() {
        return this.requestCookies;
    }

    public List<IHttpResponseCookie> getResponseCookies() {
        return this.responseCookies;
    }

    public synchronized void setRawResponse(HttpResponse httpResponse) {
        this.rawResponse = httpResponse;
    }

    public synchronized HttpResponse getRawResponse() {
        return this.rawResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBodyAsString() {
        HttpResponse httpResponse = this.rawResponse;
        synchronized (httpResponse) {
            if (this.cachedString != null) {
                return this.cachedString;
            }
            if (this.rawResponse.getEntity() == null) {
                this.cachedString = "";
                return this.cachedString;
            }
            try {
                this.cachedString = EngineHttpResponse.toString(this.rawResponse.getEntity(), null);
            }
            catch (ParseException parseException) {
                this.logger.log(Level.WARNING, "Error parsing response headers: " + parseException.getMessage(), parseException);
                this.cachedString = "";
            }
            catch (IOException iOException) {
                this.logger.log(Level.WARNING, "IO error extracting response entity for request " + this.originalRequest.getRequestLine().getUri() + " : " + iOException.getMessage(), iOException);
                this.cachedString = "";
            }
            return this.cachedString;
        }
    }

    public static String toString(HttpEntity httpEntity, Charset charset) throws IOException, ParseException {
        if (httpEntity == null) {
            throw new IllegalArgumentException("HTTP entity may not be null");
        }
        InputStream inputStream = httpEntity.getContent();
        if (inputStream == null) {
            return null;
        }
        try {
            int n;
            Object object;
            if (httpEntity.getContentLength() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("HTTP entity too large to be buffered in memory");
            }
            int n2 = (int)httpEntity.getContentLength();
            if (n2 < 0) {
                n2 = 4096;
            }
            Charset charset2 = null;
            try {
                object = ContentType.getOrDefault((HttpEntity)httpEntity);
                charset2 = object.getCharset();
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                charset2 = null;
            }
            if (charset2 == null) {
                charset2 = charset;
            }
            if (charset2 == null) {
                charset2 = HTTP.DEF_CONTENT_CHARSET;
            }
            object = new InputStreamReader(inputStream, charset2);
            CharArrayBuffer charArrayBuffer = new CharArrayBuffer(n2);
            char[] cArray = new char[1024];
            while ((n = ((Reader)object).read(cArray)) != -1) {
                charArrayBuffer.append(cArray, 0, n);
            }
            String string = charArrayBuffer.toString();
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHTMLParseResult getParsedHTML() {
        HttpResponse httpResponse = this.rawResponse;
        synchronized (httpResponse) {
            String string;
            block8: {
                block7: {
                    if (!this.htmlParseFailed) break block7;
                    return null;
                }
                if (this.htmlParseResult != null) {
                    return this.htmlParseResult;
                }
                string = this.getBodyAsString();
                if (string != null) break block8;
                this.htmlParseFailed = true;
                return null;
            }
            this.htmlParseResult = this.htmlParser.parseString(string, this.requestUri);
            if (this.htmlParseResult == null) {
                this.htmlParseFailed = true;
            }
            return this.htmlParseResult;
        }
    }

    public HttpHost getHost() {
        return this.host;
    }

    public int getResponseCode() {
        return this.rawResponse.getStatusLine().getStatusCode();
    }

    public boolean isFetchFail() {
        int n = this.getResponseCode();
        return n == 503 || n == 504;
    }

    public boolean isMostlyAscii() {
        if (this.isMostlyAsciiTestDone) {
            return this.isMostlyAscii;
        }
        String string = this.getBodyAsString();
        if (string == null || string.isEmpty()) {
            this.isMostlyAscii = true;
            this.isMostlyAsciiTestDone = true;
            return true;
        }
        int n = string.length() > 200 ? 200 : string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c >= ' ' && c <= '\u007f' || Character.isWhitespace(c)) {
                ++n2;
            }
            ++n3;
        }
        this.isMostlyAscii = n2 * 100 / n > 90;
        this.isMostlyAsciiTestDone = true;
        return this.isMostlyAscii;
    }

    public IPageFingerprint getPageFingerprint() {
        if (this.cachedFingerprint == null) {
            this.cachedFingerprint = PageFingerprint.generateFromCodeAndString(this.getResponseCode(), this.getBodyAsString());
        }
        return this.cachedFingerprint;
    }

    public IHttpResponse.ResponseStatus getResponseStatus() {
        return IHttpResponse.ResponseStatus.RESPONSE_OK;
    }

    public long getRequestMilliseconds() {
        return this.requestTime;
    }

    public boolean lockResponseEntity() {
        HttpEntity httpEntity = this.rawResponse.getEntity();
        if (httpEntity == null) {
            return false;
        }
        try {
            ByteArrayEntity byteArrayEntity = new ByteArrayEntity(EntityUtils.toByteArray((HttpEntity)httpEntity));
            byteArrayEntity.setContentType(httpEntity.getContentType());
            byteArrayEntity.setContentEncoding(httpEntity.getContentEncoding());
            this.rawResponse.setEntity((HttpEntity)byteArrayEntity);
            EntityUtils.consume((HttpEntity)httpEntity);
            return true;
        }
        catch (IOException iOException) {
            this.logger.warning("Error loading entity for " + this.getRequestUri().toString() + " : " + iOException.getMessage());
            return false;
        }
    }

    public void setRequestId(long l) {
        this.requestId = l;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public IRequestOrigin getRequestOrigin() {
        return this.requestOrigin;
    }

    public URI getRequestUri() {
        return this.requestUri;
    }

    public List<ITag> getTags() {
        return Collections.unmodifiableList(new ArrayList<ITag>(this.tagList));
    }

    public void addTag(ITag iTag) {
        this.tagList.add(iTag);
    }

    public void removeTag(ITag iTag) {
        this.tagList.remove(iTag);
    }
}

