/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.requests;

import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.internal.http.requests.SSLSocketFactoryPlus;
import com.subgraph.vega.internal.http.requests.client.VegaHttpClient;
import com.subgraph.vega.internal.http.requests.config.IHttpClientConfigurer;
import com.subgraph.vega.internal.http.requests.config.RequestEngineConfig;
import com.subgraph.vega.internal.http.requests.connection.SocksSupportingThreadSafeClientConnectionManager;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.params.HttpParams;

public class BasicHttpClientFactory {
    static HttpClient createHttpClient(IHttpRequestEngine.EngineConfigType engineConfigType) {
        IHttpClientConfigurer iHttpClientConfigurer = RequestEngineConfig.getHttpClientConfigurer(engineConfigType);
        HttpParams httpParams = iHttpClientConfigurer.createHttpParams();
        ClientConnectionManager clientConnectionManager = BasicHttpClientFactory.createConnectionManager(httpParams);
        VegaHttpClient vegaHttpClient = new VegaHttpClient(clientConnectionManager, httpParams);
        iHttpClientConfigurer.configureHttpClient(vegaHttpClient);
        return vegaHttpClient;
    }

    private static ClientConnectionManager createConnectionManager(HttpParams httpParams) {
        SchemeRegistry schemeRegistry = BasicHttpClientFactory.createSchemeRegistry();
        return new SocksSupportingThreadSafeClientConnectionManager(schemeRegistry);
    }

    private static SchemeRegistry createSchemeRegistry() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        try {
            SSLSocketFactoryPlus sSLSocketFactoryPlus = new SSLSocketFactoryPlus(new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                    return true;
                }
            }, new AllowAllHostnameVerifierPlus());
            schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)sSLSocketFactoryPlus));
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected exception creating SSLSocketFactory", exception);
        }
        return schemeRegistry;
    }

    static class AllowAllHostnameVerifierPlus
    implements X509HostnameVerifier {
        AllowAllHostnameVerifierPlus() {
        }

        public void verify(String string, SSLSocket sSLSocket) {
        }

        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }

        public void verify(String string, X509Certificate x509Certificate) throws SSLException {
        }

        public void verify(String string, String[] stringArray, String[] stringArray2) throws SSLException {
        }
    }
}

