/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.http.requests.builder;

import com.subgraph.vega.api.http.requests.IHttpHeaderBuilder;
import com.subgraph.vega.api.http.requests.IHttpMessageBuilder;
import com.subgraph.vega.http.requests.builder.HttpHeaderBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.ProtocolVersion;
import org.apache.http.params.HttpParams;

public class HttpMessageBuilder
implements IHttpMessageBuilder {
    private HttpParams params;
    private ProtocolVersion protocolVersion;
    private final ArrayList<HttpHeaderBuilder> headerList = new ArrayList();
    private HttpEntity entity;

    public void clear() {
        this.params = null;
        this.protocolVersion = null;
        this.headerList.clear();
        this.entity = null;
    }

    public void setParams(HttpParams httpParams) {
        this.params = httpParams;
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setHeaders(Header[] headerArray) {
        this.headerList.clear();
        Header[] headerArray2 = headerArray;
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray2[n2];
            this.headerList.add(new HttpHeaderBuilder(header));
            ++n2;
        }
    }

    public HttpHeaderBuilder addHeader(String string, String string2) {
        HttpHeaderBuilder httpHeaderBuilder = new HttpHeaderBuilder(string, string2);
        this.headerList.add(httpHeaderBuilder);
        return httpHeaderBuilder;
    }

    public HttpHeaderBuilder setHeader(String string, String string2) {
        int n = 0;
        while (n < this.headerList.size()) {
            HttpHeaderBuilder httpHeaderBuilder = this.headerList.get(n);
            if (string.equalsIgnoreCase(httpHeaderBuilder.getName())) {
                httpHeaderBuilder.setName(string);
                httpHeaderBuilder.setValue(string2);
                return httpHeaderBuilder;
            }
            ++n;
        }
        return this.addHeader(string, string2);
    }

    public void removeHeader(IHttpHeaderBuilder iHttpHeaderBuilder) {
        this.headerList.remove(iHttpHeaderBuilder);
    }

    public void removeHeaders(String string) {
        Iterator<HttpHeaderBuilder> iterator = this.headerList.iterator();
        while (iterator.hasNext()) {
            IHttpHeaderBuilder iHttpHeaderBuilder = iterator.next();
            if (!string.equalsIgnoreCase(iHttpHeaderBuilder.getName())) continue;
            iterator.remove();
        }
    }

    public void clearHeaders() {
        this.headerList.clear();
    }

    public void swapHeader(int n, int n2) {
        if (n < this.headerList.size() && n2 < this.headerList.size() && n != n2) {
            HttpHeaderBuilder httpHeaderBuilder = this.headerList.set(n, this.headerList.get(n2));
            this.headerList.set(n2, httpHeaderBuilder);
        }
    }

    public int getHeaderIdxOf(IHttpHeaderBuilder iHttpHeaderBuilder) {
        return this.headerList.indexOf(iHttpHeaderBuilder);
    }

    public int getHeaderCnt() {
        return this.headerList.size();
    }

    public IHttpHeaderBuilder getHeader(int n) {
        return this.headerList.get(n);
    }

    public IHttpHeaderBuilder[] getHeaders() {
        return this.headerList.toArray(new HttpHeaderBuilder[this.headerList.size()]);
    }

    public void setEntity(HttpEntity httpEntity) {
        this.entity = httpEntity;
        this.setHeadersEntity();
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    protected void setHeadersEntity() {
        if (this.entity != null) {
            Header header;
            if (this.entity.isChunked() || this.entity.getContentLength() < 0L) {
                this.setHeader("Transfer-Encoding", "chunked");
                this.removeHeaders("Content-Length");
            } else {
                this.setHeader("Content-Length", Long.toString(this.entity.getContentLength()));
                this.removeHeaders("Transfer-Encoding");
            }
            if (this.entity.getContentType() != null) {
                header = this.entity.getContentType();
                this.setHeader(header.getName(), header.getValue());
            }
            if (this.entity.getContentEncoding() != null) {
                header = this.entity.getContentEncoding();
                this.setHeader(header.getName(), header.getValue());
            }
        } else {
            this.removeHeaders("Content-Length");
            this.removeHeaders("Transfer-Encoding");
        }
    }
}

