/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.crawler;

import com.subgraph.vega.api.crawler.ICrawlerResponseProcessor;
import com.subgraph.vega.api.crawler.IWebCrawler;
import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.internal.crawler.CrawlerPauseLock;
import com.subgraph.vega.internal.crawler.CrawlerTask;
import com.subgraph.vega.internal.crawler.HttpResponseProcessor;
import com.subgraph.vega.internal.crawler.RequestConsumer;
import com.subgraph.vega.internal.crawler.TaskCounter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.client.methods.HttpUriRequest;

public class WebCrawler
implements IWebCrawler {
    private static final int MAX_QUEUED_REQUESTS = 50000;
    private final IHttpRequestEngine requestEngine;
    private final Executor executor;
    private final BlockingQueue<CrawlerTask> requestQueue = new LinkedBlockingQueue<CrawlerTask>(50000);
    private final BlockingQueue<CrawlerTask> responseQueue = new LinkedBlockingQueue<CrawlerTask>();
    private final List<RequestConsumer> requestConsumers;
    private final List<HttpResponseProcessor> responseProcessors;
    private final int requestThreadCount;
    private final int responseThreadCount;
    private final CrawlerPauseLock pauseLock;
    private boolean stopOnEmptyQueue = true;
    private volatile CountDownLatch latch;
    private volatile boolean crawlerRunning;
    private TaskCounter counter = new TaskCounter();
    private AtomicInteger outstandingTasks = new AtomicInteger();

    WebCrawler(IHttpRequestEngine iHttpRequestEngine, int n, int n2) {
        this.requestEngine = iHttpRequestEngine;
        this.requestThreadCount = n;
        this.responseThreadCount = n2;
        this.executor = Executors.newFixedThreadPool(n + n2);
        this.requestConsumers = new ArrayList<RequestConsumer>(n);
        this.responseProcessors = new ArrayList<HttpResponseProcessor>(n2);
        this.pauseLock = new CrawlerPauseLock();
    }

    public IHttpRequestEngine getRequestEngine() {
        return this.requestEngine;
    }

    public synchronized void start() {
        Runnable runnable;
        if (this.crawlerRunning) {
            throw new IllegalStateException("Cannot call start() on running crawler instance");
        }
        this.latch = new CountDownLatch(this.requestThreadCount + this.responseThreadCount);
        int n = 0;
        while (n < this.responseThreadCount) {
            runnable = new HttpResponseProcessor(this, this.requestQueue, this.responseQueue, this.latch, this.counter, this.outstandingTasks, this.stopOnEmptyQueue, this.pauseLock);
            this.responseProcessors.add((HttpResponseProcessor)runnable);
            this.executor.execute(runnable);
            ++n;
        }
        n = 0;
        while (n < this.requestThreadCount) {
            runnable = new RequestConsumer(this.requestEngine, this.requestQueue, this.responseQueue, this.latch, this.pauseLock);
            this.requestConsumers.add((RequestConsumer)runnable);
            this.executor.execute(runnable);
            ++n;
        }
        this.crawlerRunning = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws InterruptedException {
        if (!this.crawlerRunning) {
            return;
        }
        CrawlerPauseLock object2 = this.pauseLock;
        synchronized (object2) {
            if (this.pauseLock.isPaused()) {
                this.pauseLock.unpauseCrawler();
            }
        }
        for (HttpResponseProcessor httpResponseProcessor : this.responseProcessors) {
            httpResponseProcessor.stop();
        }
        for (RequestConsumer requestConsumer : this.requestConsumers) {
            requestConsumer.stop();
        }
        this.requestQueue.clear();
        this.requestQueue.put(CrawlerTask.createExitTask());
        this.responseQueue.clear();
        this.responseQueue.put(CrawlerTask.createExitTask());
        this.crawlerRunning = false;
    }

    public void pause() {
        this.pauseLock.pauseCrawler();
    }

    public void unpause() {
        this.pauseLock.unpauseCrawler();
    }

    public boolean isPaused() {
        return this.pauseLock.isPaused();
    }

    public void waitFinished() throws InterruptedException {
        this.latch.await();
    }

    public void submitTask(HttpUriRequest httpUriRequest, ICrawlerResponseProcessor iCrawlerResponseProcessor) {
        this.submitTask(httpUriRequest, iCrawlerResponseProcessor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitTask(HttpUriRequest httpUriRequest, ICrawlerResponseProcessor iCrawlerResponseProcessor, Object object) {
        CrawlerTask crawlerTask = CrawlerTask.createTask(httpUriRequest, iCrawlerResponseProcessor, object);
        this.outstandingTasks.incrementAndGet();
        TaskCounter taskCounter = this.counter;
        synchronized (taskCounter) {
            this.counter.addNewTask();
            try {
                this.requestQueue.put(crawlerTask);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Interruped submission of request task");
            }
        }
    }

    public void setStopOnEmptyQueue(boolean bl) {
        this.stopOnEmptyQueue = bl;
    }
}

