/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.analysis;

import com.subgraph.vega.api.analysis.MimeType;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.internal.analysis.CSSDetector;
import com.subgraph.vega.internal.analysis.JavascriptDetector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;

public class MimeDetector {
    private static final List<String> genericAsciiPrefixes = new ArrayList<String>();
    private static final Map<String, MimeType> nameMap = new HashMap<String, MimeType>();
    private final CSSDetector cssDetector = new CSSDetector();
    private final JavascriptDetector jsDetector = new JavascriptDetector();

    static {
        genericAsciiPrefixes.addAll(Arrays.asList("text/x-", "text/vnd.", "application/x-httpd-"));
        MimeType[] mimeTypeArray = MimeType.values();
        int n = mimeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MimeType mimeType = mimeTypeArray[n2];
            nameMap.put(mimeType.getCanonicalName(), mimeType);
            ++n2;
        }
        MimeDetector.addExtraNames(MimeType.MIME_ASC_GENERIC, "text/csv");
        MimeDetector.addExtraNames(MimeType.MIME_ASC_JAVASCRIPT, "application/x-javascript", "application/json", "text/javascript");
        MimeDetector.addExtraNames(MimeType.MIME_ASC_RTF, "application/rtf");
        MimeDetector.addExtraNames(MimeType.MIME_XML_GENERIC, "application/xml");
        MimeDetector.addExtraNames(MimeType.MIME_IMG_BMP, "image/bmp", "image/x-icon");
        MimeDetector.addExtraNames(MimeType.MIME_AV_WAV, "audio/wav");
        MimeDetector.addExtraNames(MimeType.MIME_AV_RA, "audio/x-pn-realaudio", "audio/x-realaudio");
        MimeDetector.addExtraNames(MimeType.MIME_AV_MPEG, "video/mp4");
        MimeDetector.addExtraNames(MimeType.MIME_AV_FLV, "video/x-flv");
        MimeDetector.addExtraNames(MimeType.MIME_AV_WMEDIA, "audio/x-ms-wma", "video/x-ms-asf");
        MimeDetector.addExtraNames(MimeType.MIME_BIN_ZIP, "application/x-zip-compressed");
        MimeDetector.addExtraNames(MimeType.MIME_BIN_GZIP, "application/x-gunzip", "application/x-tar-gz");
        MimeDetector.addExtraNames(MimeType.MIME_BIN_GENERIC, "application/octet-stream");
    }

    static void addExtraNames(MimeType mimeType, String ... stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            nameMap.put(stringArray[n], mimeType);
            ++n;
        }
    }

    MimeType getDeclaredMimeType(IHttpResponse iHttpResponse) {
        if (iHttpResponse.getRawResponse().containsHeader("Content-Type")) {
            return this.headerToMimeType(iHttpResponse.getRawResponse().getFirstHeader("Content-Type"));
        }
        return MimeType.MIME_NONE;
    }

    private MimeType headerToMimeType(Header header) {
        if (header == null || header.getValue() == null) {
            return MimeType.MIME_NONE;
        }
        String string = header.getValue();
        if (nameMap.containsKey(string)) {
            return nameMap.get(string);
        }
        for (String string2 : genericAsciiPrefixes) {
            if (!string.startsWith(string2)) continue;
            return MimeType.MIME_ASC_GENERIC;
        }
        return MimeType.MIME_NONE;
    }

    MimeType getSniffedMimeType(IHttpResponse iHttpResponse) {
        String string;
        String string2 = iHttpResponse.getBodyAsString();
        if (string2 == null) {
            return MimeType.MIME_NONE;
        }
        String string3 = string = string2.length() > 1024 ? string2.substring(0, 1024) : string2;
        if (this.cssDetector.isBodyCSS(iHttpResponse)) {
            return MimeType.MIME_ASC_CSS;
        }
        if (this.jsDetector.isBodyJavascript(iHttpResponse)) {
            return MimeType.MIME_ASC_JAVASCRIPT;
        }
        if (iHttpResponse.isMostlyAscii()) {
            return this.getSniffedMimeTypeForAscii(string);
        }
        return this.getSniffedMimeTypeForBinary(string);
    }

    MimeType getSniffedMimeTypeForAscii(String string) {
        if (string.startsWith("%!PS")) {
            return MimeType.MIME_ASC_POSTSCRIPT;
        }
        if (string.startsWith("{\\rtf")) {
            return MimeType.MIME_ASC_RTF;
        }
        if (string.startsWith("%PDF")) {
            return MimeType.MIME_EXT_PDF;
        }
        if (string.contains("<OpenSearch")) {
            return MimeType.MIME_XML_OPENSEARCH;
        }
        if (string.contains("<channel>") || string.contains("<description>") || string.contains("<item>") || string.contains("<rdf:RDF")) {
            return MimeType.MIME_XML_RSS;
        }
        if (string.contains("<feed") || string.contains("<updated>")) {
            return MimeType.MIME_XML_ATOM;
        }
        String string2 = string.toLowerCase();
        if (string2.contains("<wml") || string2.contains("<!doctype wml ")) {
            return MimeType.MIME_XML_WML;
        }
        if (string2.contains("<cross-domain-policy>")) {
            return MimeType.MIME_XML_CROSSDOMAIN;
        }
        if (string.contains("<?xml") || string.contains("<!DOCTYPE")) {
            if (string2.contains("<!doctype html") || string.contains("http://www.w3.org/1999/xhtml")) {
                return MimeType.MIME_XML_XHTML;
            }
            return MimeType.MIME_XML_GENERIC;
        }
        List<String> list = Arrays.asList("<html", "<meta", "<head", "<title", "<body", "</body", "<!doctype", "<--", "<style", "<script", "<font", "<span", "<div", "<img", "<form", "<br", "<td", "<h1", "<li", "<p>", "href=");
        for (String string3 : list) {
            if (!string2.contains(string3)) continue;
            return MimeType.MIME_ASC_HTML;
        }
        if (string.contains("<![CDATA[") || string.contains("</") || string.contains("/>")) {
            return MimeType.MIME_XML_GENERIC;
        }
        return MimeType.MIME_ASC_GENERIC;
    }

    MimeType getSniffedMimeTypeForBinary(String string) {
        char c = this.charAt(string, 0);
        char c2 = this.charAt(string, 1);
        char c3 = this.charAt(string, 2);
        char c4 = this.charAt(string, 3);
        if (c == '\u00ff' && c2 == '\u00d8' && c3 == '\u00ff') {
            return MimeType.MIME_IMG_JPEG;
        }
        if (string.startsWith("GIF8")) {
            return MimeType.MIME_IMG_GIF;
        }
        if (c == '\u0089' && string.startsWith("PNG", 1)) {
            return MimeType.MIME_IMG_PNG;
        }
        if (string.startsWith("BM")) {
            return MimeType.MIME_IMG_BMP;
        }
        if (string.startsWith("II") && c3 == '*') {
            return MimeType.MIME_IMG_TIFF;
        }
        if (string.startsWith("RIFF")) {
            if (this.charAt(string, 8) == 'A') {
                if (this.charAt(string, 9) == 'C') {
                    return MimeType.MIME_IMG_ANI;
                }
                return MimeType.MIME_AV_AVI;
            }
            return MimeType.MIME_AV_WAV;
        }
        if (c == '\u0000' && c2 == '\u0000' && c3 != '\u0000' && c4 == '\u0000') {
            return MimeType.MIME_IMG_BMP;
        }
        if (c == '0' && c2 == '&' && c3 == '\u00b2') {
            return MimeType.MIME_AV_WMEDIA;
        }
        if (c == '\u00ff' && c2 == '\u00fb') {
            return MimeType.MIME_AV_MP3;
        }
        if (c == '\u0000' && c2 == '\u0000' && c3 == '\u0001' && c4 >> 4 == 11) {
            return MimeType.MIME_AV_MPEG;
        }
        if (string.length() >= 4 && string.substring(0, 4).equalsIgnoreCase("OggS")) {
            return MimeType.MIME_AV_OGG;
        }
        if (c == '(' && string.startsWith("RMF", 1)) {
            return MimeType.MIME_AV_RA;
        }
        if (c == '.' && string.startsWith("RMF", 1)) {
            return MimeType.MIME_AV_RV;
        }
        if (string.startsWith("free", 4) || string.startsWith("mdat", 4) || string.startsWith("wide", 4) || string.startsWith("pnot", 4) || string.startsWith("skip", 4) || string.startsWith("moov", 4)) {
            return MimeType.MIME_AV_QT;
        }
        if (string.startsWith("FLV")) {
            return MimeType.MIME_AV_FLV;
        }
        if (string.startsWith("FCWS") || string.startsWith("CWS")) {
            return MimeType.MIME_EXT_FLASH;
        }
        if (string.startsWith("%PDF")) {
            return MimeType.MIME_EXT_PDF;
        }
        if (string.startsWith("PK") && c3 < '\u0006' && c4 < '\u0007') {
            if (string.contains("META-INF/")) {
                return MimeType.MIME_EXT_JAR;
            }
            return MimeType.MIME_BIN_ZIP;
        }
        if (c == '\u00ca' && c2 == '\u00fe' && c3 == '\u00ba' && c4 == '\u00be') {
            return MimeType.MIME_EXT_CLASS;
        }
        if (string.length() > 512 && c == '\u00d0' && c2 == '\u00cf' && c3 == '\u0011' && c4 == '\u00e0') {
            switch (string.charAt(512)) {
                case '\u00ec': {
                    return MimeType.MIME_EXT_WORD;
                }
                case '\t': 
                case '\u00fd': {
                    return MimeType.MIME_EXT_EXCEL;
                }
                case '\u0000': 
                case '\u000f': 
                case '\u00a0': {
                    return MimeType.MIME_EXT_PPNT;
                }
            }
        } else {
            if (c == '\u001f' && c2 == '\u008b' && c3 == '\b') {
                return MimeType.MIME_BIN_GZIP;
            }
            if (string.startsWith("MSCF") && this.charAt(string, 4) == '\u0000') {
                return MimeType.MIME_BIN_CAB;
            }
        }
        return MimeType.MIME_BIN_GENERIC;
    }

    char charAt(String string, int n) {
        if (n >= string.length()) {
            return '\uffff';
        }
        return string.charAt(n);
    }
}

