/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.search;

import com.subgraph.vega.ui.httpeditor.Colors;
import com.subgraph.vega.ui.httpeditor.highlights.MatchChangeListener;
import com.subgraph.vega.ui.httpeditor.highlights.MatchHighlighter;
import com.subgraph.vega.ui.httpeditor.highlights.NavigationButtons;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SearchBar
extends Composite
implements ModifyListener,
KeyListener,
VerifyKeyListener,
ITextInputListener,
MatchChangeListener {
    private static final int KEY_ESC = 27;
    private static final int KEY_F = 102;
    private static final String ANNOTATION_MATCH = "httpeditor.search_match";
    private final StyledText textControl;
    private final MatchHighlighter highlighter;
    private final Color noResultBackground;
    private final Text searchText;
    private final Color searchTextBackground;
    private final NavigationButtons buttons;

    public SearchBar(Composite composite, ProjectionViewer projectionViewer, Colors colors) {
        super(composite, 0);
        this.setLayout((Layout)new RowLayout(256));
        this.configureViewer((SourceViewer)projectionViewer);
        this.textControl = projectionViewer.getTextWidget();
        this.highlighter = new MatchHighlighter(projectionViewer, colors.get(Colors.HIGHLIGHT_SEARCH_MATCH), ANNOTATION_MATCH, true);
        this.noResultBackground = colors.get(Colors.NO_SEARCH_RESULT_TEXT_BACKGROUND);
        this.searchText = this.createSearchText();
        this.searchTextBackground = this.searchText.getBackground();
        this.buttons = new NavigationButtons(this, this.highlighter, this);
        this.pack();
        this.hideSearchBar();
    }

    private void configureViewer(SourceViewer sourceViewer) {
        sourceViewer.addTextInputListener((ITextInputListener)this);
        sourceViewer.prependVerifyKeyListener((VerifyKeyListener)this);
    }

    private Text createSearchText() {
        Text text = new Text((Composite)this, 2052);
        text.setLayoutData((Object)new RowData(150, -1));
        text.addModifyListener((ModifyListener)this);
        text.addKeyListener((KeyListener)this);
        text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                SearchBar.this.handleKeyEnter();
            }
        });
        return text;
    }

    private void handleKeyEnter() {
        if (this.searchText.getText().isEmpty()) {
            return;
        }
        if (!this.highlighter.isActive()) {
            this.performSearch(this.searchText.getText());
        } else if (this.highlighter.hasNextMatch()) {
            this.buttons.handleNextMatch();
        } else if (this.highlighter.getMatchCount() > 1) {
            this.handleFirstMatch();
        }
    }

    private void handleFirstMatch() {
        if (this.highlighter.isActive() && this.highlighter.getMatchCount() != 0) {
            this.highlighter.displayFirstMatch();
        }
        this.buttons.enableButtonsForMatchState();
        this.summarizeSearchResult();
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (this.searchText.getText().isEmpty()) {
            this.highlighter.clearMatches();
            this.buttons.enableButtonsForMatchState();
            this.summarizeSearchResult();
            return;
        }
        this.performSearch(this.searchText.getText());
    }

    private void performSearch(String string) {
        this.highlighter.clearMatches();
        this.highlighter.searchMatches(string, false, false);
        this.handleFirstMatch();
    }

    private void summarizeSearchResult() {
        if (!this.highlighter.isActive()) {
            this.clearResultSummary();
            return;
        }
        if (this.highlighter.getMatchCount() == 0) {
            this.searchText.setToolTipText("No results found.");
            this.searchText.setBackground(this.noResultBackground);
            return;
        }
        this.searchText.setBackground(this.searchTextBackground);
        this.searchText.setToolTipText("(" + (this.highlighter.getCurrentIndex() + 1) + " of " + this.highlighter.getMatchCount() + ") results");
    }

    private void clearResultSummary() {
        if (!this.searchText.isDisposed()) {
            this.searchText.setToolTipText(null);
            this.searchText.setBackground(this.searchTextBackground);
        }
    }

    private void clearCurrentSearch() {
        this.highlighter.clearMatches();
        this.clearResultSummary();
        this.buttons.enableButtonsForMatchState();
    }

    public void inputDocumentAboutToBeChanged(IDocument iDocument, IDocument iDocument2) {
        this.clearCurrentSearch();
    }

    public void inputDocumentChanged(IDocument iDocument, IDocument iDocument2) {
    }

    private boolean isEventCtrlF(KeyEvent keyEvent) {
        return (keyEvent.stateMask & SWT.MOD1) != 0 && keyEvent.keyCode == 102;
    }

    private boolean isEventEscape(KeyEvent keyEvent) {
        return keyEvent.keyCode == 27;
    }

    private void toggleSearchBar() {
        if (this.isVisible()) {
            this.hideSearchBar();
            this.textControl.setFocus();
        } else {
            this.displaySearchBar();
        }
    }

    private void hideSearchBar() {
        this.clearCurrentSearch();
        this.setVisible(false);
        this.getParent().layout(true);
    }

    private void displaySearchBar() {
        this.setVisible(true);
        this.pack();
        this.getParent().layout(true);
        this.setFocus();
    }

    public void verifyKey(VerifyEvent verifyEvent) {
        if (this.isEventCtrlF((KeyEvent)verifyEvent)) {
            this.toggleSearchBar();
        }
        if (this.isEventEscape((KeyEvent)verifyEvent)) {
            this.hideSearchBar();
            this.textControl.setFocus();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.isEventCtrlF(keyEvent) || this.isEventEscape(keyEvent)) {
            this.hideSearchBar();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void matchChanged() {
        this.summarizeSearchResult();
    }
}

