/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.html;

import com.subgraph.vega.ui.httpeditor.Colors;
import com.subgraph.vega.ui.httpeditor.ITextEntityRenderer;
import com.subgraph.vega.ui.httpeditor.html.StartTagRule;
import com.subgraph.vega.ui.httpeditor.html.TagScanner;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;

public class HtmlTextEntityRenderer
implements ITextEntityRenderer {
    public static final String HTML_COMMENT = "html_comment";
    public static final String HTML_DOCTYPE = "html_doctype";
    public static final String HTML_START_TAG = "html_start_tag";
    public static final String HTML_END_TAG = "html_end_tag";
    public static final String[] HTML_TYPES = new String[]{"html_comment", "html_doctype", "html_start_tag", "html_end_tag"};

    @Override
    public List<String> getPartitionTypes() {
        return Arrays.asList(HTML_TYPES);
    }

    @Override
    public boolean matchContentType(String string) {
        return string.contains("html");
    }

    @Override
    public void addPartitionScannerRules(List<IPredicateRule> list) {
        list.add((IPredicateRule)new MultiLineRule("<!--", "-->", (IToken)new Token((Object)HTML_COMMENT)));
        list.add((IPredicateRule)new MultiLineRule("</", ">", (IToken)new Token((Object)HTML_END_TAG)));
        Token token = new Token((Object)HTML_START_TAG);
        list.add((IPredicateRule)new StartTagRule((IToken)token));
        list.add((IPredicateRule)new StartTagRule((IToken)token));
        list.add((IPredicateRule)new MultiLineRule("<!DOCTYPE", ">", (IToken)new Token((Object)HTML_DOCTYPE)));
    }

    @Override
    public void configurePresentationReconciler(PresentationReconciler presentationReconciler, Colors colors) {
        this.addDamagerRepairer(presentationReconciler, (ITokenScanner)new TagScanner(colors), HTML_START_TAG);
        this.addDamagerRepairer(presentationReconciler, (ITokenScanner)new TagScanner(colors), HTML_END_TAG);
        this.addDamagerRepairer(presentationReconciler, colors.get(Colors.MULTI_LINE_COMMENT), HTML_COMMENT);
        this.addDamagerRepairer(presentationReconciler, colors.get(Colors.MULTI_LINE_COMMENT), HTML_DOCTYPE);
        this.addDamagerRepairer(presentationReconciler, colors.get(Colors.OTHER), "__dftl_partition_content_type");
    }

    private void addDamagerRepairer(PresentationReconciler presentationReconciler, Color color, String string) {
        TextAttribute textAttribute = new TextAttribute(color);
        this.addDamagerRepairer(presentationReconciler, (ITokenScanner)new SingleTokenScanner(textAttribute), string);
    }

    private void addDamagerRepairer(PresentationReconciler presentationReconciler, ITokenScanner iTokenScanner, String string) {
        DefaultDamagerRepairer defaultDamagerRepairer = new DefaultDamagerRepairer(iTokenScanner);
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, string);
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, string);
    }

    @Override
    public String formatText(String string) {
        return string;
    }

    @Override
    public String getLineSplitChars() {
        return ">,";
    }

    @Override
    public String getDefaultPartitionType() {
        return null;
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute textAttribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)textAttribute));
        }
    }
}

