/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.highlights;

import com.subgraph.vega.ui.httpeditor.highlights.CornerLayoutData;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CornerLayout
extends Layout {
    private final Composite textControl;

    public CornerLayout(StyledText styledText) {
        this.textControl = styledText;
    }

    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        Control control = this.getBackgroundControl(composite);
        Point point = control.computeSize(n, n2, bl);
        int n3 = this.getSize(point.x, n);
        int n4 = this.getSize(point.y, n2);
        return new Point(n3, n4);
    }

    private int getSize(int n, int n2) {
        return n2 == -1 ? n : n2;
    }

    protected void layout(Composite composite, boolean bl) {
        Control control = this.getBackgroundControl(composite);
        Rectangle rectangle = composite.getClientArea();
        control.setBounds(rectangle);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control2 = controlArray[n2];
            if (control2 != control) {
                this.placeControl(composite, control2);
            }
            ++n2;
        }
    }

    private void placeControl(Composite composite, Control control) {
        Object object = control.getLayoutData();
        if (!(object instanceof CornerLayoutData)) {
            return;
        }
        Point point = this.calculateControlPosition(composite, control, (CornerLayoutData)object);
        control.setLocation(point);
    }

    private Point calculateControlPosition(Composite composite, Control control, CornerLayoutData cornerLayoutData) {
        Rectangle rectangle = this.textControl.getClientArea();
        int n = this.getPosition(cornerLayoutData.isLeft(), rectangle.width, control.getSize().x);
        int n2 = this.getPosition(cornerLayoutData.isTop(), rectangle.height, control.getSize().y);
        return control.getDisplay().map((Control)this.textControl, (Control)composite, n, n2);
    }

    private int getPosition(boolean bl, int n, int n2) {
        if (bl || n < n2) {
            return 0;
        }
        return n - n2;
    }

    protected boolean flushCache(Control control) {
        return true;
    }

    private Control getBackgroundControl(Composite composite) {
        this.checkZOrder(composite);
        Control[] controlArray = composite.getChildren();
        int n = this.findBackgroundControlIdx(controlArray);
        return controlArray[n];
    }

    private void checkZOrder(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = this.findBackgroundControlIdx(controlArray);
        if (n != controlArray.length - 1) {
            controlArray[n].moveBelow(null);
        }
    }

    private int findBackgroundControlIdx(Control[] controlArray) {
        int n = -1;
        int n2 = 0;
        while (n2 < controlArray.length) {
            if (!(controlArray[n2].getLayoutData() instanceof CornerLayoutData)) {
                if (n >= 0) {
                    throw new IllegalStateException("All children of composite managed by CornerLayout must have CornerLayoutData except background control");
                }
                n = n2;
            }
            ++n2;
        }
        if (n < 0) {
            throw new IllegalStateException("Could not find background control");
        }
        return n;
    }
}

