/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor;

import com.subgraph.vega.ui.httpeditor.HttpMessageDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;

public class HeaderDecoder {
    private static final String DECODED_CHAR_CATEGORY = "__decoded_char_category";
    private final HttpMessageDocument messageDocument;
    private boolean decodeState = false;
    private final String HEX_DIGITS = "01234567890abcdef";

    HeaderDecoder(HttpMessageDocument httpMessageDocument) {
        this.messageDocument = httpMessageDocument;
        this.messageDocument.getDocument().addPositionCategory(DECODED_CHAR_CATEGORY);
        this.messageDocument.getDocument().addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater(DECODED_CHAR_CATEGORY));
    }

    public void toggleDecodeState() {
        boolean bl = this.decodeState = !this.decodeState;
        if (this.decodeState) {
            this.decodeHeaders();
        } else {
            this.undecodeHeaders();
        }
    }

    public void decodeHeaders() {
        try {
            this.decode();
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("Bad location in document decoding header", badLocationException);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            throw new RuntimeException("Position category does not exist in HeaderDecoder", badPositionCategoryException);
        }
    }

    public void undecodeHeaders() {
        try {
            this.encode();
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            throw new RuntimeException("Bad location in document decoding header", badPositionCategoryException);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("Position category does not exist in HeaderDecoder", badLocationException);
        }
    }

    public String getUndecodedHeaderContent() {
        try {
            if (!this.decodeState) {
                return this.getHeaderSectionText();
            }
            return this.getEncodedHeaderSectionText();
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("Bad location getting undecoded header content");
        }
    }

    private String getHeaderSectionText() throws BadLocationException {
        Position position = this.messageDocument.getHeaderSection();
        return this.messageDocument.getDocument().get(position.getOffset(), position.getLength());
    }

    private String getEncodedHeaderSectionText() throws BadLocationException {
        Position position = this.messageDocument.getHeaderSection();
        int n = position.getOffset();
        int n2 = n + position.getLength();
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n;
        while (n3 < n2) {
            char c = this.getCharAt(n3);
            if (this.messageDocument.getDocument().containsPosition(DECODED_CHAR_CATEGORY, n3, 1)) {
                stringBuilder.append(this.getEncodedCharacter(c));
            } else {
                stringBuilder.append(c);
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    private void decode() throws BadLocationException, BadPositionCategoryException {
        Position position = this.messageDocument.getHeaderSection();
        Position position2 = new Position(position.getOffset(), position.getLength());
        while (position2.getLength() > 0) {
            char c = this.getCharAt(position2.getOffset());
            this.consumeRemaining(position2, 1);
            if (c != '%') continue;
            this.processPercent(position2);
        }
    }

    private void processPercent(Position position) throws BadLocationException, BadPositionCategoryException {
        if (position.getLength() <= 0) {
            return;
        }
        char c = this.getCharAt(position.getOffset());
        if (c == '%') {
            this.replaceDecodedChar(position.getOffset() - 1, 2, '%');
            --position.length;
            return;
        }
        if (!this.isHex(c) || position.getLength() == 1) {
            return;
        }
        char c2 = this.getCharAt(position.getOffset() + 1);
        if (!this.isHex(c2)) {
            return;
        }
        char c3 = this.hexDecode(c, c2);
        this.replaceDecodedChar(position.getOffset() - 1, 3, c3);
        position.length -= 2;
    }

    private void consumeRemaining(Position position, int n) {
        position.offset += n;
        position.length -= n;
    }

    private void replaceDecodedChar(int n, int n2, char c) throws BadLocationException, BadPositionCategoryException {
        this.messageDocument.getDocument().replace(n, n2, String.valueOf(c));
        this.messageDocument.getDocument().addPosition(DECODED_CHAR_CATEGORY, new Position(n, 1));
    }

    private char getCharAt(int n) throws BadLocationException {
        return this.messageDocument.getDocument().getChar(n);
    }

    private boolean isHex(char c) {
        return "01234567890abcdef".indexOf(Character.toLowerCase(c)) != -1;
    }

    private char hexDecode(char c, char c2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(c);
        stringBuilder.append(c2);
        return (char)Integer.parseInt(stringBuilder.toString(), 16);
    }

    private void encode() throws BadPositionCategoryException, BadLocationException {
        Position[] positionArray;
        Position[] positionArray2 = positionArray = this.messageDocument.getDocument().getPositions(DECODED_CHAR_CATEGORY);
        int n = positionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Position position = positionArray2[n2];
            char c = this.getCharAt(position.getOffset());
            this.messageDocument.getDocument().replace(position.getOffset(), position.getLength(), this.getEncodedCharacter(c));
            this.messageDocument.getDocument().removePosition(DECODED_CHAR_CATEGORY, position);
            ++n2;
        }
    }

    private String getEncodedCharacter(char c) {
        if (c == '%') {
            return "%%";
        }
        return "%" + this.hexEncode(c);
    }

    private String hexEncode(char c) {
        return String.format("%02X", c);
    }
}

