/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.application.update;

import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.http.requests.IHttpRequestEngineConfig;
import com.subgraph.vega.api.http.requests.IHttpRequestEngineFactory;
import com.subgraph.vega.api.http.requests.IHttpRequestTask;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.http.requests.RequestEngineException;
import com.subgraph.vega.application.Activator;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.HttpUriRequest;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class UpdateCheckTask
implements Runnable {
    private static final String REPONSE_UPDATE_AVAILABLE = "UPDATE";
    private static final String DEBIAN_VERSION = "/etc/debian_version";
    private static final String DOWNLOAD_URL = "http://subgraph.com/vega_download.php";
    private static final String UPDATE_MESSAGE = "A new version of Vega is available for download from the Subgraph website.\nhttp://subgraph.com/vega_download.php";
    private static final String DIST_UPDATE_MESSAGE = "A new version of Vega is available. Please use your distro update tools to update. For Debian-based systems such as Kali Linux, run apt-get update and then apt-get upgrade.";
    private final Shell shell;
    private final int buildNumber;
    private String versionPrefix = "";
    private boolean distro = false;

    public UpdateCheckTask(Shell shell, int n) {
        this.shell = shell;
        this.buildNumber = n;
    }

    @Override
    public void run() {
        this.checkDebianRelease();
        IHttpRequestEngine iHttpRequestEngine = this.createRequestEngine();
        IHttpResponse iHttpResponse = this.sendRequest(iHttpRequestEngine);
        if (iHttpResponse != null && !iHttpResponse.getBodyAsString().isEmpty()) {
            this.processResponseBody(iHttpResponse.getBodyAsString());
        }
    }

    private IHttpResponse sendRequest(IHttpRequestEngine iHttpRequestEngine) {
        HttpHost httpHost = this.createTargetHost();
        String string = this.createUriPath();
        HttpUriRequest httpUriRequest = iHttpRequestEngine.createGetRequest(httpHost, string);
        IHttpRequestTask iHttpRequestTask = iHttpRequestEngine.sendRequest(httpUriRequest);
        try {
            return iHttpRequestTask.get(true);
        }
        catch (RequestEngineException requestEngineException) {
            return null;
        }
    }

    private void processResponseBody(String string) {
        if (!REPONSE_UPDATE_AVAILABLE.equalsIgnoreCase(string)) {
            return;
        }
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                UpdateCheckTask.this.displayUpdateDialog();
            }
        });
    }

    private void displayUpdateDialog() {
        if (!this.distro) {
            MessageDialog messageDialog = new MessageDialog(null, "Update Available", null, UPDATE_MESSAGE, 2, new String[]{"Ok", "Open Download Page"}, 0);
            if (messageDialog.open() == 1) {
                this.openDownloadPage();
            }
        } else {
            MessageDialog messageDialog = new MessageDialog(null, "Updated Vega Package Available", null, DIST_UPDATE_MESSAGE, 2, new String[]{"Ok"}, 0);
            messageDialog.open();
        }
    }

    private void openDownloadPage() {
        try {
            IWebBrowser iWebBrowser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
            URL uRL = new URL(DOWNLOAD_URL);
            iWebBrowser.openURL(uRL);
        }
        catch (Exception exception) {}
    }

    private IHttpRequestEngine createRequestEngine() {
        IHttpRequestEngineFactory iHttpRequestEngineFactory = Activator.getDefault().getHttpRequestEngineFactoryService();
        IHttpRequestEngineConfig iHttpRequestEngineConfig = iHttpRequestEngineFactory.createConfig();
        return iHttpRequestEngineFactory.createRequestEngine(IHttpRequestEngine.EngineConfigType.CONFIG_SCANNER, iHttpRequestEngineConfig, null);
    }

    private HttpHost createTargetHost() {
        return new HttpHost("support.subgraph.com", -1, "https");
    }

    private String createUriPath() {
        return "/update-check.php?build=" + this.versionPrefix + this.buildNumber;
    }

    private void checkDebianRelease() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(DEBIAN_VERSION));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.startsWith("Kali Linux 1.0")) continue;
                this.versionPrefix = "kl-1.0-";
                this.distro = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
    }
}

