/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.web.views;

import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.scope.ITargetScope;
import com.subgraph.vega.api.model.web.IWebHost;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.model.web.IWebResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;

public abstract class AbstractScopeAction
extends Action {
    protected final IModel model;
    protected final StructuredViewer viewer;

    AbstractScopeAction(StructuredViewer structuredViewer, IModel iModel, String string) {
        this.model = iModel;
        this.viewer = structuredViewer;
        this.setText(string);
    }

    protected abstract void handleSelectedURI(ITargetScope var1, URI var2);

    protected abstract boolean isEnabledForURIs(ITargetScope var1, List<URI> var2);

    public void run() {
        ITargetScope iTargetScope = this.getCurrentActiveScope();
        if (iTargetScope == null) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
        for (Object e : iStructuredSelection.toList()) {
            URI uRI = this.elementToURI(e);
            if (uRI == null) continue;
            this.handleSelectedURI(iTargetScope, uRI);
        }
    }

    public boolean isEnabledForSelection() {
        ITargetScope iTargetScope = this.getCurrentActiveScope();
        if (iTargetScope == null) {
            return false;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
        ArrayList<URI> arrayList = new ArrayList<URI>();
        for (Object e : iStructuredSelection.toList()) {
            URI uRI = this.elementToURI(e);
            if (uRI == null) continue;
            arrayList.add(uRI);
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        return this.isEnabledForURIs(iTargetScope, arrayList);
    }

    private ITargetScope getCurrentActiveScope() {
        IWorkspace iWorkspace = this.model.getCurrentWorkspace();
        if (iWorkspace == null) {
            return null;
        }
        return iWorkspace.getTargetScopeManager().getActiveScope();
    }

    private URI elementToURI(Object object) {
        if (object instanceof IWebHost) {
            return ((IWebHost)object).getUri();
        }
        if (object instanceof IWebPath) {
            return ((IWebPath)object).getUri();
        }
        if (object instanceof IWebResponse) {
            return ((IWebResponse)object).getPathEntity().getUri();
        }
        return null;
    }
}

