/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.tags.tageditor;

import com.subgraph.vega.internal.ui.tags.taggableeditor.TagModifier;
import com.subgraph.vega.ui.tagsl.taggablepopup.ITagModifierValidator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TagEditorDialog
extends TitleAreaDialog {
    private final ITagModifierValidator validator;
    private final TagModifier tag;
    private Composite parentComposite;
    private boolean tagModified;
    private Text tagNameText;
    private Text tagDescText;
    private ColorSelector nameColorSelector;
    private ColorSelector rowColorSelector;

    public static TagEditorDialog createDialog(Shell shell, TagModifier tagModifier, ITagModifierValidator iTagModifierValidator) {
        TagEditorDialog tagEditorDialog = new TagEditorDialog(shell, tagModifier, iTagModifierValidator);
        tagEditorDialog.create();
        tagEditorDialog.getShell().addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    event.doit = false;
                }
            }
        });
        return tagEditorDialog;
    }

    private TagEditorDialog(Shell shell, TagModifier tagModifier, ITagModifierValidator iTagModifierValidator) {
        super(shell);
        this.tag = tagModifier;
        this.validator = iTagModifierValidator;
    }

    public void create() {
        super.create();
        this.setTitle("Edit Tag");
        this.setMessage("Edit the properties of the tag below.");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.parentComposite = new Composite(composite2, 0);
        this.parentComposite.setLayout((Layout)new GridLayout(1, false));
        this.parentComposite.setLayoutData((Object)new GridData(1808));
        this.createArea(this.parentComposite).setLayoutData((Object)new GridData(1808));
        return composite2;
    }

    protected void okPressed() {
        this.tag.setName(this.tagNameText.getText().trim());
        this.tag.setDescription(this.tagDescText.getText().trim());
        this.tag.setNameColor(this.rgbToTagColor(this.nameColorSelector.getColorValue()));
        this.tag.setRowColor(this.rgbToTagColor(this.rowColorSelector.getColorValue()));
        String string = this.validator.validate(this.tag);
        this.setErrorMessage(string);
        if (string != null) {
            return;
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        if (this.tagModified && !this.confirmLoseTagModification()) {
            return;
        }
        super.cancelPressed();
    }

    private GridLayout createGaplessGridLayout(int n, boolean bl) {
        GridLayout gridLayout = new GridLayout(n, bl);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = 0;
        return gridLayout;
    }

    private Group createArea(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText("Tag Information");
        this.createNameControl((Composite)group).setLayoutData((Object)new GridData(1808));
        this.createDescControl((Composite)group).setLayoutData((Object)new GridData(1808));
        this.createColorControl((Composite)group).setLayoutData((Object)new GridData(1808));
        this.setTagFields();
        return group;
    }

    private Composite createNameControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)this.createGaplessGridLayout(2, false));
        Label label = new Label(composite2, 0);
        label.setText("Name:");
        label.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.tagNameText = new Text(composite2, 2052);
        this.tagNameText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.tagNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                TagEditorDialog.this.tagModified = true;
            }
        });
        return composite2;
    }

    private Composite createDescControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)this.createGaplessGridLayout(1, false));
        Label label = new Label(composite2, 0);
        label.setText("Description:");
        this.tagDescText = new Text(composite2, 2626);
        FontMetrics fontMetrics = new GC((Drawable)this.tagDescText).getFontMetrics();
        GridData gridData = new GridData(4, 4, true, false, 1, 1);
        gridData.heightHint = fontMetrics.getHeight() * 5;
        this.tagDescText.setLayoutData((Object)gridData);
        this.tagDescText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                TagEditorDialog.this.tagModified = true;
            }
        });
        return composite2;
    }

    private Composite createColorControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)this.createGaplessGridLayout(2, false));
        Label label = new Label(composite2, 0);
        label.setText("Name color:");
        this.nameColorSelector = new ColorSelector(composite2);
        this.nameColorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("colorValue")) {
                    TagEditorDialog.this.tagModified = true;
                }
            }
        });
        label = new Label(composite2, 0);
        label.setText("Row background color:");
        this.rowColorSelector = new ColorSelector(composite2);
        this.rowColorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("colorValue")) {
                    TagEditorDialog.this.tagModified = true;
                }
            }
        });
        return composite2;
    }

    private void setTagFields() {
        if (this.tag.getName() != null) {
            this.tagNameText.setText(this.tag.getName());
        } else {
            this.tagNameText.setText("");
        }
        if (this.tag.getDescription() != null) {
            this.tagDescText.setText(this.tag.getDescription());
        } else {
            this.tagDescText.setText("");
        }
        this.nameColorSelector.setColorValue(this.tagColorToRgb(this.tag.getNameColor()));
        this.rowColorSelector.setColorValue(this.tagColorToRgb(this.tag.getRowColor()));
        this.tagModified = false;
    }

    private RGB tagColorToRgb(int n) {
        return new RGB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    private int rgbToTagColor(RGB rGB) {
        return rGB.red << 16 | rGB.green << 8 | rGB.blue;
    }

    private boolean confirmLoseTagModification() {
        MessageBox messageBox = new MessageBox(this.getShell(), 292);
        messageBox.setText("Warning");
        messageBox.setMessage("Changes were made to the tag. Proceed without saving?");
        return messageBox.open() != 256;
    }
}

