/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.requestfilters;

import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.conditions.IHttpCondition;
import com.subgraph.vega.api.model.conditions.IHttpConditionManager;
import com.subgraph.vega.api.model.conditions.IHttpConditionSet;
import com.subgraph.vega.api.model.conditions.IHttpConditionType;
import com.subgraph.vega.ui.http.Activator;
import com.subgraph.vega.ui.http.requestfilters.ConditionCreateDialog;
import com.subgraph.vega.ui.http.requestfilters.ConditionTreeContentProvider;
import com.subgraph.vega.ui.http.requestfilters.ConditionTreeLabelProvider;
import com.subgraph.vega.ui.util.dialogs.IConfigDialogContent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RequestFilterConfigContent
implements IConfigDialogContent {
    private final String conditionSetId;
    private Composite composite;
    private TreeViewer treeViewer;
    private IHttpConditionManager conditionManager;
    private IHttpConditionSet conditionSet;
    private boolean conditionSetDirty;

    public RequestFilterConfigContent(String string) {
        this.conditionSetId = string != null ? "filter." + string : "filter";
    }

    public String getTitle() {
        return "Configure Request View Filters";
    }

    public String getMessage() {
        return "Create and remove filters which will control the displayed HTTP request and response records.";
    }

    public Control getFocusControl() {
        return this.composite;
    }

    public void onClose() {
    }

    public void onOk() {
        if (this.conditionSetDirty) {
            this.conditionManager.saveConditionSet(this.conditionSetId, this.conditionSet);
            this.conditionSetDirty = false;
        }
    }

    public Composite createContents(Composite composite) {
        this.composite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 10;
        gridLayout.verticalSpacing = 20;
        this.composite.setLayout((Layout)gridLayout);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(this.composite, 64);
        label.setText("Filter out information displayed in the Requests table within the Proxy.");
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite composite2 = new Composite(this.composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(4, 4, true, true);
        composite2.setLayoutData((Object)gridData);
        this.createTreeViewer(composite2);
        this.createTreeViewerButtons(composite2);
        IWorkspace iWorkspace = Activator.getDefault().getModel().getCurrentWorkspace();
        if (iWorkspace != null) {
            this.conditionManager = iWorkspace.getHttpConditionMananger();
            this.conditionSet = this.conditionManager.getConditionSetCopy(this.conditionSetId);
        } else {
            this.conditionManager = null;
            this.conditionSet = null;
        }
        this.treeViewer.setInput((Object)this.conditionSet);
        return this.composite;
    }

    private void createTreeViewer(Composite composite) {
        this.treeViewer = new TreeViewer(composite, 2818);
        this.treeViewer.setContentProvider((IContentProvider)new ConditionTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConditionTreeLabelProvider());
        this.treeViewer.setAutoExpandLevel(2);
        GridData gridData = new GridData(4, 4, true, true, 1, 3);
        gridData.heightHint = 300;
        this.treeViewer.getTree().setLayoutData((Object)gridData);
    }

    private void createTreeViewerButtons(Composite composite) {
        Button button = new Button(composite, 8);
        button.setText("create");
        button.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        button.addSelectionListener(this.createSelectionListenerButtonCreate());
        button = new Button(composite, 8);
        button.setText("remove");
        button.setLayoutData((Object)new GridData(128, 0x1000000, false, false));
        button.addSelectionListener(this.createSelectionListenerButtonRemove());
    }

    private SelectionListener createSelectionListenerButtonCreate() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RequestFilterConfigContent.this.openConditionCreateDialog();
            }
        };
    }

    private SelectionListener createSelectionListenerButtonRemove() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)RequestFilterConfigContent.this.treeViewer.getSelection();
                for (Object e : iStructuredSelection.toList()) {
                    if (e instanceof IHttpCondition) {
                        RequestFilterConfigContent.this.conditionSet.removeCondition((IHttpCondition)e, false);
                        RequestFilterConfigContent.this.conditionSetDirty = true;
                    } else if (e instanceof IHttpConditionType) {
                        IHttpConditionType iHttpConditionType = (IHttpConditionType)e;
                        for (IHttpCondition iHttpCondition : RequestFilterConfigContent.this.conditionSet.getAllConditions()) {
                            if (iHttpCondition.getType() != iHttpConditionType) continue;
                            RequestFilterConfigContent.this.conditionSet.removeCondition(iHttpCondition, false);
                            RequestFilterConfigContent.this.conditionSetDirty = true;
                        }
                    }
                    if (!RequestFilterConfigContent.this.conditionSetDirty) continue;
                    RequestFilterConfigContent.this.conditionSet.notifyChanged();
                }
                RequestFilterConfigContent.this.treeViewer.refresh();
            }
        };
    }

    private void openConditionCreateDialog() {
        IHttpCondition iHttpCondition;
        if (this.conditionSet == null || this.conditionManager == null) {
            return;
        }
        ConditionCreateDialog conditionCreateDialog = new ConditionCreateDialog(null, this.conditionManager);
        conditionCreateDialog.setBlockOnOpen(true);
        if (conditionCreateDialog.open() == 0 && (iHttpCondition = conditionCreateDialog.getNewCondition()) != null) {
            this.conditionSet.appendCondition(iHttpCondition, true);
            this.conditionSetDirty = true;
            this.treeViewer.refresh();
            this.treeViewer.expandToLevel((Object)iHttpCondition, -1);
        }
    }
}

