/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.requesteditviewer;

import com.subgraph.vega.api.analysis.IContentAnalyzer;
import com.subgraph.vega.api.analysis.IContentAnalyzerFactory;
import com.subgraph.vega.api.http.requests.IHttpMessageBuilder;
import com.subgraph.vega.api.http.requests.IHttpRequestBuilder;
import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.http.requests.IHttpRequestEngineFactory;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import com.subgraph.vega.api.model.requests.IRequestOrigin;
import com.subgraph.vega.ui.http.Activator;
import com.subgraph.vega.ui.http.builder.HeaderEditor;
import com.subgraph.vega.ui.http.builder.IHttpBuilderPart;
import com.subgraph.vega.ui.http.builder.RequestEditor;
import com.subgraph.vega.ui.http.requesteditviewer.SendRequestTask;
import com.subgraph.vega.ui.httpeditor.HttpMessageEditor;
import java.net.URISyntaxException;
import org.apache.http.client.methods.HttpUriRequest;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.part.ViewPart;

public class RequestEditView
extends ViewPart {
    public static final String VIEW_ID = "com.subgraph.vega.views.requestEdit";
    private IHttpRequestEngine requestEngine;
    private IHttpRequestBuilder requestBuilder;
    private IContentAnalyzer contentAnalyzer;
    private SashForm parentComposite;
    private IHttpBuilderPart requestBuilderPartCurr;
    private RequestEditor requestEditor;
    private HeaderEditor requestHeaderEditor;
    private TabFolder requestTabFolder;
    private TabItem requestTabItem;
    private TabItem requestHeaderTabItem;
    private TabItem requestTabFolderItem;
    private HttpMessageEditor responseViewer;

    public RequestEditView() {
        IContentAnalyzerFactory iContentAnalyzerFactory = Activator.getDefault().getContentAnalyzerFactoryService();
        IWorkspace iWorkspace = Activator.getDefault().getModel().getCurrentWorkspace();
        if (iWorkspace != null) {
            this.contentAnalyzer = iContentAnalyzerFactory.createContentAnalyzer(iWorkspace.getScanAlertRepository().getProxyScanInstance());
            this.contentAnalyzer.setDefaultAddToRequestLog(true);
            this.contentAnalyzer.setAddLinksToModel(true);
        }
        IRequestOrigin iRequestOrigin = iWorkspace.getRequestLog().getRequestOriginRequestEditor();
        IHttpRequestEngineFactory iHttpRequestEngineFactory = Activator.getDefault().getHttpRequestEngineFactoryService();
        this.requestEngine = iHttpRequestEngineFactory.createRequestEngine(IHttpRequestEngine.EngineConfigType.CONFIG_PROXY, iHttpRequestEngineFactory.createConfig(), iRequestOrigin);
        this.requestBuilder = iHttpRequestEngineFactory.createRequestBuilder();
    }

    public void createPartControl(Composite composite) {
        this.parentComposite = new SashForm(composite, 512);
        this.createRequestEditor((Composite)this.parentComposite);
        this.createResponseViewer((Composite)this.parentComposite);
        this.parentComposite.setWeights(new int[]{50, 50});
        this.parentComposite.pack();
    }

    public void setFocus() {
        if (this.parentComposite != null) {
            this.parentComposite.setFocus();
        }
    }

    public void setRequest(IRequestLogRecord iRequestLogRecord) throws URISyntaxException {
        if (iRequestLogRecord != null) {
            this.requestBuilder.setFromRequest(iRequestLogRecord);
        } else {
            this.requestBuilder.clear();
        }
        if (this.requestBuilderPartCurr != null) {
            this.requestBuilderPartCurr.refresh();
        }
    }

    private void displayError(String string) {
        MessageBox messageBox = new MessageBox(this.parentComposite.getShell(), 40);
        messageBox.setText("Error");
        if (string == null) {
            string = "Unexpected error occurred";
        }
        messageBox.setMessage(string);
        messageBox.open();
    }

    void displayExceptionError(Exception exception) {
        if (exception.getMessage() != null) {
            this.displayError(exception.getMessage());
        } else {
            this.displayError(exception.getCause().getMessage());
        }
    }

    public void sendRequest() {
        HttpUriRequest httpUriRequest;
        if (this.requestBuilderPartCurr != null) {
            try {
                this.requestBuilderPartCurr.processContents();
            }
            catch (Exception exception) {
                this.displayExceptionError(exception);
                return;
            }
        }
        try {
            httpUriRequest = this.requestBuilder.buildRequest(true);
        }
        catch (Exception exception) {
            this.displayExceptionError(exception);
            return;
        }
        SendRequestTask sendRequestTask = new SendRequestTask(httpUriRequest, this, this.requestEngine);
        sendRequestTask.start();
    }

    void processResponse(IHttpResponse iHttpResponse) {
        this.displayResponse(iHttpResponse);
        if (this.contentAnalyzer != null && iHttpResponse != null) {
            this.contentAnalyzer.processResponse(iHttpResponse);
        }
    }

    private void displayResponse(final IHttpResponse iHttpResponse) {
        if (this.parentComposite == null || this.parentComposite.isDisposed()) {
            return;
        }
        this.parentComposite.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (iHttpResponse != null) {
                    RequestEditView.this.responseViewer.displayHttpResponse(iHttpResponse.getRawResponse());
                }
                if (RequestEditView.this.requestBuilderPartCurr != null) {
                    RequestEditView.this.requestBuilderPartCurr.refresh();
                }
            }
        });
    }

    private Composite createRequestEditor(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FillLayout());
        this.requestTabFolder = new TabFolder(composite2, 128);
        this.requestTabItem = new TabItem(this.requestTabFolder, 0);
        this.requestTabItem.setText("Request");
        this.requestEditor = new RequestEditor((Composite)this.requestTabFolder, this.requestBuilder);
        this.requestTabItem.setControl((Control)this.requestEditor);
        this.requestTabItem.setData((Object)this.requestEditor);
        this.requestHeaderTabItem = new TabItem(this.requestTabFolder, 0);
        this.requestHeaderTabItem.setText("Headers");
        this.requestHeaderEditor = new HeaderEditor((Composite)this.requestTabFolder, (IHttpMessageBuilder)this.requestBuilder, 0);
        this.requestHeaderTabItem.setControl((Control)this.requestHeaderEditor);
        this.requestHeaderTabItem.setData((Object)this.requestHeaderEditor);
        this.requestTabFolder.addSelectionListener(this.createRequestTabFolderSelectionListener());
        this.requestTabFolderItem = this.requestTabFolder.getSelection()[0];
        this.requestBuilderPartCurr = (IHttpBuilderPart)this.requestTabFolderItem.getData();
        return composite2;
    }

    private SelectionListener createRequestTabFolderSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TabItem[] tabItemArray = RequestEditView.this.requestTabFolder.getSelection();
                if (tabItemArray != null) {
                    if (RequestEditView.this.requestBuilderPartCurr != null) {
                        try {
                            RequestEditView.this.requestBuilderPartCurr.processContents();
                        }
                        catch (Exception exception) {
                            RequestEditView.this.requestTabFolder.setSelection(RequestEditView.this.requestTabFolderItem);
                            RequestEditView.this.displayExceptionError(exception);
                            return;
                        }
                    }
                    RequestEditView.this.requestTabFolderItem = tabItemArray[0];
                    RequestEditView.this.requestBuilderPartCurr = (IHttpBuilderPart)RequestEditView.this.requestTabFolderItem.getData();
                    RequestEditView.this.requestBuilderPartCurr.refresh();
                }
            }
        };
    }

    private Composite createResponseViewer(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText("Response");
        group.setLayout((Layout)new FillLayout());
        this.responseViewer = new HttpMessageEditor((Composite)group);
        this.responseViewer.setEditable(false);
        return group;
    }
}

