/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.ui.http;

import com.subgraph.vega.ui.http.Activator;
import com.subgraph.vega.ui.http.intercept.InterceptView;
import com.subgraph.vega.ui.http.statusview.StatusView;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ProxyStatusLineContribution
extends ContributionItem {
    private static final int BLINK_INTERVAL = 500;
    private static final Image proxyAlert = Activator.getImageDescriptor("icons/proxy_alert.png").createImage();
    private static final Image proxyRunning = Activator.getImageDescriptor("icons/proxy_running.png").createImage();
    private static final Image proxyStopped = Activator.getImageDescriptor("icons/proxy_stopped.png").createImage();
    private final Logger logger = Logger.getLogger("proxy");
    private CLabel label;
    private final Timer alertBlinkTimer = new Timer();
    private TimerTask alertBlinkTask;
    private boolean alertEnabled;
    private String runningMessage;
    private int viewCnt = 0;
    private int queueCnt = 0;
    private Date lastViewChange = new Date();

    public ProxyStatusLineContribution() {
        this.createListeners();
    }

    public void fill(Composite composite) {
        new Label(composite, 2);
        this.label = new CLabel(composite, 32);
        this.setProxyStopped();
        StatusLineLayoutData statusLineLayoutData = new StatusLineLayoutData();
        statusLineLayoutData.widthHint = 220;
        this.label.setLayoutData((Object)statusLineLayoutData);
        this.label.addMouseListener((MouseListener)new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseDown(MouseEvent mouseEvent) {
                Timer timer = ProxyStatusLineContribution.this.alertBlinkTimer;
                synchronized (timer) {
                    if (ProxyStatusLineContribution.this.queueCnt != 0) {
                        ProxyStatusLineContribution.this.handleAlertClick();
                    }
                }
            }
        });
    }

    private void createListeners() {
        IWindowListener iWindowListener = new IWindowListener(){

            public void windowActivated(IWorkbenchWindow iWorkbenchWindow) {
            }

            public void windowDeactivated(IWorkbenchWindow iWorkbenchWindow) {
            }

            public void windowClosed(IWorkbenchWindow iWorkbenchWindow) {
            }

            public void windowOpened(IWorkbenchWindow iWorkbenchWindow) {
                ProxyStatusLineContribution.this.createPageListener(iWorkbenchWindow);
            }
        };
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        iWorkbench.addWindowListener(iWindowListener);
    }

    private void createPageListener(IWorkbenchWindow iWorkbenchWindow) {
        IPageListener iPageListener = new IPageListener(){

            public void pageActivated(IWorkbenchPage iWorkbenchPage) {
            }

            public void pageClosed(IWorkbenchPage iWorkbenchPage) {
            }

            public void pageOpened(IWorkbenchPage iWorkbenchPage) {
                ProxyStatusLineContribution.this.createPartListener(iWorkbenchPage);
            }
        };
        iWorkbenchWindow.addPageListener(iPageListener);
        IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindow.getPages();
        int n = 0;
        while (n < iWorkbenchPageArray.length) {
            this.createPartListener(iWorkbenchPageArray[n]);
            ++n;
        }
    }

    private void createPartListener(IWorkbenchPage iWorkbenchPage) {
        IPartListener2 iPartListener2 = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
                IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
                if (iWorkbenchPart instanceof InterceptView || iWorkbenchPart instanceof StatusView) {
                    Timer timer = ProxyStatusLineContribution.this.alertBlinkTimer;
                    synchronized (timer) {
                        ProxyStatusLineContribution.this.lastViewChange = new Date();
                        ProxyStatusLineContribution proxyStatusLineContribution = ProxyStatusLineContribution.this;
                        proxyStatusLineContribution.viewCnt = proxyStatusLineContribution.viewCnt - 1;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
                IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
                if (iWorkbenchPart instanceof InterceptView || iWorkbenchPart instanceof StatusView) {
                    Timer timer = ProxyStatusLineContribution.this.alertBlinkTimer;
                    synchronized (timer) {
                        ProxyStatusLineContribution.this.lastViewChange = new Date();
                        ProxyStatusLineContribution proxyStatusLineContribution = ProxyStatusLineContribution.this;
                        proxyStatusLineContribution.viewCnt = proxyStatusLineContribution.viewCnt + 1;
                    }
                }
            }

            public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
            }
        };
        iWorkbenchPage.addPartListener(iPartListener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProxyRunning(int n) {
        this.runningMessage = "Proxy running on " + n + " listeners";
        Timer timer = this.alertBlinkTimer;
        synchronized (timer) {
            if (!this.alertEnabled) {
                this.setLabelImageAndText(proxyRunning, this.runningMessage);
            }
        }
    }

    public void setProxyPending(int n) {
        this.setInterceptionQueueSize(n);
    }

    public void setProxyStopped() {
        this.stopAlert();
        this.setLabelImageAndText(proxyStopped, "Proxy is not running");
    }

    private int countViewsVisible() {
        int n = 0;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iWorkbench != null) {
            IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
            int n2 = 0;
            while (n2 < iWorkbenchWindowArray.length) {
                IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n2].getPages();
                int n3 = 0;
                while (n3 < iWorkbenchPageArray.length) {
                    IViewReference[] iViewReferenceArray = iWorkbenchPageArray[n3].getViewReferences();
                    int n4 = 0;
                    while (n4 < iViewReferenceArray.length) {
                        IViewPart iViewPart = iViewReferenceArray[n4].getView(false);
                        if ((iViewPart instanceof InterceptView || iViewPart instanceof StatusView) && iWorkbenchPageArray[n3].isPartVisible((IWorkbenchPart)iViewPart)) {
                            ++n;
                        }
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        return n;
    }

    private void setInterceptionQueueSize(final int n) {
        this.label.getDisplay().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Timer timer = ProxyStatusLineContribution.this.alertBlinkTimer;
                synchronized (timer) {
                    ProxyStatusLineContribution.this.queueCnt = n;
                    if (n > 0) {
                        if (!ProxyStatusLineContribution.this.alertEnabled) {
                            ProxyStatusLineContribution.this.viewCnt = ProxyStatusLineContribution.this.countViewsVisible();
                            if (ProxyStatusLineContribution.this.viewCnt == 0) {
                                ProxyStatusLineContribution.this.startAlert();
                            }
                        }
                        String string = "(" + n + ") messages intercepted";
                        ProxyStatusLineContribution.this.setLabelImageAndTextFromUiThread(proxyAlert, string);
                    } else {
                        ProxyStatusLineContribution.this.stopAlert();
                        ProxyStatusLineContribution.this.setLabelImageAndTextFromUiThread(proxyRunning, ProxyStatusLineContribution.this.runningMessage);
                    }
                }
            }
        });
    }

    private void startAlert() {
        if (this.alertBlinkTask == null) {
            this.alertBlinkTask = this.createAlertTask();
            this.alertBlinkTimer.scheduleAtFixedRate(this.alertBlinkTask, 500L, 500L);
            this.alertEnabled = true;
        }
    }

    private void stopAlert() {
        this.alertEnabled = false;
        if (this.alertBlinkTask != null) {
            this.alertBlinkTask.cancel();
            this.alertBlinkTask = null;
        }
    }

    private TimerTask createAlertTask() {
        return new TimerTask(){
            private boolean state = true;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Timer timer = ProxyStatusLineContribution.this.alertBlinkTimer;
                synchronized (timer) {
                    Date date;
                    if (ProxyStatusLineContribution.this.viewCnt != 0 && (date = new Date()).getTime() - ProxyStatusLineContribution.this.lastViewChange.getTime() >= 500L) {
                        ProxyStatusLineContribution.this.stopAlert();
                        if (!this.state) {
                            ProxyStatusLineContribution.this.setLabelImage(proxyAlert);
                        }
                        return;
                    }
                }
                boolean bl = this.state = !this.state;
                if (this.state) {
                    ProxyStatusLineContribution.this.setLabelImage(proxyAlert);
                } else {
                    ProxyStatusLineContribution.this.setLabelImage(proxyStopped);
                }
            }
        };
    }

    private void setLabelImage(Image image) {
        this.setLabelImageAndText(image, null);
    }

    private void setLabelImageAndText(final Image image, final String string) {
        if (this.label == null || this.label.isDisposed()) {
            return;
        }
        this.label.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProxyStatusLineContribution.this.setLabelImageAndTextFromUiThread(image, string);
            }
        });
    }

    private void setLabelImageAndTextFromUiThread(Image image, String string) {
        if (image != null) {
            this.label.setImage(image);
        }
        if (string != null) {
            this.label.setText(string);
        }
        this.label.pack(true);
        this.label.getParent().layout();
    }

    private void handleAlertClick() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            iWorkbenchWindow.getActivePage().showView("com.subgraph.vega.views.intercept");
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "Failed to open interception view", exception);
        }
    }
}

