/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.identity.identityview.tree;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.identity.IIdentity;
import com.subgraph.vega.api.model.identity.IIdentityModel;
import com.subgraph.vega.api.model.identity.NewIdentityEvent;
import com.subgraph.vega.ui.identity.identityview.tree.IIdentityTreeNode;
import com.subgraph.vega.ui.identity.identityview.tree.IdentityTreeNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class IdentitiesViewerContentProvider
implements ITreeContentProvider,
IEventHandler {
    private IIdentityModel identityModel;
    private Viewer viewer;
    private List<IIdentityTreeNode> childrenList = new ArrayList<IIdentityTreeNode>();

    public void dispose() {
        if (this.identityModel != null) {
            this.identityModel.removeChangeListener((IEventHandler)this);
        }
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.viewer = viewer;
        if (this.identityModel != object2) {
            if (this.identityModel != null) {
                this.identityModel.removeChangeListener((IEventHandler)this);
                this.childrenList.clear();
            }
            this.identityModel = (IIdentityModel)object2;
            this.childrenList.clear();
            if (this.identityModel != null) {
                this.identityModel.addChangeListener((IEventHandler)this);
                for (IIdentity iIdentity : this.identityModel.getAllIdentities()) {
                    this.childrenList.add(new IdentityTreeNode(iIdentity));
                }
            }
        }
    }

    public Object[] getElements(Object object) {
        return this.childrenList.toArray();
    }

    public Object[] getChildren(Object object) {
        return ((IIdentityTreeNode)object).getChildren();
    }

    public Object getParent(Object object) {
        return null;
    }

    public boolean hasChildren(Object object) {
        return ((IIdentityTreeNode)object).hasChildren();
    }

    public void handleEvent(IEvent iEvent) {
        if (iEvent instanceof NewIdentityEvent) {
            this.childrenList.add(new IdentityTreeNode(((NewIdentityEvent)iEvent).getIdentity()));
            this.viewer.refresh();
        }
    }
}

