/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.ui.util;

import com.subgraph.vega.ui.util.dialogs.IConfigDialogContent;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class PopupConfigDialog
extends PopupDialog {
    private static final GridDataFactory LAYOUTDATA_GRAB_BOTH = GridDataFactory.fillDefaults().grab(true, true);
    private static final GridLayoutFactory POPUP_LAYOUT_FACTORY = GridLayoutFactory.fillDefaults().margins(0, 0).spacing(1, 1);
    private final Point origin;
    private final IConfigDialogContent content;
    private Control dialogArea;

    public PopupConfigDialog(Shell shell, Point point, IConfigDialogContent iConfigDialogContent) {
        super(shell, 4, true, false, false, false, false, iConfigDialogContent.getTitle(), "Press 'ESC' to close");
        this.origin = point;
        this.content = iConfigDialogContent;
    }

    public boolean close() {
        this.content.onOk();
        this.content.onClose();
        return super.close();
    }

    protected Control getFocusControl() {
        return this.content.getFocusControl();
    }

    protected Point getInitialLocation(Point point) {
        int n = this.origin.x - point.x;
        int n2 = n > 0 ? n : this.origin.x;
        return new Point(n2, this.origin.y);
    }

    protected Control createDialogArea(Composite composite) {
        return this.content.createContents(composite);
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        POPUP_LAYOUT_FACTORY.applyTo(composite2);
        GridData gridData = LAYOUTDATA_GRAB_BOTH.create();
        composite2.setLayoutData((Object)gridData);
        if (this.hasTitleArea()) {
            this.createTitleMenuArea(composite2);
            this.createHorizontalSeparator(composite2);
        }
        this.dialogArea = this.createDialogArea(composite2);
        if (this.dialogArea.getLayoutData() == null) {
            LAYOUTDATA_GRAB_BOTH.applyTo((Control)composite2);
        }
        gridData = LAYOUTDATA_GRAB_BOTH.create();
        this.dialogArea.pack();
        gridData.widthHint = this.dialogArea.getSize().x;
        gridData.heightHint = this.dialogArea.getSize().y;
        this.dialogArea.setLayoutData((Object)gridData);
        if (this.hasInfoArea()) {
            this.createHorizontalSeparator(composite2);
            this.createInfoTextArea(composite2);
        }
        return composite2;
    }

    private Control createHorizontalSeparator(Composite composite) {
        Label label = new Label(composite, 259);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)label);
        return label;
    }
}

