/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.api.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpHost;

public class UriTools {
    private static final String[] schemePrefixes = new String[]{"http://", "https://"};

    public static boolean isTextValidURI(String string) {
        return UriTools.getURIFromText(string) != null;
    }

    public static URI getURIFromText(String string) {
        URI uRI;
        block3: {
            try {
                uRI = new URI(UriTools.textToAbsoluteURL(string.trim()));
                if (uRI.getHost() != null) break block3;
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        return uRI;
    }

    public static boolean doesBaseUriContain(URI uRI, URI uRI2) {
        URI uRI3 = URI.create(uRI.toString());
        URI uRI4 = URI.create(uRI2.toString());
        String string = uRI3.toString();
        return uRI3.getHost().equalsIgnoreCase(uRI4.getHost()) && uRI2.toString().startsWith(string);
    }

    private static String textToAbsoluteURL(String string) {
        String[] stringArray = schemePrefixes;
        int n = schemePrefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (string.toLowerCase().startsWith(string2)) {
                return string;
            }
            ++n2;
        }
        return "http://" + string;
    }

    public static URI stripQueryFromUri(URI uRI) {
        try {
            return new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), uRI.getPath(), null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    public static URI createUriFromTargetAndLine(HttpHost httpHost, String string) {
        try {
            return new URI(httpHost.getSchemeName().toLowerCase(), null, httpHost.getHostName(), httpHost.getPort(), UriTools.extractPath(string), UriTools.extractQuery(string), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Failed to parse URI fields", uRISyntaxException);
        }
    }

    private static String extractQuery(String string) {
        int n = string.indexOf(63);
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }

    private static String extractPath(String string) {
        int n = string.indexOf(63);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private static boolean isHex(char c) {
        return "abcdefABCDEF0123456789".indexOf(c) != -1;
    }

    public static String removeUnicodeEscapes(String string) {
        if (string.indexOf("%u") == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < string.length()) {
            if (UriTools.isUnicodeEscape(string, n)) {
                UriTools.splitUnicodeEscape(string, n, stringBuilder);
                n += 6;
                continue;
            }
            stringBuilder.append(string.charAt(n));
            ++n;
        }
        return stringBuilder.toString();
    }

    private static boolean isUnicodeEscape(String string, int n) {
        if (n > string.length() - 6) {
            return false;
        }
        return string.charAt(n) == '%' && string.charAt(n + 1) == 'u' && UriTools.isHex(string.charAt(n + 2)) && UriTools.isHex(string.charAt(n + 3)) && UriTools.isHex(string.charAt(n + 4)) && UriTools.isHex(string.charAt(n + 5));
    }

    private static void splitUnicodeEscape(String string, int n, StringBuilder stringBuilder) {
        stringBuilder.append('%');
        stringBuilder.append(string.charAt(n + 2));
        stringBuilder.append(string.charAt(n + 3));
        stringBuilder.append('%');
        stringBuilder.append(string.charAt(n + 4));
        stringBuilder.append(string.charAt(n + 5));
    }
}

