/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.wizards;

import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.identity.IIdentity;
import com.subgraph.vega.api.model.scope.ITargetScope;
import com.subgraph.vega.api.scanner.modules.IScannerModule;
import com.subgraph.vega.ui.scanner.Activator;
import com.subgraph.vega.ui.scanner.wizards.NewScanAuthPage;
import com.subgraph.vega.ui.scanner.wizards.NewScanModulesPage;
import com.subgraph.vega.ui.scanner.wizards.NewScanParameterPage;
import com.subgraph.vega.ui.scanner.wizards.NewScanTargetPage;
import com.subgraph.vega.ui.util.images.ImageCache;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;

public class NewScanWizard
extends Wizard {
    private static final String VEGA_LOGO = "icons/vega_small.png";
    private final ImageCache imageCache;
    private NewScanTargetPage targetPage;
    private NewScanModulesPage modulesPage;
    private NewScanAuthPage authPage;
    private NewScanParameterPage parameterPage;
    private ITargetScope scanTargetScope;
    private IIdentity scanIdentity;
    private List<String> cookieStringList;
    private Set<String> excludedParameterNames;
    private String targetFieldString;

    public NewScanWizard(String string, Collection<IIdentity> collection, List<IScannerModule> list, Set<String> set) {
        IModel iModel = Activator.getDefault().getModel();
        this.imageCache = new ImageCache("com.subgraph.vega.ui.scanner");
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage((Image)this.imageCache.get(VEGA_LOGO));
        this.targetPage = new NewScanTargetPage(iModel.getCurrentWorkspace(), string);
        this.targetPage.setImageDescriptor(imageDescriptor);
        this.modulesPage = new NewScanModulesPage(list);
        this.modulesPage.setImageDescriptor(imageDescriptor);
        this.authPage = new NewScanAuthPage(collection);
        this.authPage.setImageDescriptor(imageDescriptor);
        this.parameterPage = new NewScanParameterPage(set);
        this.parameterPage.setImageDescriptor(imageDescriptor);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.targetPage);
        this.addPage((IWizardPage)this.modulesPage);
        this.addPage((IWizardPage)this.authPage);
        this.addPage((IWizardPage)this.parameterPage);
    }

    public boolean canFinish() {
        return this.targetPage.isTargetValid();
    }

    public boolean performFinish() {
        this.scanIdentity = this.authPage.getScanIdentity();
        this.cookieStringList = this.authPage.getCookieStringList();
        this.scanTargetScope = this.targetPage.getScanTargetScope();
        this.targetFieldString = this.targetPage.getUriTextIfValid();
        this.excludedParameterNames = this.parameterPage.getExcludedParameterNames();
        return this.scanTargetScope != null;
    }

    public void dispose() {
        this.imageCache.dispose();
        super.dispose();
    }

    public ITargetScope getScanTargetScope() {
        return this.scanTargetScope;
    }

    public String getTargetField() {
        return this.targetFieldString;
    }

    public List<String> getCookieStringList() {
        return this.cookieStringList;
    }

    public IIdentity getScanIdentity() {
        return this.scanIdentity;
    }

    public Set<String> getExcludedParameterNames() {
        return this.excludedParameterNames;
    }
}

