/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.scope;

import com.subgraph.vega.api.model.scope.ITargetScope;
import com.subgraph.vega.api.model.scope.ITargetScopeManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ScopeSelector
extends Composite {
    private final ITargetScopeManager targetScopeManager;
    private final StackLayout stack;
    private final Composite stackPanel;
    private final Text scopeText;
    private final ComboViewer scopeComboViewer;
    private final Button addButton;
    private final Button editButton;
    private final Button removeButton;
    private boolean isEditable;

    public ScopeSelector(Composite composite, ITargetScopeManager iTargetScopeManager) {
        super(composite, 0);
        this.targetScopeManager = iTargetScopeManager;
        this.stack = new StackLayout();
        this.stackPanel = new Composite((Composite)this, 0);
        this.stackPanel.setLayout((Layout)this.stack);
        this.scopeText = this.createText(this.stackPanel);
        this.scopeComboViewer = this.createComboViewer(this.stackPanel);
        Composite composite2 = new Composite((Composite)this, 0);
        composite2.setLayout((Layout)new RowLayout(256));
        this.addButton = this.createAddButton(composite2);
        this.editButton = this.createEditButton(composite2);
        this.removeButton = this.createRemoveButton(composite2);
        this.refreshScopeCombo();
        this.setReadOnly();
        this.setEnabledButtonsForState();
        this.setLayout((Layout)new FillLayout());
    }

    public ComboViewer getViewer() {
        return this.scopeComboViewer;
    }

    private Text createText(Composite composite) {
        Text text = new Text(composite, 2048);
        text.addSelectionListener((SelectionListener)this.createTextSelectionListener());
        text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 4) {
                    traverseEvent.doit = false;
                }
            }
        });
        return text;
    }

    private SelectionAdapter createTextSelectionListener() {
        return new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                String string = ScopeSelector.this.scopeText.getText();
                if (!string.isEmpty()) {
                    ScopeSelector.this.getScopeFromCombo().setName(string);
                    ScopeSelector.this.scopeComboViewer.refresh(true);
                    ScopeSelector.this.setReadOnly();
                }
            }
        };
    }

    private ComboViewer createComboViewer(Composite composite) {
        ComboViewer comboViewer = new ComboViewer(composite, 8);
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
                if (structuredSelection.getFirstElement() instanceof ITargetScope) {
                    ScopeSelector.this.targetScopeManager.setActiveScope((ITargetScope)structuredSelection.getFirstElement());
                    ScopeSelector.this.setEnabledButtonsForState();
                }
            }
        });
        return comboViewer;
    }

    private Button createAddButton(Composite composite) {
        return this.createButton(composite, "Add", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScopeSelector.this.handleAdd();
            }
        });
    }

    private Button createEditButton(Composite composite) {
        return this.createButton(composite, "Edit", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScopeSelector.this.handleEdit();
            }
        });
    }

    private Button createRemoveButton(Composite composite) {
        return this.createButton(composite, "Remove", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScopeSelector.this.handleRemove();
            }
        });
    }

    private void refreshScopeCombo() {
        this.scopeComboViewer.setInput((Object)this.targetScopeManager.getAllScopes().toArray());
        this.scopeComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.targetScopeManager.getActiveScope()));
        this.setEnabledButtonsForState();
    }

    private Button createButton(Composite composite, String string, SelectionListener selectionListener) {
        Button button = new Button(composite, 0);
        button.setText(string);
        button.addSelectionListener(selectionListener);
        return button;
    }

    private void handleEdit() {
        this.setEditable();
    }

    private void handleRemove() {
        if (this.targetScopeManager.getAllScopes().size() <= 1) {
            return;
        }
        this.targetScopeManager.removeScope(this.getScopeFromCombo());
        this.refreshScopeCombo();
    }

    private void handleAdd() {
        ITargetScope iTargetScope = this.targetScopeManager.createNewScope();
        this.targetScopeManager.saveScope(iTargetScope);
        this.targetScopeManager.setActiveScope(iTargetScope);
        this.refreshScopeCombo();
        this.setEditable();
    }

    private void setEditable() {
        String string = this.getScopeFromCombo().getName();
        if (string != null) {
            this.isEditable = true;
            this.stack.topControl = this.scopeText;
            this.stackPanel.layout();
            this.setEnabledButtonsForState();
            this.scopeText.setText(string);
            this.scopeText.setSelection(0, string.length());
            this.scopeText.setFocus();
        }
    }

    private void setReadOnly() {
        this.isEditable = false;
        this.stack.topControl = this.scopeComboViewer.getCombo();
        this.stackPanel.layout();
        this.setEnabledButtonsForState();
    }

    private ITargetScope getScopeFromCombo() {
        ISelection iSelection = this.scopeComboViewer.getSelection();
        if (!(iSelection instanceof StructuredSelection)) {
            return null;
        }
        Object object = ((StructuredSelection)iSelection).getFirstElement();
        if (!(object instanceof ITargetScope)) {
            return null;
        }
        return (ITargetScope)object;
    }

    private void setEnabledButtonsForState() {
        if (this.isEditable) {
            this.addButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            return;
        }
        if (this.getScopeFromCombo().isDefaultScope()) {
            this.addButton.setEnabled(true);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            return;
        }
        this.addButton.setEnabled(true);
        this.editButton.setEnabled(true);
        this.removeButton.setEnabled(true);
    }
}

