/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.dashboard;

import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.ui.scanner.dashboard.AlertSeverityCell;
import com.subgraph.vega.ui.util.images.ImageCache;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class AlertPane
extends Composite {
    private static final String ALERT_HIGH = "icons/alert_high.png";
    private static final String ALERT_MEDIUM = "icons/alert_medium.png";
    private static final String ALERT_LOW = "icons/alert_low.png";
    private static final String ALERT_INFO = "icons/alert_info.png";
    private final ImageCache imageCache = new ImageCache("com.subgraph.vega.ui.scanner");
    private final Map<IScanAlert.Severity, AlertSeverityCell> alertSeverityCells = new HashMap<IScanAlert.Severity, AlertSeverityCell>();
    private Composite rootComposite;

    AlertPane(Composite composite) {
        super(composite, 0);
        this.setLayout((Layout)new FillLayout());
        this.setBackground(composite.getBackground());
        this.reset();
    }

    public void dispose() {
        this.imageCache.dispose();
        super.dispose();
    }

    private void addSeverityCells(Color color) {
        IScanAlert.Severity[] severityArray = IScanAlert.Severity.values();
        int n = severityArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlertSeverityCell alertSeverityCell;
            IScanAlert.Severity severity = severityArray[n2];
            if (!severity.equals((Object)IScanAlert.Severity.UNKNOWN) && (alertSeverityCell = this.createCellForSeverity(severity, color)) != null) {
                this.alertSeverityCells.put(severity, alertSeverityCell);
            }
            ++n2;
        }
    }

    private AlertSeverityCell createCellForSeverity(IScanAlert.Severity severity, Color color) {
        String string = this.getImageKeyForSeverity(severity);
        String string2 = this.getLabelForSeverity(severity);
        if (string == null || string2 == null) {
            return null;
        }
        Image image = this.imageCache.get(string);
        Image image2 = this.imageCache.getDisabled(string);
        if (image == null || image2 == null) {
            return null;
        }
        AlertSeverityCell alertSeverityCell = new AlertSeverityCell(this.rootComposite, color, image, image2, string2);
        alertSeverityCell.setLayoutData(new GridData(4, 0x1000000, true, false));
        alertSeverityCell.setBackground(color);
        return alertSeverityCell;
    }

    private String getImageKeyForSeverity(IScanAlert.Severity severity) {
        switch (severity) {
            case HIGH: {
                return ALERT_HIGH;
            }
            case MEDIUM: {
                return ALERT_MEDIUM;
            }
            case LOW: {
                return ALERT_LOW;
            }
            case INFO: {
                return ALERT_INFO;
            }
            case UNKNOWN: {
                return null;
            }
        }
        return null;
    }

    private String getLabelForSeverity(IScanAlert.Severity severity) {
        switch (severity) {
            case HIGH: {
                return "High";
            }
            case MEDIUM: {
                return "Medium";
            }
            case LOW: {
                return "Low";
            }
            case INFO: {
                return "Info";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return null;
    }

    void reset() {
        if (this.rootComposite != null) {
            this.rootComposite.dispose();
        }
        this.rootComposite = new Composite((Composite)this, 0);
        this.rootComposite.setBackground(this.getBackground());
        this.rootComposite.setLayout((Layout)new GridLayout());
        this.addSeverityCells(this.getParent().getBackground());
        this.layout();
    }

    void addAlert(final IScanAlert iScanAlert) {
        final AlertSeverityCell alertSeverityCell = this.alertSeverityCells.get(iScanAlert.getSeverity());
        if (alertSeverityCell == null) {
            return;
        }
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                alertSeverityCell.addAlert(iScanAlert);
            }
        });
    }
}

