/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.analysis;

import com.subgraph.vega.api.analysis.IContentAnalyzer;
import com.subgraph.vega.api.analysis.IContentAnalyzerResult;
import com.subgraph.vega.api.analysis.MimeType;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.model.web.IWebModel;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.scanner.modules.IResponseProcessingModule;
import com.subgraph.vega.api.util.VegaURI;
import com.subgraph.vega.internal.analysis.ContentAnalyzerFactory;
import com.subgraph.vega.internal.analysis.ContentAnalyzerResult;
import com.subgraph.vega.internal.analysis.MimeDetector;
import com.subgraph.vega.internal.analysis.urls.UrlExtractor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;

public class ContentAnalyzer
implements IContentAnalyzer {
    private final Logger logger = Logger.getLogger("analysis");
    private final IScanInstance scanInstance;
    private final ContentAnalyzerFactory factory;
    private final UrlExtractor urlExtractor = new UrlExtractor();
    private final MimeDetector mimeDetector = new MimeDetector();
    private final Object responseProcessingLock = new Object();
    private List<IResponseProcessingModule> responseProcessingModules;
    private boolean addLinksToModel;
    private boolean defaultAddToRequestLog;

    ContentAnalyzer(ContentAnalyzerFactory contentAnalyzerFactory, IScanInstance iScanInstance) {
        this.factory = contentAnalyzerFactory;
        this.scanInstance = iScanInstance;
        this.addLinksToModel = true;
        this.defaultAddToRequestLog = true;
    }

    public IContentAnalyzerResult processResponse(IHttpResponse iHttpResponse) {
        return this.processResponse(iHttpResponse, this.defaultAddToRequestLog, true);
    }

    public void setDefaultAddToRequestLog(boolean bl) {
        this.defaultAddToRequestLog = bl;
    }

    public IContentAnalyzerResult processResponse(IHttpResponse iHttpResponse, boolean bl, boolean bl2) {
        ContentAnalyzerResult contentAnalyzerResult = new ContentAnalyzerResult();
        if (iHttpResponse == null) {
            this.logger.warning("ContentAnalyzer.processResponse() called with null response");
            return contentAnalyzerResult;
        }
        IWorkspace iWorkspace = this.factory.getCurrentWorkspace();
        if (iWorkspace == null) {
            this.logger.warning("ContentAnalyzer.processResponse() called while no workspace is active");
            return contentAnalyzerResult;
        }
        if (bl) {
            iWorkspace.getRequestLog().addRequestResponse(iHttpResponse);
        }
        VegaURI vegaURI = VegaURI.fromHostAndRequest((HttpHost)iHttpResponse.getHost(), (HttpRequest)iHttpResponse.getOriginalRequest());
        IWebPath iWebPath = iWorkspace.getWebModel().getWebPathByUri(vegaURI);
        iWebPath.setVisited(true);
        contentAnalyzerResult.setDeclaredMimeType(this.mimeDetector.getDeclaredMimeType(iHttpResponse));
        contentAnalyzerResult.setSniffedMimeType(this.mimeDetector.getSniffedMimeType(iHttpResponse));
        String string = this.getBestMimeType(contentAnalyzerResult);
        if (string != null && iWebPath.getMimeType() == null) {
            iWebPath.setMimeType(string);
        }
        if (bl2) {
            this.runExtractUrls(contentAnalyzerResult, iHttpResponse, iWorkspace.getWebModel());
        }
        this.runResponseProcessingModules(iHttpResponse.getOriginalRequest(), iHttpResponse, contentAnalyzerResult.getDeclaredMimeType(), contentAnalyzerResult.getSniffedMimeType(), iWorkspace);
        return contentAnalyzerResult;
    }

    private String getBestMimeType(IContentAnalyzerResult iContentAnalyzerResult) {
        if (iContentAnalyzerResult.getSniffedMimeType() != MimeType.MIME_NONE) {
            return iContentAnalyzerResult.getSniffedMimeType().getCanonicalName();
        }
        if (iContentAnalyzerResult.getDeclaredMimeType() != MimeType.MIME_NONE) {
            return iContentAnalyzerResult.getDeclaredMimeType().getCanonicalName();
        }
        return null;
    }

    public void setResponseProcessingModules(List<IResponseProcessingModule> list) {
        this.responseProcessingModules = new ArrayList<IResponseProcessingModule>(list);
    }

    private void runExtractUrls(ContentAnalyzerResult contentAnalyzerResult, IHttpResponse iHttpResponse, IWebModel iWebModel) {
        if (iHttpResponse.isMostlyAscii()) {
            for (VegaURI vegaURI : this.urlExtractor.findUrls(iHttpResponse)) {
                if (this.addLinksToModel && (this.schemeEquals(vegaURI, "http") || this.schemeEquals(vegaURI, "https"))) {
                    iWebModel.getWebPathByUri(vegaURI);
                }
                contentAnalyzerResult.addUri(vegaURI);
            }
        }
    }

    private boolean schemeEquals(VegaURI vegaURI, String string) {
        String string2 = vegaURI.getTargetHost().getSchemeName();
        return string2.equalsIgnoreCase(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runResponseProcessingModules(HttpRequest httpRequest, IHttpResponse iHttpResponse, MimeType mimeType, MimeType mimeType2, IWorkspace iWorkspace) {
        if (this.responseProcessingModules == null || !iHttpResponse.isMostlyAscii()) {
            return;
        }
        if (!this.isDefaultResponseProcessingMimetype(mimeType) && !this.isDefaultResponseProcessingMimetype(mimeType2)) {
            return;
        }
        Object object = this.responseProcessingLock;
        synchronized (object) {
            for (IResponseProcessingModule iResponseProcessingModule : this.responseProcessingModules) {
                if (!iResponseProcessingModule.isEnabled()) continue;
                iResponseProcessingModule.processResponse(this.scanInstance, httpRequest, iHttpResponse, iWorkspace);
            }
        }
    }

    private boolean isDefaultResponseProcessingMimetype(MimeType mimeType) {
        String string = mimeType.getCanonicalName();
        return string.contains("text") || string.contains("javascript") || string.contains("xml");
    }

    public void setAddLinksToModel(boolean bl) {
        this.addLinksToModel = bl;
    }
}

