/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.requestlogviewer;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.WorkspaceCloseEvent;
import com.subgraph.vega.api.model.WorkspaceResetEvent;
import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import com.subgraph.vega.ui.http.Activator;
import com.subgraph.vega.ui.httpeditor.HttpMessageEditor;
import com.subgraph.vega.ui.util.images.ImageCache;
import java.util.Collection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class RequestResponseViewer
extends Composite {
    private static final String VERTICAL_ICON = "icons/vertical.png";
    private static final String HORIZONTAL_ICON = "icons/horizontal.png";
    private static final String TABBED_ICON = "icons/tabbed.png";
    private static final String UP_ICON = "icons/up.png";
    private static final String DOWN_ICON = "icons/down.png";
    private static final String CONFIG_ICON = "icons/configure.png";
    private IEventHandler workspaceListener;
    private final SashForm parentForm;
    private final ImageCache imageCache;
    private final Menu optionsMenu;
    private final Composite toolbarComposite;
    private ToolItem hideItem;
    private SashForm sashForm;
    private TabFolder tabFolder;
    private Composite rootComposite;
    private HttpMessageEditor requestViewer;
    private HttpMessageEditor responseViewer;
    private IRequestLogRecord currentRecord;
    private boolean displayImages = true;
    private boolean displayImagesAsHex = false;
    private boolean urlDecodeState = false;
    private boolean hideState = false;
    private boolean wordWrapLines = false;

    public RequestResponseViewer(SashForm sashForm) {
        super((Composite)sashForm, 0);
        this.setLayout((Layout)new FormLayout());
        this.parentForm = sashForm;
        this.imageCache = new ImageCache("com.subgraph.vega.ui.http");
        this.optionsMenu = this.createOptionsMenu(sashForm.getShell());
        this.toolbarComposite = this.createToolbarComposite(this);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        this.toolbarComposite.setLayoutData((Object)formData);
        this.setTabbedMode();
        this.workspaceListener = new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof WorkspaceCloseEvent || iEvent instanceof WorkspaceResetEvent) {
                    RequestResponseViewer.this.handleWorkspaceCloseOrReset();
                }
            }
        };
        Activator.getDefault().getModel().addWorkspaceListener(this.workspaceListener);
        this.createDisposeListener();
    }

    private void createDisposeListener() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                Activator.getDefault().getModel().removeWorkspaceListener(RequestResponseViewer.this.workspaceListener);
                RequestResponseViewer.this.removeDisposeListener(this);
            }
        });
    }

    private void handleWorkspaceCloseOrReset() {
        if (!this.isDisposed()) {
            this.clearViewers();
        }
    }

    private Composite createToolbarComposite(Composite composite) {
        Composite composite2 = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        ToolBar toolBar = this.createLayoutToolBar(composite2);
        toolBar.setLayoutData((Object)new GridData(4, 4, true, true));
        toolBar = this.createConfigureToolBar(composite2);
        toolBar.setLayoutData((Object)new GridData(4, 4, false, true));
        return composite2;
    }

    private ToolBar createLayoutToolBar(Composite composite) {
        ToolBar toolBar = new ToolBar(composite, 0);
        ToolItem toolItem = new ToolItem(toolBar, 16);
        toolItem.setImage(this.imageCache.get(TABBED_ICON));
        toolItem.setToolTipText("Tabbed Request/Response layout");
        toolItem.setSelection(true);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RequestResponseViewer.this.setTabbedMode();
            }
        });
        ToolItem toolItem2 = new ToolItem(toolBar, 16);
        toolItem2.setImage(this.imageCache.get(HORIZONTAL_ICON));
        toolItem2.setToolTipText("Horizontal Request/Response layout");
        toolItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RequestResponseViewer.this.setHorizontalSashMode();
            }
        });
        ToolItem toolItem3 = new ToolItem(toolBar, 16);
        toolItem3.setImage(this.imageCache.get(VERTICAL_ICON));
        toolItem3.setToolTipText("Vertical Request/Response layout");
        toolItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RequestResponseViewer.this.setVerticalSashMode();
            }
        });
        toolBar.pack();
        return toolBar;
    }

    private ToolBar createConfigureToolBar(Composite composite) {
        final ToolBar toolBar = new ToolBar(composite, 0);
        final ToolItem toolItem = new ToolItem(toolBar, 4);
        toolItem.setImage(this.imageCache.get(CONFIG_ICON));
        toolItem.setToolTipText("Options");
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Rectangle rectangle = toolItem.getBounds();
                Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
                RequestResponseViewer.this.optionsMenu.setLocation(toolBar.getDisplay().map((Control)toolBar, null, point));
                RequestResponseViewer.this.optionsMenu.setVisible(true);
            }
        });
        this.hideItem = new ToolItem(toolBar, 8);
        this.hideItem.setImage(this.imageCache.get(UP_ICON));
        this.hideItem.setToolTipText("Hide Request Table");
        this.hideItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RequestResponseViewer.this.toggleHideState();
            }
        });
        toolBar.pack();
        return toolBar;
    }

    private Menu createOptionsMenu(Shell shell) {
        Menu menu = new Menu((Decorations)shell, 8);
        final MenuItem menuItem = new MenuItem(menu, 32);
        menuItem.setText("Display Images");
        menuItem.setSelection(this.displayImages);
        final MenuItem menuItem2 = new MenuItem(menu, 32);
        menuItem2.setText("Display Images with Hex Viewer");
        final MenuItem menuItem3 = new MenuItem(menu, 32);
        menuItem3.setText("Remove URL encoding");
        final MenuItem menuItem4 = new MenuItem(menu, 32);
        menuItem4.setText("Word wrap lines");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = menuItem.getSelection();
                menuItem2.setEnabled(bl);
                RequestResponseViewer.this.setDisplayImageState(bl);
                RequestResponseViewer.this.displayImages = bl;
            }
        });
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = menuItem2.getSelection();
                RequestResponseViewer.this.setDisplayImagesAsHexState(bl);
                RequestResponseViewer.this.displayImagesAsHex = bl;
            }
        });
        menuItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = menuItem3.getSelection();
                RequestResponseViewer.this.setUrlDecodeState(bl);
                RequestResponseViewer.this.urlDecodeState = bl;
            }
        });
        menuItem4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = menuItem4.getSelection();
                RequestResponseViewer.this.setWordwrapState(bl);
                RequestResponseViewer.this.wordWrapLines = bl;
            }
        });
        return menu;
    }

    private void setDisplayImageState(boolean bl) {
        this.requestViewer.setDisplayImages(bl);
        this.responseViewer.setDisplayImages(bl);
    }

    private void setDisplayImagesAsHexState(boolean bl) {
        this.requestViewer.setDisplayImagesAsHex(bl);
        this.responseViewer.setDisplayImagesAsHex(bl);
    }

    private void setUrlDecodeState(boolean bl) {
        this.requestViewer.setDecodeUrlEncoding(bl);
        this.responseViewer.setDecodeUrlEncoding(bl);
    }

    private void setWordwrapState(boolean bl) {
        this.requestViewer.setWordwrapLines(bl);
        this.responseViewer.setWordwrapLines(bl);
    }

    private void toggleHideState() {
        if (this.hideState) {
            this.hideState = false;
            this.hideItem.setImage(this.imageCache.get(UP_ICON));
            this.hideItem.setToolTipText("Hide Request Table");
            this.parentForm.setMaximizedControl(null);
        } else {
            this.hideState = true;
            this.hideItem.setToolTipText("Show Request Table");
            this.hideItem.setImage(this.imageCache.get(DOWN_ICON));
            this.parentForm.setMaximizedControl((Control)this);
        }
    }

    public void setTabbedMode() {
        this.sashForm = null;
        this.recreateRootComposite();
        this.tabFolder = new TabFolder(this.rootComposite, 128);
        this.createMessageViewers((Composite)this.tabFolder);
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Request");
        tabItem.setControl((Control)this.requestViewer);
        TabItem tabItem2 = new TabItem(this.tabFolder, 0);
        tabItem2.setText("Response");
        tabItem2.setControl((Control)this.responseViewer);
        this.layout();
        if (this.currentRecord != null) {
            this.processCurrentTransaction();
        }
        this.setDisplayResponse();
    }

    private void createMessageViewers(Composite composite) {
        this.requestViewer = new HttpMessageEditor(composite);
        this.requestViewer.setEditable(false);
        this.responseViewer = new HttpMessageEditor(composite);
        this.responseViewer.setEditable(false);
        this.setDisplayImageState(this.displayImages);
        this.setDisplayImagesAsHexState(this.displayImagesAsHex);
        this.setUrlDecodeState(this.urlDecodeState);
        this.setWordwrapState(this.wordWrapLines);
    }

    public void setDisplayResponse() {
        if (this.tabFolder != null) {
            this.tabFolder.setSelection(1);
        }
    }

    private void recreateRootComposite() {
        if (this.rootComposite != null) {
            this.rootComposite.dispose();
        }
        this.rootComposite = new Composite((Composite)this, 0);
        this.rootComposite.setLayout((Layout)new FillLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment((Control)this.toolbarComposite);
        formData.bottom = new FormAttachment(100);
        this.rootComposite.setLayoutData((Object)formData);
    }

    public void setVerticalSashMode() {
        this.configureSashMode(512);
    }

    public void setHorizontalSashMode() {
        this.configureSashMode(256);
    }

    private void configureSashMode(int n) {
        this.tabFolder = null;
        if (this.sashForm != null) {
            if (this.sashForm.getOrientation() != n) {
                this.sashForm.setOrientation(n);
            }
            return;
        }
        this.recreateRootComposite();
        this.sashForm = new SashForm(this.rootComposite, n);
        this.createMessageViewers((Composite)this.sashForm);
        this.sashForm.setWeights(new int[]{50, 50});
        this.layout();
        this.processCurrentTransaction();
    }

    public void setCurrentRecord(IRequestLogRecord iRequestLogRecord) {
        if (this.currentRecord != iRequestLogRecord) {
            this.currentRecord = iRequestLogRecord;
            this.processCurrentTransaction();
        }
    }

    private void addResponseHighlights(Collection<IScanAlert> collection) {
        for (IScanAlert iScanAlert : collection) {
            this.responseViewer.addAlertHighlights(iScanAlert.getHighlights());
        }
        this.responseViewer.displayAlertHighlights();
    }

    private void processCurrentTransaction() {
        Collection collection;
        if (this.currentRecord == null) {
            this.clearViewers();
            return;
        }
        this.requestViewer.displayHttpRequest(this.currentRecord.getRequest());
        this.responseViewer.displayHttpResponse(this.currentRecord.getResponse());
        IWorkspace iWorkspace = Activator.getDefault().getModel().getCurrentWorkspace();
        if (iWorkspace != null && !(collection = iWorkspace.getScanAlertRepository().getAlertsByRequestId(this.currentRecord.getRequestId())).isEmpty()) {
            this.addResponseHighlights(collection);
        }
    }

    private void clearViewers() {
        this.currentRecord = null;
        this.requestViewer.clearContent();
        this.responseViewer.clearContent();
    }
}

