/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.js;

import com.subgraph.vega.ui.httpeditor.Colors;
import com.subgraph.vega.ui.httpeditor.http.AbstractScanner;
import com.subgraph.vega.ui.httpeditor.js.JavascriptWhitespaceDetector;
import com.subgraph.vega.ui.httpeditor.js.JavascriptWordDetector;
import java.util.List;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class JavascriptScanner
extends AbstractScanner {
    private static final String[] KEYWORDS = new String[]{"break", "const", "continue", "delete", "do", "while", "export", "function", "for", "in", "if", "else", "import", "in", "instanceOf", "label", "let", "new", "return", "switch", "this", "throw", "try", "catch", "typeof", "var", "void", "while", "with", "yield"};
    private static final String[] CONSTANTS = new String[]{"true", "false", "null"};

    public JavascriptScanner(Colors colors) {
        super(colors);
    }

    @Override
    protected void initializeRules(List<IRule> list) {
        String string;
        IToken iToken = this.createToken(Colors.KEYWORD);
        IToken iToken2 = this.createToken(Colors.ENCODED_CHAR);
        IToken iToken3 = this.createToken(Colors.STRING);
        IToken iToken4 = this.createToken(Colors.SINGLE_LINE_COMMENT);
        IToken iToken5 = this.createToken(Colors.OTHER);
        list.add((IRule)new EndOfLineRule("//", iToken4));
        list.add((IRule)new SingleLineRule("\"", "\"", iToken3, '\\'));
        list.add((IRule)new SingleLineRule("'", "'", iToken3, '\\'));
        list.add((IRule)new WhitespaceRule((IWhitespaceDetector)new JavascriptWhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new JavascriptWordDetector(), iToken5);
        wordRule.addWord("function", iToken);
        String[] stringArray = KEYWORDS;
        int n = KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            wordRule.addWord(string, iToken);
            ++n2;
        }
        stringArray = CONSTANTS;
        n = CONSTANTS.length;
        n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            wordRule.addWord(string, iToken2);
            ++n2;
        }
        list.add((IRule)wordRule);
    }
}

