/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.httpeditor.html;

import com.subgraph.vega.ui.httpeditor.Colors;
import com.subgraph.vega.ui.httpeditor.html.HtmlWhitespaceDetector;
import com.subgraph.vega.ui.httpeditor.http.AbstractScanner;
import java.util.List;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class TagScanner
extends AbstractScanner {
    private static final String[] HTML_TAGS = new String[]{"a", "abbr", "acronym", "address", "area", "b", "base", "bdo", "big", "blockquote", "body", "br", "button", "caption", "cite", "code", "col", "colgroup", "dd", "del", "dfn", "div", "dl", "dt", "em", "fieldset", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "tr", "html", "i", "iframe", "img", "input", "ins", "kbd", "label", "legend", "li", "link", "map", "meta", "noframes", "noscript", "object", "ol", "optgroup", "option", "p", "param", "pre", "q", "samp", "script", "select", "small", "span", "strong", "style", "sub", "sup", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "title", "tr", "tt", "ul", "var"};

    public TagScanner(Colors colors) {
        super(colors);
        this.setDefaultReturnToken(this.createToken(Colors.TAG));
    }

    @Override
    protected void initializeRules(List<IRule> list) {
        IToken iToken = this.createToken(Colors.STRING);
        list.add((IRule)new SingleLineRule("\"", "\"", iToken, '\\'));
        list.add((IRule)new SingleLineRule("'", "'", iToken, '\\'));
        list.add((IRule)new WhitespaceRule((IWhitespaceDetector)new HtmlWhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new TagWordDetector(), this.createToken(Colors.OTHER), true);
        IToken iToken2 = this.createToken(Colors.KEYWORD);
        String[] stringArray = HTML_TAGS;
        int n = HTML_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            wordRule.addWord(string, iToken2);
            ++n2;
        }
        list.add((IRule)wordRule);
    }

    static class TagWordDetector
    implements IWordDetector {
        TagWordDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isLetter(c);
        }

        public boolean isWordPart(char c) {
            return Character.isLetter(c);
        }
    }
}

