/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.html.dom;

import com.subgraph.vega.internal.html.dom.HTMLOptionElementImpl;
import com.subgraph.vega.internal.html.dom.HTMLSelectElementImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.nodes.Element;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.html2.HTMLOptionElement;
import org.w3c.dom.html2.HTMLOptionsCollection;

public class HTMLOptionsCollectionImpl
implements HTMLOptionsCollection {
    private final List<HTMLOptionElementImpl> byIndex = new ArrayList<HTMLOptionElementImpl>();
    private final Map<String, HTMLOptionElement> byId = new HashMap<String, HTMLOptionElement>();
    private final Map<String, HTMLOptionElement> byName = new HashMap<String, HTMLOptionElement>();
    private final HTMLSelectElementImpl select;

    HTMLOptionsCollectionImpl(List<Element> list, HTMLSelectElementImpl hTMLSelectElementImpl, Document document) {
        this.select = hTMLSelectElementImpl;
        for (Element element : list) {
            int n = this.byIndex.size();
            HTMLOptionElementImpl hTMLOptionElementImpl = new HTMLOptionElementImpl(element, hTMLSelectElementImpl, n, document);
            this.addElement(hTMLOptionElementImpl);
        }
    }

    private void addElement(HTMLOptionElementImpl hTMLOptionElementImpl) {
        this.byIndex.add(hTMLOptionElementImpl);
        String string = hTMLOptionElementImpl.getAttribute("id");
        String string2 = hTMLOptionElementImpl.getAttribute("name");
        if (string != null) {
            this.byId.put(string, hTMLOptionElementImpl);
        }
        if (string2 != null) {
            this.byName.put(string2, hTMLOptionElementImpl);
        }
    }

    @Override
    public int getLength() {
        return this.byIndex.size();
    }

    @Override
    public void setLength(int n) throws DOMException {
    }

    @Override
    public HTMLOptionElementImpl item(int n) {
        if (n >= 0 && n < this.byIndex.size()) {
            return this.byIndex.get(n);
        }
        return null;
    }

    @Override
    public HTMLOptionElement namedItem(String string) {
        if (this.byId.containsKey(string)) {
            return this.byId.get(string);
        }
        return this.byName.get(string);
    }

    int getSelectedIndex() {
        for (HTMLOptionElement hTMLOptionElement : this.byIndex) {
            if (!hTMLOptionElement.hasAttribute("selected")) continue;
            return hTMLOptionElement.getIndex();
        }
        if (this.select.getMultiple()) {
            return -1;
        }
        return 0;
    }

    String getValue() {
        for (HTMLOptionElement hTMLOptionElement : this.byIndex) {
            if (!hTMLOptionElement.getSelected()) continue;
            return hTMLOptionElement.getValue();
        }
        return null;
    }
}

