/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.web.forms;

import com.subgraph.vega.api.model.web.forms.IWebForm;
import com.subgraph.vega.api.model.web.forms.IWebFormField;
import com.subgraph.vega.internal.model.web.forms.WebFormField;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class WebForm
implements IWebForm {
    private static final Logger logger = Logger.getLogger("forms");
    private final URI action;
    private final IWebForm.FormMethod method;
    private final IWebForm.EncType encoding;
    private final Map<String, WebFormField> fields;

    WebForm(URI uRI, IWebForm.FormMethod formMethod, IWebForm.EncType encType) {
        this.action = uRI;
        this.method = formMethod;
        this.encoding = encType;
        this.fields = new HashMap<String, WebFormField>();
    }

    public IWebForm.EncType getEncodingType() {
        return this.encoding;
    }

    public IWebForm.FormMethod getMethod() {
        return this.method;
    }

    public URI getAction() {
        return this.action;
    }

    public Collection<IWebFormField> getFields() {
        return new ArrayList<IWebFormField>(this.fields.values());
    }

    void addTextField(String string, String string2, String string3, String string4) {
        System.out.println("Text field name = " + string + " value = " + string2 + " label = " + string4);
        WebFormField webFormField = new WebFormField(IWebFormField.FieldType.INPUT_TEXT, string, string2, string3);
        if (string4 != null && string4.length() > 0) {
            webFormField.setLabel(string4);
        }
        this.fields.put(string, webFormField);
    }

    void addPasswordField(String string, String string2, String string3, String string4) {
        System.out.println("Password field name = " + string + " value = " + string2 + " label = " + string4);
        WebFormField webFormField = new WebFormField(IWebFormField.FieldType.INPUT_PASSWORD, string, string2, string3);
        if (string4 != null && string4.length() > 0) {
            webFormField.setLabel(string4);
        }
        this.fields.put(string, webFormField);
    }

    void addCheckboxField(String string, String string2, String string3, boolean bl) {
        WebFormField webFormField;
        if (!this.fields.containsKey(string)) {
            this.fields.put(string, new WebFormField(IWebFormField.FieldType.INPUT_CHECKBOX, string, null, string3));
        }
        if ((webFormField = this.fields.get(string)).getType() != IWebFormField.FieldType.INPUT_CHECKBOX) {
            logger.warning("Cannot add checkbox field because field name " + string + " is duplicated");
            return;
        }
        webFormField.addValue(string2, bl);
    }

    void addRadioField(String string, String string2, String string3, boolean bl) {
        WebFormField webFormField;
        if (!this.fields.containsKey(string)) {
            this.fields.put(string, new WebFormField(IWebFormField.FieldType.INPUT_RADIO, string, null, string3));
        }
        if ((webFormField = this.fields.get(string)).getType() != IWebFormField.FieldType.INPUT_RADIO) {
            logger.warning("Cannot add radio field because field name " + string + " is duplicated");
            return;
        }
        webFormField.addValue(string2, bl);
    }

    void addHiddenField(String string, String string2, String string3) {
        this.fields.put(string, new WebFormField(IWebFormField.FieldType.INPUT_HIDDEN, string, string2, string3));
    }

    void addFileField(String string) {
        this.fields.put(string, new WebFormField(IWebFormField.FieldType.INPUT_FILE, string, null, null));
    }

    void addSelectOption(String string, String string2, boolean bl) {
    }

    void addTextArea(String string, String string2) {
        this.fields.put(string, new WebFormField(IWebFormField.FieldType.TEXTAREA, string, string2, null));
    }

    void addLabelToField(String string, String string2) {
        for (WebFormField webFormField : this.fields.values()) {
            if (webFormField.getId() == null || !webFormField.getId().equalsIgnoreCase(string)) continue;
            webFormField.setLabel(string2);
            return;
        }
        logger.warning("Could not find corresponding field element with id = " + string + " for <LABEL> content " + string2);
    }
}

