/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.macros;

import com.db4o.activation.ActivationPurpose;
import com.db4o.activation.Activator;
import com.db4o.collections.ActivatableArrayList;
import com.db4o.ta.Activatable;
import com.subgraph.vega.api.http.requests.IHttpHeaderBuilder;
import com.subgraph.vega.api.http.requests.IHttpMacroContext;
import com.subgraph.vega.api.http.requests.IHttpRequestBuilder;
import com.subgraph.vega.api.model.macros.IHttpMacroItem;
import com.subgraph.vega.api.model.macros.IHttpMacroItemParam;
import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import com.subgraph.vega.http.requests.builder.HttpRequestBuilder;
import com.subgraph.vega.internal.model.macros.HttpMacroItemParam;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;

public class HttpMacroItem
implements IHttpMacroItem,
Activatable {
    private static final String[] HEADERS_RM = new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade", "Proxy-Connection", "Content-Length", "Content-Type", "Cookie"};
    private transient Activator activator;
    private IRequestLogRecord requestLogRecord;
    private HttpParams requestParams;
    private String requestMethod;
    private ProtocolVersion requestProtocolVersion;
    private String requestScheme;
    private String requestHost;
    private int requestPort;
    private String requestPath;
    private final ArrayList<Header> requestHeaderList = new ArrayList();
    private boolean useCookies;
    private boolean keepCookies;
    private ActivatableArrayList<IHttpMacroItemParam> paramList;

    public HttpMacroItem(IRequestLogRecord iRequestLogRecord) throws URISyntaxException, IOException {
        this.requestLogRecord = iRequestLogRecord;
        this.useCookies = true;
        this.keepCookies = true;
        HttpRequest httpRequest = iRequestLogRecord.getRequest();
        this.processRequest(httpRequest, iRequestLogRecord.getHttpHost());
        this.paramList = new ActivatableArrayList();
        this.processParams(httpRequest);
    }

    public IRequestLogRecord getRequestLogRecord() {
        this.activate(ActivationPurpose.READ);
        return this.requestLogRecord;
    }

    public void setUseCookies(boolean bl) {
        this.activate(ActivationPurpose.READ);
        this.useCookies = bl;
        this.activate(ActivationPurpose.WRITE);
    }

    public boolean getUseCookies() {
        this.activate(ActivationPurpose.READ);
        return this.useCookies;
    }

    public void setKeepCookies(boolean bl) {
        this.activate(ActivationPurpose.READ);
        this.keepCookies = bl;
        this.activate(ActivationPurpose.WRITE);
    }

    public boolean getKeepCookies() {
        this.activate(ActivationPurpose.READ);
        return this.keepCookies;
    }

    public IHttpMacroItemParam createParam(String string, String string2, IHttpMacroItemParam.ValueSetIn valueSetIn) {
        HttpMacroItemParam httpMacroItemParam = new HttpMacroItemParam(string, string2, valueSetIn);
        this.paramList.add((Object)httpMacroItemParam);
        return httpMacroItemParam;
    }

    public void removeParam(IHttpMacroItemParam iHttpMacroItemParam) {
        this.paramList.remove((Object)iHttpMacroItemParam);
    }

    public int paramsSize() {
        return this.paramList.size();
    }

    public int indexOfParam(IHttpMacroItemParam iHttpMacroItemParam) {
        return this.paramList.indexOf((Object)iHttpMacroItemParam);
    }

    public void swapParams(int n, int n2) {
        if (n < this.paramList.size() && n2 < this.paramList.size() && n != n2) {
            IHttpMacroItemParam iHttpMacroItemParam = (IHttpMacroItemParam)this.paramList.set(n, (Object)((IHttpMacroItemParam)this.paramList.get(n2)));
            this.paramList.set(n2, (Object)iHttpMacroItemParam);
        }
    }

    public Collection<IHttpMacroItemParam> getParams() {
        return new ArrayList<IHttpMacroItemParam>((Collection<IHttpMacroItemParam>)this.paramList);
    }

    public IHttpMacroItemParam[] getParam(String string) {
        ArrayList<IHttpMacroItemParam> arrayList = new ArrayList<IHttpMacroItemParam>();
        for (IHttpMacroItemParam iHttpMacroItemParam : this.paramList) {
            if (!iHttpMacroItemParam.getName().equals(string)) continue;
            arrayList.add(iHttpMacroItemParam);
        }
        return arrayList.toArray(new IHttpMacroItemParam[0]);
    }

    public HttpUriRequest createRequest(IHttpMacroContext iHttpMacroContext) throws UnsupportedEncodingException, URISyntaxException {
        HttpRequestBuilder httpRequestBuilder = new HttpRequestBuilder();
        this.setRequestBuilder((IHttpRequestBuilder)httpRequestBuilder, iHttpMacroContext);
        return httpRequestBuilder.buildRequest(false);
    }

    public void setRequestBuilder(IHttpRequestBuilder iHttpRequestBuilder, IHttpMacroContext iHttpMacroContext) throws UnsupportedEncodingException, URISyntaxException {
        this.activate(ActivationPurpose.READ);
        this.setRequestParams(iHttpRequestBuilder);
        this.setRequestLine(iHttpRequestBuilder, iHttpMacroContext);
        this.setRequestHeaders(iHttpRequestBuilder);
        this.setRequestBody(iHttpRequestBuilder, iHttpMacroContext);
    }

    public void updateFromRequestBuilder(IHttpRequestBuilder iHttpRequestBuilder) throws URISyntaxException {
        this.activate(ActivationPurpose.READ);
        this.requestParams = iHttpRequestBuilder.getParams().copy();
        this.requestMethod = iHttpRequestBuilder.getMethod();
        this.requestScheme = iHttpRequestBuilder.getScheme();
        this.requestHost = iHttpRequestBuilder.getHost();
        this.requestPort = iHttpRequestBuilder.getHostPort();
        URI uRI = new URI(iHttpRequestBuilder.getPath());
        this.requestPath = uRI.getRawPath();
        this.requestProtocolVersion = iHttpRequestBuilder.getProtocolVersion();
        this.requestHeaderList.clear();
        IHttpHeaderBuilder[] iHttpHeaderBuilderArray = iHttpRequestBuilder.getHeaders();
        int n = iHttpHeaderBuilderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IHttpHeaderBuilder iHttpHeaderBuilder = iHttpHeaderBuilderArray[n2];
            this.requestHeaderList.add(iHttpHeaderBuilder.buildHeader());
            ++n2;
        }
        this.activate(ActivationPurpose.WRITE);
    }

    private void setRequestParams(IHttpRequestBuilder iHttpRequestBuilder) {
        iHttpRequestBuilder.setParams(this.requestParams.copy());
    }

    private void setRequestLine(IHttpRequestBuilder iHttpRequestBuilder, IHttpMacroContext iHttpMacroContext) throws URISyntaxException {
        iHttpRequestBuilder.setMethod(this.requestMethod);
        this.setRequestUri(iHttpRequestBuilder, iHttpMacroContext);
        iHttpRequestBuilder.setProtocolVersion(this.requestProtocolVersion);
    }

    private void setRequestUri(IHttpRequestBuilder iHttpRequestBuilder, IHttpMacroContext iHttpMacroContext) throws URISyntaxException {
        iHttpRequestBuilder.setScheme(this.requestScheme);
        iHttpRequestBuilder.setHost(this.requestHost);
        iHttpRequestBuilder.setHostPort(this.requestPort);
        String string = this.createUriQuery(iHttpMacroContext);
        String string2 = this.requestPath;
        if (string.length() != 0) {
            string2 = String.valueOf(string2) + "?" + string;
        }
        iHttpRequestBuilder.setPath(string2);
    }

    private void setRequestHeaders(IHttpRequestBuilder iHttpRequestBuilder) {
        iHttpRequestBuilder.setHeaders(this.requestHeaderList.toArray(new Header[0]));
    }

    private void setRequestBody(IHttpRequestBuilder iHttpRequestBuilder, IHttpMacroContext iHttpMacroContext) throws UnsupportedEncodingException {
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
        for (IHttpMacroItemParam iHttpMacroItemParam : this.paramList) {
            if (iHttpMacroItemParam.getSetIn() != IHttpMacroItemParam.ValueSetIn.VALUE_SET_IN_BODY) continue;
            arrayList.add(new BasicNameValuePair(iHttpMacroItemParam.getName(), iHttpMacroItemParam.getValue()));
        }
        if (arrayList.size() != 0) {
            IHttpMacroItemParam iHttpMacroItemParam;
            iHttpMacroItemParam = new StringEntity(URLEncodedUtils.format(arrayList, (String)"UTF-8"), "UTF-8");
            iHttpMacroItemParam.setContentType("application/x-www-form-urlencoded");
            iHttpRequestBuilder.setEntity((HttpEntity)iHttpMacroItemParam);
            iHttpRequestBuilder.setMethod("POST");
        }
    }

    private String createUriQuery(IHttpMacroContext iHttpMacroContext) {
        StringBuilder stringBuilder = new StringBuilder();
        for (IHttpMacroItemParam iHttpMacroItemParam : this.paramList) {
            if (iHttpMacroItemParam.getSetIn() != IHttpMacroItemParam.ValueSetIn.VALUE_SET_IN_URI) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(iHttpMacroItemParam.getName());
            stringBuilder.append('=');
            stringBuilder.append(iHttpMacroItemParam.getValue());
        }
        return stringBuilder.toString();
    }

    private void processRequest(HttpRequest httpRequest, HttpHost httpHost) throws URISyntaxException {
        this.requestParams = httpRequest.getParams().copy();
        RequestLine requestLine = httpRequest.getRequestLine();
        this.requestMethod = requestLine.getMethod();
        this.requestScheme = httpHost.getSchemeName();
        this.requestHost = httpHost.getHostName();
        this.requestPort = httpHost.getPort();
        URI uRI = new URI(httpRequest.getRequestLine().getUri());
        this.requestPath = uRI.getRawPath();
        this.requestProtocolVersion = requestLine.getProtocolVersion();
        this.requestHeaderList.clear();
        Collections.addAll(this.requestHeaderList, this.copyHeaders(httpRequest.getAllHeaders()));
    }

    private void processParams(HttpRequest httpRequest) throws URISyntaxException, IOException {
        this.processParamsUri(httpRequest);
        this.processParamsBody(httpRequest);
    }

    private void processParamsUri(HttpRequest httpRequest) throws URISyntaxException {
        URI uRI = new URI(httpRequest.getRequestLine().getUri());
        List list = URLEncodedUtils.parse((URI)uRI, (String)"UTF-8");
        for (NameValuePair nameValuePair : list) {
            this.paramList.add((Object)new HttpMacroItemParam(nameValuePair.getName(), nameValuePair.getValue(), IHttpMacroItemParam.ValueSetIn.VALUE_SET_IN_URI));
        }
    }

    private void processParamsBody(HttpRequest httpRequest) throws IOException {
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            List list = null;
            list = URLEncodedUtils.parse((HttpEntity)((HttpEntityEnclosingRequest)httpRequest).getEntity());
            for (NameValuePair nameValuePair : list) {
                this.paramList.add((Object)new HttpMacroItemParam(nameValuePair.getName(), nameValuePair.getValue(), IHttpMacroItemParam.ValueSetIn.VALUE_SET_IN_BODY));
            }
        }
    }

    private Header[] copyHeaders(Header[] headerArray) {
        ArrayList<Header> arrayList = new ArrayList<Header>();
        Header[] headerArray2 = headerArray;
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray2[n2];
            int n3 = 0;
            while (n3 < HEADERS_RM.length) {
                if (HEADERS_RM[n3].equals(header.getName())) break;
                ++n3;
            }
            if (n3 == HEADERS_RM.length) {
                arrayList.add(header);
            }
            ++n2;
        }
        return arrayList.toArray(new Header[0]);
    }

    public void activate(ActivationPurpose activationPurpose) {
        if (this.activator != null) {
            this.activator.activate(activationPurpose);
        }
    }

    public void bind(Activator activator) {
        if (this.activator == activator) {
            return;
        }
        if (activator != null && this.activator != null) {
            throw new IllegalStateException("Object can only be bound to one activator");
        }
        this.activator = activator;
    }
}

