/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.identity;

import com.db4o.activation.ActivationPurpose;
import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.model.identity.IAuthMethod;
import com.subgraph.vega.api.model.identity.IAuthMethodRfc2617;
import com.subgraph.vega.internal.model.identity.AbstractAuthMethod;
import java.util.ArrayList;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;

public class AuthMethodRfc2617
extends AbstractAuthMethod
implements IAuthMethodRfc2617 {
    private IAuthMethodRfc2617.AuthScheme authScheme = IAuthMethodRfc2617.AuthScheme.AUTH_SCHEME_DIGEST;
    private String username;
    private String password;
    private String charset;

    protected AuthMethodRfc2617() {
        super(IAuthMethod.AuthMethodType.AUTH_METHOD_RFC2617);
    }

    public void setAuthScheme(IAuthMethodRfc2617.AuthScheme authScheme) {
        this.activate(ActivationPurpose.READ);
        this.authScheme = authScheme;
        this.activate(ActivationPurpose.WRITE);
    }

    public IAuthMethodRfc2617.AuthScheme getAuthScheme() {
        this.activate(ActivationPurpose.READ);
        return this.authScheme;
    }

    public void setUsername(String string) {
        this.activate(ActivationPurpose.READ);
        this.username = string;
        this.activate(ActivationPurpose.WRITE);
    }

    public String getUsername() {
        this.activate(ActivationPurpose.READ);
        return this.username;
    }

    public void setPassword(String string) {
        this.activate(ActivationPurpose.READ);
        this.password = string;
        this.activate(ActivationPurpose.WRITE);
    }

    public String getPassword() {
        this.activate(ActivationPurpose.READ);
        return this.password;
    }

    public void setCharset(String string) {
        this.activate(ActivationPurpose.READ);
        this.charset = string;
        this.activate(ActivationPurpose.WRITE);
    }

    public String getCharset() {
        this.activate(ActivationPurpose.READ);
        return this.charset;
    }

    public void setAuth(IHttpRequestEngine iHttpRequestEngine) {
        this.activate(ActivationPurpose.READ);
        HttpClient httpClient = iHttpRequestEngine.getHttpClient();
        ArrayList<String> arrayList = new ArrayList<String>(1);
        switch (this.authScheme) {
            case AUTH_SCHEME_BASIC: {
                arrayList.add("Basic");
                break;
            }
            case AUTH_SCHEME_DIGEST: {
                arrayList.add("Digest");
            }
        }
        httpClient.getParams().setParameter("http.auth.target-scheme-pref", arrayList);
        HttpContext httpContext = iHttpRequestEngine.getHttpContext();
        UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this.username, this.password);
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        basicCredentialsProvider.setCredentials(AuthScope.ANY, (Credentials)usernamePasswordCredentials);
        httpContext.setAttribute("http.auth.credentials-provider", (Object)basicCredentialsProvider);
    }
}

