/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.conditions;

import com.db4o.query.Constraint;
import com.db4o.query.Query;
import com.subgraph.vega.api.model.conditions.IHttpCondition;
import com.subgraph.vega.api.model.conditions.IHttpConditionType;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionMatchAction;
import com.subgraph.vega.internal.model.conditions.AbstractCondition;
import com.subgraph.vega.internal.model.conditions.ConditionType;
import com.subgraph.vega.internal.model.conditions.match.IntegerMatchActionSet;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

public class ConditionResponseLength
extends AbstractCondition {
    private static transient IHttpConditionType conditionType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IHttpConditionType getConditionType() {
        Class<ConditionResponseLength> clazz = ConditionResponseLength.class;
        synchronized (ConditionResponseLength.class) {
            if (conditionType == null) {
                conditionType = ConditionResponseLength.createType();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return conditionType;
        }
    }

    private static IHttpConditionType createType() {
        return new ConditionType("response length", new IntegerMatchActionSet()){

            public IHttpCondition createConditionInstance(IHttpConditionMatchAction iHttpConditionMatchAction) {
                return new ConditionResponseLength(iHttpConditionMatchAction, null);
            }
        };
    }

    private ConditionResponseLength(IHttpConditionMatchAction iHttpConditionMatchAction) {
        super(iHttpConditionMatchAction);
    }

    public boolean matches(HttpRequest httpRequest) {
        return false;
    }

    public boolean matches(HttpResponse httpResponse) {
        int n = (int)this.getLengthFromResponse(httpResponse);
        return this.matchesInteger(n);
    }

    private long getLengthFromResponse(HttpResponse httpResponse) {
        Header header = httpResponse.getFirstHeader("Content-Length");
        if (header != null) {
            try {
                return Long.parseLong(header.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                return 0L;
            }
        }
        if (httpResponse.getEntity() == null) {
            return 0L;
        }
        return httpResponse.getEntity().getContentLength();
    }

    public boolean matches(HttpRequest httpRequest, HttpResponse httpResponse) {
        return this.matches(httpResponse);
    }

    public IHttpConditionType getType() {
        return ConditionResponseLength.getConditionType();
    }

    @Override
    public Constraint filterRequestLogQuery(Query query) {
        return this.constrainQuery(query.descend("responseLength"));
    }

    /* synthetic */ ConditionResponseLength(IHttpConditionMatchAction iHttpConditionMatchAction, ConditionResponseLength conditionResponseLength) {
        this(iHttpConditionMatchAction);
    }
}

