/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.alerts;

import com.db4o.ObjectContainer;
import com.db4o.activation.ActivationPurpose;
import com.db4o.activation.Activator;
import com.db4o.ta.Activatable;
import com.subgraph.vega.api.events.EventListenerManager;
import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.model.alerts.ScanExceptionEvent;
import com.subgraph.vega.api.model.alerts.ScanPauseStateChangedEvent;
import com.subgraph.vega.api.model.alerts.ScanStatusChangeEvent;
import com.subgraph.vega.api.scanner.IScan;
import com.subgraph.vega.internal.model.ModelProperties;
import com.subgraph.vega.internal.model.alerts.ScanAlertFactory;
import com.subgraph.vega.internal.model.alerts.ScanAlertRepository;
import com.subgraph.vega.internal.model.alerts.ScanInstanceAlerts;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.http.client.methods.HttpUriRequest;

public class ScanInstance
implements IScanInstance,
Activatable {
    private final long scanId;
    private final ModelProperties properties;
    private volatile Date startTime;
    private volatile Date stopTime;
    private volatile int scanStatus;
    private volatile transient IScan scan;
    private volatile transient int activeScanCompletedCount;
    private volatile transient int activeScanTotalCount;
    private volatile transient String currentPath;
    private volatile transient boolean isPaused;
    private transient ScanAlertRepository repository;
    private transient ScanInstanceAlerts scanAlerts;
    private transient EventListenerManager eventManager;
    private transient Activator activator;

    public ScanInstance(long l) {
        this.scanId = l;
        this.scanStatus = 0;
        this.properties = new ModelProperties();
    }

    public void setTransientState(ObjectContainer objectContainer, ScanAlertRepository scanAlertRepository, ScanAlertFactory scanAlertFactory) {
        this.eventManager = new EventListenerManager();
        this.repository = scanAlertRepository;
        this.scanAlerts = new ScanInstanceAlerts(objectContainer, this, this.eventManager, scanAlertFactory);
    }

    public long getScanId() {
        this.activate(ActivationPurpose.READ);
        return this.scanId;
    }

    public IScan getScan() {
        return this.scan;
    }

    public Date getStartTime() {
        this.activate(ActivationPurpose.READ);
        return this.startTime;
    }

    public Date getStopTime() {
        this.activate(ActivationPurpose.READ);
        return this.stopTime;
    }

    public IScanAlert createAlert(String string) {
        return this.createAlert(string, null, -1L);
    }

    public IScanAlert createAlert(String string, String string2) {
        return this.createAlert(string, string2, -1L);
    }

    public IScanAlert createAlert(String string, String string2, long l) {
        this.activate(ActivationPurpose.READ);
        return this.scanAlerts.createAlert(string, string2, l);
    }

    public void addAlert(IScanAlert iScanAlert) {
        this.activate(ActivationPurpose.READ);
        this.scanAlerts.addAlert(iScanAlert);
    }

    public void removeAlert(IScanAlert iScanAlert) {
        this.removeAlerts(Arrays.asList(iScanAlert));
    }

    public void removeAlerts(Collection<IScanAlert> collection) {
        this.activate(ActivationPurpose.READ);
        this.scanAlerts.removeAlerts(collection);
        this.repository.fireRemoveEventsEvent(this, collection);
    }

    public boolean hasAlertKey(String string) {
        return this.getAlertByKey(string) != null;
    }

    public IScanAlert getAlertByKey(String string) {
        this.activate(ActivationPurpose.READ);
        return this.scanAlerts.getAlertByKey(string);
    }

    public List<IScanAlert> getAllAlerts() {
        this.activate(ActivationPurpose.READ);
        return this.scanAlerts.getAllAlerts();
    }

    public void addScanEventListenerAndPopulate(IEventHandler iEventHandler) {
        this.scanAlerts.addScanEventListenerAndPopulate(iEventHandler);
        iEventHandler.handleEvent((IEvent)new ScanStatusChangeEvent((IScanInstance)this, this.currentPath, this.scanStatus, this.activeScanCompletedCount, this.activeScanTotalCount));
    }

    public void removeScanEventListener(IEventHandler iEventHandler) {
        this.eventManager.removeListener(iEventHandler);
    }

    public int getScanStatus() {
        this.activate(ActivationPurpose.READ);
        return this.scanStatus;
    }

    public boolean isActive() {
        int n = this.getScanStatus();
        return n == 1 || n == 2 || n == 3;
    }

    public boolean isComplete() {
        int n = this.getScanStatus();
        return n == 5 || n == 4;
    }

    public String getScanCurrentPath() {
        return this.currentPath;
    }

    public int getScanCompletedCount() {
        return this.activeScanCompletedCount;
    }

    public int getScanTotalCount() {
        return this.activeScanTotalCount;
    }

    public void setScan(IScan iScan) {
        this.scan = iScan;
    }

    public void updateScanProgress(String string, int n, int n2) {
        if (string != null) {
            this.currentPath = string;
        }
        this.activeScanCompletedCount = n;
        this.activeScanTotalCount = n2;
        this.eventManager.fireEvent((IEvent)new ScanStatusChangeEvent((IScanInstance)this, this.currentPath, this.scanStatus, this.activeScanCompletedCount, this.activeScanTotalCount));
    }

    public void updateScanProgress(int n, int n2) {
        this.activeScanCompletedCount = n;
        this.activeScanTotalCount = n2;
        this.eventManager.fireEvent((IEvent)new ScanStatusChangeEvent((IScanInstance)this, this.currentPath, this.scanStatus, n, n2));
    }

    public synchronized void updateScanStatus(int n) {
        this.activate(ActivationPurpose.READ);
        if ((n == 1 || n == 2) && this.startTime == null) {
            this.startTime = new Date();
        } else if ((n == 4 || n == 5) && this.stopTime == null) {
            this.stopTime = new Date();
        }
        if (n == 5 && this.isPaused) {
            this.isPaused = false;
        }
        this.scanStatus = n;
        this.eventManager.fireEvent((IEvent)new ScanStatusChangeEvent((IScanInstance)this, this.currentPath, n, this.activeScanCompletedCount, this.activeScanTotalCount));
        this.activate(ActivationPurpose.WRITE);
    }

    public void notifyScanException(HttpUriRequest httpUriRequest, Throwable throwable) {
        this.eventManager.fireEvent((IEvent)new ScanExceptionEvent(httpUriRequest, throwable));
    }

    public void notifyScanPauseState(boolean bl) {
        this.isPaused = bl;
        this.eventManager.fireEvent((IEvent)new ScanPauseStateChangedEvent(bl));
    }

    public boolean isScanPaused() {
        return this.isPaused;
    }

    public void deleteScanInstance() {
        this.eventManager.clearListeners();
        this.scanAlerts.removeAllAlerts();
    }

    public void setProperty(String string, Object object) {
        this.activate(ActivationPurpose.WRITE);
        this.properties.setProperty(string, object);
    }

    public void setStringProperty(String string, String string2) {
        this.activate(ActivationPurpose.WRITE);
        this.properties.setStringProperty(string, string2);
    }

    public void setIntegerProperty(String string, int n) {
        this.activate(ActivationPurpose.WRITE);
        this.properties.setIntegerProperty(string, n);
    }

    public Object getProperty(String string) {
        this.activate(ActivationPurpose.READ);
        return this.properties.getProperty(string);
    }

    public String getStringProperty(String string) {
        this.activate(ActivationPurpose.READ);
        return this.properties.getStringProperty(string);
    }

    public Integer getIntegerProperty(String string) {
        this.activate(ActivationPurpose.READ);
        return this.properties.getIntegerProperty(string);
    }

    public List<String> propertyKeys() {
        this.activate(ActivationPurpose.READ);
        return this.properties.propertyKeys();
    }

    public void activate(ActivationPurpose activationPurpose) {
        if (this.activator != null) {
            this.activator.activate(activationPurpose);
        }
    }

    public void bind(Activator activator) {
        if (this.activator == activator) {
            return;
        }
        if (activator != null && this.activator != null) {
            throw new IllegalStateException("Object can only be bound to one activator");
        }
        this.activator = activator;
    }
}

