/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner.state;

import com.subgraph.vega.api.analysis.IContentAnalyzer;
import com.subgraph.vega.api.crawler.ICrawlerResponseProcessor;
import com.subgraph.vega.api.crawler.IWebCrawler;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.model.requests.IRequestLog;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.scanner.IInjectionModuleContext;
import com.subgraph.vega.api.scanner.IScannerConfig;
import com.subgraph.vega.api.scanner.modules.IBasicModuleScript;
import com.subgraph.vega.impl.scanner.handlers.DirectoryProcessor;
import com.subgraph.vega.impl.scanner.state.PathState;
import com.subgraph.vega.impl.scanner.state.Wordlists;
import com.subgraph.vega.impl.scanner.urls.ResponseAnalyzer;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.http.client.methods.HttpUriRequest;

public class PathStateManager {
    private final Logger logger = Logger.getLogger("scanner");
    private final IScannerConfig config;
    private List<IBasicModuleScript> injectionModules;
    private final IWorkspace workspace;
    private final IWebCrawler crawler;
    private final ResponseAnalyzer responseAnalyzer;
    private final boolean isProxyScan;
    private final ICrawlerResponseProcessor directoryFetchCallback = new DirectoryProcessor();
    private final Wordlists wordlists = new Wordlists();
    private final Map<IWebPath, PathState> modelToScanState = new HashMap<IWebPath, PathState>();
    private int currentXssId = 0;
    private final Map<Integer, HttpUriRequest> xssRequests = new HashMap<Integer, HttpUriRequest>();
    private final IScanInstance scanInstance;
    private Object progressLock = new Object();
    private volatile int totalPathCount;
    private volatile int completedPathCount;

    public PathStateManager(IScannerConfig iScannerConfig, List<IBasicModuleScript> list, IWorkspace iWorkspace, IWebCrawler iWebCrawler, ResponseAnalyzer responseAnalyzer, IScanInstance iScanInstance, boolean bl) {
        this.config = iScannerConfig;
        this.injectionModules = list;
        this.workspace = iWorkspace;
        this.crawler = iWebCrawler;
        this.responseAnalyzer = responseAnalyzer;
        this.scanInstance = iScanInstance;
        this.isProxyScan = bl;
    }

    public void setInjectionModules(List<IBasicModuleScript> list) {
        this.injectionModules = list;
    }

    public List<IBasicModuleScript> getInjectionModules() {
        return this.injectionModules;
    }

    public boolean requestLoggingEnabled() {
        return this.config.getLogAllRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSeenPath(IWebPath iWebPath) {
        Map<IWebPath, PathState> map = this.modelToScanState;
        synchronized (map) {
            return this.modelToScanState.containsKey(iWebPath);
        }
    }

    public boolean isProxyScan() {
        return this.isProxyScan;
    }

    private PathState getParentDirectoryState(IWebPath iWebPath) {
        IWebPath iWebPath2 = iWebPath.getParentPath();
        if (iWebPath2 == null) {
            return null;
        }
        if (!this.modelToScanState.containsKey(iWebPath2)) {
            if (iWebPath2.getPathType() != IWebPath.PathType.PATH_DIRECTORY) {
                iWebPath2.setPathType(IWebPath.PathType.PATH_DIRECTORY);
            }
            PathState pathState = this.createStateForPathNoChecks(iWebPath2, this.directoryFetchCallback);
            this.modelToScanState.put(iWebPath2, pathState);
            return pathState;
        }
        return this.modelToScanState.get(iWebPath2);
    }

    public PathState createStateForPath(IWebPath iWebPath, ICrawlerResponseProcessor iCrawlerResponseProcessor) {
        PathState pathState = this.getParentDirectoryState(iWebPath);
        if (pathState != null) {
            if (this.hasExceededLimits(pathState)) {
                this.logger.warning("Failed to add " + iWebPath.getUri().toString() + " due to exceeded limits");
                return null;
            }
            if (this.exceedsDuplicatePathLimit(iWebPath.getPathComponent(), pathState)) {
                this.logger.warning("Maximum duplicate path limit of " + this.config.getMaxDuplicatePaths() + " exceeded adding " + iWebPath.getUri().toString());
                return null;
            }
        }
        return this.createStateForPathNoChecks(iWebPath, iCrawlerResponseProcessor);
    }

    boolean hasExceededLimits(PathState pathState) {
        if (pathState.getDepth() > this.config.getMaxDepth()) {
            this.logger.warning("Maximum path depth of " + this.config.getMaxDepth() + " exceeded at " + pathState.getPath().getUri().toString());
            return true;
        }
        if (pathState.getChildCount() > this.config.getMaxChildren()) {
            this.logger.warning("Maximum child path count of " + this.config.getMaxChildren() + " exceeded at " + pathState.getPath().getUri().toString());
            return true;
        }
        if (pathState.getDescendantCount() > this.config.getMaxDescendants()) {
            this.logger.warning("Maximum total descendant count of " + this.config.getMaxDescendants() + " exceeded at " + pathState.getPath().getUri().toString());
            return true;
        }
        return false;
    }

    private boolean exceedsDuplicatePathLimit(String string, PathState pathState) {
        int n = 0;
        PathState pathState2 = pathState;
        while (pathState2 != null) {
            if (pathState2.getPath().getPathComponent().equalsIgnoreCase(string)) {
                ++n;
            }
            pathState2 = pathState2.getParentState();
        }
        return n > this.config.getMaxDuplicatePaths();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PathState createStateForPathNoChecks(IWebPath iWebPath, ICrawlerResponseProcessor iCrawlerResponseProcessor) {
        Map<IWebPath, PathState> map = this.modelToScanState;
        synchronized (map) {
            if (iWebPath == null) {
                throw new NullPointerException();
            }
            if (this.modelToScanState.containsKey(iWebPath)) {
                throw new IllegalStateException("Path already exists." + iWebPath);
            }
            PathState pathState = this.getParentDirectoryState(iWebPath);
            PathState pathState2 = PathState.createBasicPathState(iCrawlerResponseProcessor, this, pathState, iWebPath);
            this.modelToScanState.put(iWebPath, pathState2);
            return pathState2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PathState getStateForPath(IWebPath iWebPath) {
        if (iWebPath == null) {
            return null;
        }
        Map<IWebPath, PathState> map = this.modelToScanState;
        synchronized (map) {
            return this.modelToScanState.get(iWebPath);
        }
    }

    public IWebCrawler getCrawler() {
        return this.crawler;
    }

    public void analyzePage(IInjectionModuleContext iInjectionModuleContext, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse) {
        this.responseAnalyzer.analyzePage(iInjectionModuleContext, httpUriRequest, iHttpResponse);
    }

    public void analyzeContent(IInjectionModuleContext iInjectionModuleContext, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse) {
        this.responseAnalyzer.analyzeContent(iInjectionModuleContext, httpUriRequest, iHttpResponse);
    }

    public void analyzePivot(IInjectionModuleContext iInjectionModuleContext, HttpUriRequest httpUriRequest, IHttpResponse iHttpResponse) {
        this.responseAnalyzer.analyzePivot(iInjectionModuleContext, httpUriRequest, iHttpResponse);
    }

    public String createXssTag(int n) {
        return this.createXssTag("", n);
    }

    public String createXssPattern(int n) {
        return this.createXssPattern("", n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int allocateXssId() {
        Map<Integer, HttpUriRequest> map = this.xssRequests;
        synchronized (map) {
            return this.currentXssId++;
        }
    }

    public String createXssTag(String string, int n) {
        if (this.scanInstance.getScanId() == -1L) {
            return this.formatXssTag(string, n, 0L);
        }
        return this.formatXssTag(string, n, this.scanInstance.getScanId());
    }

    public String createXssPattern(String string, int n) {
        if (this.scanInstance.getScanId() == -1L) {
            return this.formatXssPattern(string, n, 0L);
        }
        return this.formatXssPattern(string, n, this.scanInstance.getScanId());
    }

    private String formatXssTag(String string, int n, long l) {
        return String.format("%s-->\">'>'\"<vvv%06dv%06d>", string, n, l);
    }

    private String formatXssPattern(String string, int n, long l) {
        return String.format("%svvv%06dv%06d", string, n, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerXssRequest(HttpUriRequest httpUriRequest, int n) {
        Map<Integer, HttpUriRequest> map = this.xssRequests;
        synchronized (map) {
            this.xssRequests.put(n, httpUriRequest);
        }
    }

    public long getScanId() {
        return this.scanInstance.getScanId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpUriRequest getXssRequest(int n, int n2) {
        Map<Integer, HttpUriRequest> map = this.xssRequests;
        synchronized (map) {
            if (this.isValidXssId(n, n2)) {
                return this.xssRequests.get(n);
            }
            return null;
        }
    }

    private boolean isValidXssId(int n, int n2) {
        if (n2 == 0 && this.scanInstance.getScanId() == -1L && n < this.currentXssId) {
            return true;
        }
        return (long)n2 == this.scanInstance.getScanId() && n < this.currentXssId;
    }

    public IRequestLog getRequestLog() {
        return this.workspace.getRequestLog();
    }

    public IScanInstance getScanInstance() {
        return this.scanInstance;
    }

    public boolean isExcludedParameter(String string) {
        return this.config.getExcludedParameterNames().contains(string.toLowerCase());
    }

    public void debug(String string) {
        if (this.config.getDisplayDebugOutput()) {
            this.logger.info(string);
        }
    }

    public void debug(String string, Boolean bl) {
        if (this.config.getDisplayDebugOutput()) {
            if (bl.booleanValue()) {
                this.logger.finer(string);
            } else {
                this.logger.info(string);
            }
        }
    }

    public void reportRequestException(HttpUriRequest httpUriRequest, Throwable throwable) {
        this.logger.warning("Exception processing request: " + httpUriRequest + " : " + throwable.getMessage());
        this.scanInstance.notifyScanException(httpUriRequest, throwable);
    }

    public List<String> getFileExtensionList() {
        return this.wordlists.getFileExtensions();
    }

    public IContentAnalyzer getContentAnalyzer() {
        return this.responseAnalyzer.getContentAnalyzer();
    }

    public boolean getDirectoryInjectionChecksFlag() {
        return this.config.getDirectoryInjectionChecksFlag();
    }

    public boolean getNonParameterFileInjectionChecksFlag() {
        return this.config.getNonParameterFileInjectionChecksFlag();
    }

    public int getMaxParameterCount() {
        return this.config.getMaxParameterCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPathNodeStart(PathState pathState) {
        String string = this.pathNodeToPathString(pathState);
        this.debug("Starting path " + string);
        Object object = this.progressLock;
        synchronized (object) {
            if (this.totalPathCount == 0) {
                this.scanInstance.updateScanProgress(string, 0, 1);
            }
            ++this.totalPathCount;
        }
        this.scanInstance.updateScanProgress(this.completedPathCount, this.totalPathCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPathNodeFinish(PathState pathState) {
        String string = this.pathNodeToPathString(pathState);
        this.debug("Finished path " + string);
        Object object = this.progressLock;
        synchronized (object) {
            ++this.completedPathCount;
        }
        this.scanInstance.updateScanProgress(string, this.completedPathCount, this.totalPathCount);
    }

    private String pathNodeToPathString(PathState pathState) {
        URI uRI = pathState.getPath().getUri();
        return uRI.toString();
    }
}

