/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner;

import com.subgraph.vega.api.analysis.IContentAnalyzerFactory;
import com.subgraph.vega.api.crawler.IWebCrawlerFactory;
import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.http.requests.IHttpRequestEngineFactory;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.WorkspaceCloseEvent;
import com.subgraph.vega.api.model.WorkspaceOpenEvent;
import com.subgraph.vega.api.model.WorkspaceResetEvent;
import com.subgraph.vega.api.scanner.IProxyScan;
import com.subgraph.vega.api.scanner.IScan;
import com.subgraph.vega.api.scanner.IScanner;
import com.subgraph.vega.api.scanner.modules.IScannerModuleRegistry;
import com.subgraph.vega.impl.scanner.ProxyScan;
import com.subgraph.vega.impl.scanner.Scan;
import org.apache.http.client.CookieStore;

public class Scanner
implements IScanner {
    private IModel model;
    private IWebCrawlerFactory crawlerFactory;
    private IHttpRequestEngineFactory requestEngineFactory;
    private IScannerModuleRegistry moduleRegistry;
    private IWorkspace currentWorkspace;
    private IContentAnalyzerFactory contentAnalyzerFactory;

    protected void activate() {
        this.currentWorkspace = this.model.addWorkspaceListener(new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof WorkspaceOpenEvent) {
                    Scanner.this.handleWorkspaceOpen((WorkspaceOpenEvent)iEvent);
                } else if (iEvent instanceof WorkspaceCloseEvent) {
                    Scanner.this.handleWorkspaceClose((WorkspaceCloseEvent)iEvent);
                } else if (iEvent instanceof WorkspaceResetEvent) {
                    Scanner.this.handleWorkspaceReset((WorkspaceResetEvent)iEvent);
                }
            }
        });
    }

    protected void deactivate() {
    }

    private void handleWorkspaceOpen(WorkspaceOpenEvent workspaceOpenEvent) {
        this.currentWorkspace = workspaceOpenEvent.getWorkspace();
    }

    private void handleWorkspaceReset(WorkspaceResetEvent workspaceResetEvent) {
        this.currentWorkspace = workspaceResetEvent.getWorkspace();
    }

    private void handleWorkspaceClose(WorkspaceCloseEvent workspaceCloseEvent) {
        this.currentWorkspace = null;
    }

    public IScan createScan() {
        return Scan.createScan(this, this.currentWorkspace);
    }

    public IProxyScan createProxyScan(IWorkspace iWorkspace, CookieStore cookieStore) {
        return new ProxyScan(iWorkspace, cookieStore, this);
    }

    public void runDomTests() {
        this.moduleRegistry.runDomTests();
    }

    protected void setCrawlerFactory(IWebCrawlerFactory iWebCrawlerFactory) {
        this.crawlerFactory = iWebCrawlerFactory;
    }

    protected void unsetCrawlerFactory(IWebCrawlerFactory iWebCrawlerFactory) {
        this.crawlerFactory = null;
    }

    protected void setRequestEngineFactory(IHttpRequestEngineFactory iHttpRequestEngineFactory) {
        this.requestEngineFactory = iHttpRequestEngineFactory;
    }

    protected void unsetRequestEngineFactory(IHttpRequestEngineFactory iHttpRequestEngineFactory) {
        this.requestEngineFactory = null;
    }

    protected void setModuleRegistry(IScannerModuleRegistry iScannerModuleRegistry) {
        this.moduleRegistry = iScannerModuleRegistry;
    }

    protected void unsetModuleRegistry(IScannerModuleRegistry iScannerModuleRegistry) {
        this.moduleRegistry = null;
    }

    protected void setModel(IModel iModel) {
        this.model = iModel;
    }

    protected void unsetModel(IModel iModel) {
        this.model = null;
    }

    protected void setContentAnalyzerFactory(IContentAnalyzerFactory iContentAnalyzerFactory) {
        this.contentAnalyzerFactory = iContentAnalyzerFactory;
    }

    protected void unsetContentAnalyzerFactory(IContentAnalyzerFactory iContentAnalyzerFactory) {
        this.contentAnalyzerFactory = null;
    }

    public IWebCrawlerFactory getWebCrawlerFactory() {
        return this.crawlerFactory;
    }

    public IHttpRequestEngineFactory getHttpRequestEngineFactory() {
        return this.requestEngineFactory;
    }

    public IScannerModuleRegistry getScannerModuleRegistry() {
        return this.moduleRegistry;
    }

    public IModel getModel() {
        return this.model;
    }

    public IContentAnalyzerFactory getContentAnalyzerFactory() {
        return this.contentAnalyzerFactory;
    }
}

