/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.requests;

import com.subgraph.vega.api.html.IHTMLParser;
import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.http.requests.IHttpRequestEngineConfig;
import com.subgraph.vega.api.http.requests.IHttpRequestTask;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.http.requests.IHttpResponseCookie;
import com.subgraph.vega.api.http.requests.IHttpResponseProcessor;
import com.subgraph.vega.api.http.requests.RequestEngineException;
import com.subgraph.vega.api.model.requests.IRequestOrigin;
import com.subgraph.vega.internal.http.requests.EngineHttpResponse;
import com.subgraph.vega.internal.http.requests.HttpRequestEngine;
import com.subgraph.vega.internal.http.requests.HttpResponseCookie;
import com.subgraph.vega.internal.http.requests.RateLimiter;
import com.subgraph.vega.internal.http.requests.RepeatableStreamingEntity;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.protocol.HttpContext;

class HttpRequestTask
implements IHttpRequestTask,
Callable<IHttpResponse> {
    private static final Logger logger = Logger.getLogger("request-engine");
    private Future<IHttpResponse> future;
    private final HttpRequestEngine requestEngine;
    private final HttpClient client;
    private final RateLimiter rateLimit;
    private final HttpUriRequest request;
    private final IRequestOrigin requestOrigin;
    private final HttpContext context;
    private final IHttpRequestEngineConfig config;
    private final IHTMLParser htmlParser;
    private Date timeCompleted;

    public HttpRequestTask(HttpRequestEngine httpRequestEngine, HttpClient httpClient, RateLimiter rateLimiter, HttpUriRequest httpUriRequest, IRequestOrigin iRequestOrigin, HttpContext httpContext, IHttpRequestEngineConfig iHttpRequestEngineConfig, IHTMLParser iHTMLParser) {
        this.requestEngine = httpRequestEngine;
        this.client = httpClient;
        this.rateLimit = rateLimiter;
        this.request = httpUriRequest;
        this.requestOrigin = iRequestOrigin;
        this.context = httpContext;
        this.config = iHttpRequestEngineConfig;
        this.htmlParser = iHTMLParser;
    }

    public void setFuture(Future<IHttpResponse> future) {
        this.future = future;
    }

    public IHttpRequestEngine getRequestEngine() {
        return this.requestEngine;
    }

    public void abort() {
        this.request.abort();
    }

    public HttpUriRequest getRequest() {
        return this.request;
    }

    public IHttpResponse get(boolean bl) throws RequestEngineException {
        try {
            IHttpResponse iHttpResponse = this.future.get();
            if (bl) {
                iHttpResponse.lockResponseEntity();
            }
            return iHttpResponse;
        }
        catch (InterruptedException interruptedException) {
            logger.info("Request " + this.request.getURI() + " was interrupted before completion");
        }
        catch (ExecutionException executionException) {
            throw this.translateException(this.request, executionException.getCause());
        }
        return null;
    }

    public boolean isComplete() {
        return this.future.isDone();
    }

    public synchronized Date getTimeCompleted() {
        return this.timeCompleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IHttpResponse call() throws Exception {
        HttpResponse httpResponse;
        if (this.config.getForceIdentityEncoding()) {
            this.request.setHeader("Content-Encoding", "identity");
        }
        if (this.rateLimit != null) {
            this.rateLimit.maybeDelayRequest();
        }
        this.requestEngine.addRequestInProgress(this);
        Date date = new Date();
        try {
            httpResponse = this.client.execute(this.request, this.context);
        }
        catch (Throwable throwable) {
            long l = this.getElapsedTimeFromContext(this.context);
            if (l == -1L) {
                l = new Date().getTime() - date.getTime();
            }
            HttpRequestTask httpRequestTask = this;
            synchronized (httpRequestTask) {
                this.timeCompleted = new Date();
            }
            this.requestEngine.removeRequestInProgress(this);
            throw throwable;
        }
        long l = this.getElapsedTimeFromContext(this.context);
        if (l == -1L) {
            l = new Date().getTime() - date.getTime();
        }
        HttpRequestTask httpRequestTask = this;
        synchronized (httpRequestTask) {
            this.timeCompleted = new Date();
        }
        this.requestEngine.removeRequestInProgress(this);
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            if (this.config.getMaximumResponseKilobytes() > 0 && httpEntity.getContentLength() > (long)(this.config.getMaximumResponseKilobytes() * 1024)) {
                logger.warning("Aborting request " + this.request.getURI().toString() + " because response length " + httpEntity.getContentLength() + " exceeds maximum length of " + this.config.getMaximumResponseKilobytes() + " kb.");
                this.request.abort();
                httpResponse.setEntity(this.createEmptyEntity());
            }
            httpRequestTask = this.processEntity(httpResponse, httpEntity);
            httpResponse.setEntity((HttpEntity)httpRequestTask);
        }
        httpRequestTask = (HttpHost)this.context.getAttribute("http.target_host");
        HttpRequest httpRequest = (HttpRequest)this.context.getAttribute("vega.sent-request");
        List<Cookie> list = this.requestEngine.getCookiesForRequest((HttpHost)httpRequestTask, httpRequest);
        List<IHttpResponseCookie> list2 = this.extractResponseCookies(httpResponse, this.context);
        EngineHttpResponse engineHttpResponse = new EngineHttpResponse(this.request.getURI(), (HttpHost)httpRequestTask, (HttpRequest)(httpRequest == null ? this.request : httpRequest), list, list2, this.requestOrigin, httpResponse, l, this.htmlParser);
        for (IHttpResponseProcessor iHttpResponseProcessor : this.config.getResponseProcessors()) {
            iHttpResponseProcessor.processResponse(engineHttpResponse.getOriginalRequest(), (IHttpResponse)engineHttpResponse, this.context);
        }
        return engineHttpResponse;
    }

    private List<IHttpResponseCookie> extractResponseCookies(HttpResponse httpResponse, HttpContext httpContext) {
        CookieSpec cookieSpec = (CookieSpec)httpContext.getAttribute("http.cookie-spec");
        CookieOrigin cookieOrigin = (CookieOrigin)httpContext.getAttribute("http.cookie-origin");
        HeaderIterator headerIterator = httpResponse.headerIterator("Set-Cookie");
        if (cookieOrigin == null || cookieSpec == null || !headerIterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<IHttpResponseCookie> arrayList = new ArrayList<IHttpResponseCookie>();
        while (headerIterator.hasNext()) {
            Header header = headerIterator.nextHeader();
            try {
                for (Cookie cookie : cookieSpec.parse(header, cookieOrigin)) {
                    if (!(cookie instanceof ClientCookie)) continue;
                    arrayList.add(new HttpResponseCookie(header.getValue(), (ClientCookie)cookie));
                }
            }
            catch (MalformedCookieException malformedCookieException) {
                logger.warning("Malformed Set-Cookie header received: " + header.getValue());
            }
        }
        return arrayList;
    }

    private long getElapsedTimeFromContext(HttpContext httpContext) {
        Date date = (Date)httpContext.getAttribute("vega.request_time");
        Date date2 = (Date)httpContext.getAttribute("vega.response_time");
        if (date == null || date2 == null) {
            return -1L;
        }
        return date2.getTime() - date.getTime();
    }

    private HttpEntity processEntity(HttpResponse httpResponse, HttpEntity httpEntity) throws IOException {
        if (httpEntity == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = httpEntity.getContent();
        }
        catch (EOFException eOFException) {
            httpResponse.setHeader("Content-Length", "0");
            inputStream = null;
        }
        if (inputStream == null) {
            return this.createEmptyEntity();
        }
        String string = httpEntity.getContentType() == null ? null : httpEntity.getContentType().getValue();
        String string2 = httpEntity.getContentEncoding() == null ? null : httpEntity.getContentEncoding().getValue();
        RepeatableStreamingEntity repeatableStreamingEntity = new RepeatableStreamingEntity(inputStream, httpEntity.getContentLength(), false, httpEntity.isChunked(), string, string2);
        if (this.config.getMaximumResponseKilobytes() > 0) {
            repeatableStreamingEntity.setMaximumInputKilobytes(this.config.getMaximumResponseKilobytes());
        }
        return repeatableStreamingEntity;
    }

    private HttpEntity createEmptyEntity() {
        return new ByteArrayEntity(new byte[0]);
    }

    private RequestEngineException translateException(HttpUriRequest httpUriRequest, Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        if (throwable instanceof EOFException) {
            stringBuilder.append("Unexpected EOF received");
        } else if (throwable instanceof IOException) {
            stringBuilder.append("Network problem");
        } else if (throwable instanceof HttpException) {
            stringBuilder.append("Protocol problem");
        } else {
            stringBuilder.append("Unknown problem");
        }
        stringBuilder.append(" while retrieving URI ");
        stringBuilder.append(httpUriRequest.getURI().toString());
        if (throwable.getMessage() != null) {
            stringBuilder.append(" [");
            stringBuilder.append(throwable.getMessage());
            stringBuilder.append("]");
        }
        return new RequestEngineException(stringBuilder.toString(), throwable);
    }
}

