/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.requests;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecRegistry;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.params.HttpParams;

public class CookieMatcher {
    private final AbstractHttpClient client;

    CookieMatcher(AbstractHttpClient abstractHttpClient) {
        this.client = abstractHttpClient;
    }

    public List<Cookie> getCookiesForRequest(HttpHost httpHost, HttpRequest httpRequest) {
        CookieSpecRegistry cookieSpecRegistry = this.client.getCookieSpecs();
        String string = HttpClientParams.getCookiePolicy((HttpParams)httpRequest.getParams());
        CookieOrigin cookieOrigin = this.getCookieOrigin(httpHost, httpRequest);
        CookieSpec cookieSpec = cookieSpecRegistry.getCookieSpec(string, httpRequest.getParams());
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        Date date = new Date();
        for (Cookie cookie : this.client.getCookieStore().getCookies()) {
            if (!cookieSpec.match(cookie, cookieOrigin) || cookie.isExpired(date)) continue;
            arrayList.add(cookie);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private CookieOrigin getCookieOrigin(HttpHost httpHost, HttpRequest httpRequest) {
        int n = this.getPortForHost(httpHost);
        String string = this.getPathForRequest(httpRequest);
        return new CookieOrigin(httpHost.getHostName(), n, string, this.isSecureScheme(httpHost));
    }

    private int getPortForHost(HttpHost httpHost) {
        if (httpHost.getPort() > 0) {
            return httpHost.getPort();
        }
        String string = httpHost.getSchemeName();
        if ("http".equalsIgnoreCase(string)) {
            return 80;
        }
        if ("https".equalsIgnoreCase(string)) {
            return 443;
        }
        return 0;
    }

    private boolean isSecureScheme(HttpHost httpHost) {
        return "https".equalsIgnoreCase(httpHost.getSchemeName());
    }

    private String getPathForRequest(HttpRequest httpRequest) {
        if (httpRequest instanceof HttpUriRequest) {
            URI uRI = ((HttpUriRequest)httpRequest).getURI();
            return uRI.getPath();
        }
        return httpRequest.getRequestLine().getUri();
    }
}

