/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.web;

import com.db4o.ObjectContainer;
import com.db4o.activation.ActivationPurpose;
import com.subgraph.vega.api.events.EventListenerManager;
import com.subgraph.vega.api.model.web.IWebEntity;
import com.subgraph.vega.api.model.web.IWebModelVisitor;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.model.web.IWebResponse;
import com.subgraph.vega.internal.model.web.WebEntity;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;

public class WebResponse
extends WebEntity
implements IWebResponse {
    private final IWebPath parentPath;
    private final List<NameValuePair> parameters;
    private final String mimeType;
    private transient String cachedQueryString;

    WebResponse(EventListenerManager eventListenerManager, ObjectContainer objectContainer, IWebPath iWebPath, List<NameValuePair> list, String string) {
        super(eventListenerManager, objectContainer);
        this.parentPath = iWebPath;
        this.mimeType = string;
        this.parameters = list;
        this.setVisited(true);
    }

    public List<NameValuePair> getRequestParameters() {
        this.activate(ActivationPurpose.READ);
        return Collections.unmodifiableList(this.parameters);
    }

    public String getMimeType() {
        this.activate(ActivationPurpose.READ);
        return this.mimeType;
    }

    public IWebEntity getParent() {
        this.activate(ActivationPurpose.READ);
        return this.parentPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getQueryString() {
        this.activate(ActivationPurpose.READ);
        WebResponse webResponse = this;
        synchronized (webResponse) {
            if (this.cachedQueryString == null) {
                this.cachedQueryString = this.createQueryString();
            }
            return this.cachedQueryString;
        }
    }

    private String createQueryString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (NameValuePair nameValuePair : this.parameters) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(nameValuePair.getName());
            if (nameValuePair.getValue() == null) continue;
            stringBuilder.append("=");
            stringBuilder.append(nameValuePair.getValue());
        }
        return stringBuilder.toString();
    }

    public IWebPath getPathEntity() {
        this.activate(ActivationPurpose.READ);
        return this.parentPath;
    }

    public void accept(IWebModelVisitor iWebModelVisitor) {
        iWebModelVisitor.visit((IWebResponse)this);
    }

    public HttpHost getHttpHost() {
        return this.parentPath.getHttpHost();
    }
}

