/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model;

import com.subgraph.vega.api.model.IWorkspaceEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Logger;

public class WorkspaceEntry
implements IWorkspaceEntry {
    private static final Logger logger = Logger.getLogger("model");
    private final String name;
    private final int index;
    private final boolean autostart;
    private final File path;

    static WorkspaceEntry createFromPath(File file) {
        if (!Character.isDigit(file.getName().charAt(0))) {
            return null;
        }
        int n = WorkspaceEntry.pathToIndex(file);
        if (n == -1) {
            return null;
        }
        String string = WorkspaceEntry.pathToWorkspaceName(file);
        if (string == null) {
            return null;
        }
        boolean bl = WorkspaceEntry.pathToAutostartFlag(file);
        return new WorkspaceEntry(string, n, bl, file);
    }

    static int pathToIndex(File file) {
        int n;
        block3: {
            String string = file.getName();
            try {
                n = Integer.parseInt(string);
                if (n >= 0 && n <= 1000) break block3;
                logger.warning("Could not read workspace because path is incorrectly formatted " + file);
                return -1;
            }
            catch (NumberFormatException numberFormatException) {
                logger.warning("Could not read workspace because path is incorrectly formatted " + file);
                return -1;
            }
        }
        return n;
    }

    /*
     * Loose catch block
     */
    static String pathToWorkspaceName(File file) {
        String string;
        BufferedReader bufferedReader;
        File file2;
        block14: {
            file2 = new File(file, ".name");
            bufferedReader = WorkspaceEntry.openNameFileReader(file2);
            if (bufferedReader == null) {
                return null;
            }
            string = bufferedReader.readLine();
            if (string != null && !string.isEmpty()) break block14;
            logger.warning("Could not read workpace because name file is empty " + file2);
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            return null;
        }
        String string2 = string;
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return string2;
        catch (IOException iOException) {
            try {
                logger.warning("Could not read workspace, I/O error reading name file " + file2);
            }
            catch (Throwable throwable) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException3) {}
            return null;
        }
    }

    static boolean pathToAutostartFlag(File file) {
        File file2 = new File(file, ".autostart");
        return file2.exists();
    }

    static BufferedReader openNameFileReader(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            return new BufferedReader(new InputStreamReader(fileInputStream));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    WorkspaceEntry(String string, int n, boolean bl, File file) {
        this.name = string;
        this.index = n;
        this.autostart = bl;
        this.path = file;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public File getPath() {
        return this.path;
    }

    public boolean isAutostart() {
        return this.autostart;
    }
}

