/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.util.dialogs;

import com.subgraph.vega.internal.ui.util.PopupConfigDialog;
import com.subgraph.vega.internal.ui.util.TitleAreaConfigDialog;
import com.subgraph.vega.ui.util.Activator;
import com.subgraph.vega.ui.util.dialogs.IConfigDialogContent;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConfigDialogCreator {
    public static Window createDialog(ExecutionEvent executionEvent, IConfigDialogContent iConfigDialogContent) {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)executionEvent);
        return ConfigDialogCreator.createDialog(shell, ConfigDialogCreator.eventToPoint(executionEvent), iConfigDialogContent);
    }

    public static Window createDialog(ToolItem toolItem, IConfigDialogContent iConfigDialogContent) {
        Shell shell = toolItem.getParent().getShell();
        return ConfigDialogCreator.createDialog(shell, ConfigDialogCreator.toolItemToPoint(toolItem), iConfigDialogContent);
    }

    public static Window createDialog(Shell shell, Point point, IConfigDialogContent iConfigDialogContent) {
        boolean bl = Activator.getDefault().getPreferenceStore().getBoolean("ConfigPopup");
        if (bl) {
            return new PopupConfigDialog(shell, point, iConfigDialogContent);
        }
        return new TitleAreaConfigDialog(shell, iConfigDialogContent);
    }

    private static Point eventToPoint(ExecutionEvent executionEvent) {
        if (executionEvent.getTrigger() instanceof Event) {
            Event event = (Event)executionEvent.getTrigger();
            if (event.widget instanceof ToolItem) {
                return ConfigDialogCreator.toolItemToPoint((ToolItem)event.widget);
            }
        }
        return new Point(100, 100);
    }

    private static Point toolItemToPoint(ToolItem toolItem) {
        int n = toolItem.getBounds().x;
        int n2 = toolItem.getBounds().y + toolItem.getBounds().height;
        return toolItem.getDisplay().map((Control)toolItem.getParent(), null, n, n2);
    }
}

