#!/usr/bin/env python3

HEXA_CONSTS = {
"empty_md5": 
    b"\xd4\x1d\x8c\xd9\x8f\x00\xb2\x04\xe9\x80\x09\x98\xec\xf8\x42\x7e",

"empty_sha1": 
    b"\xda\x39\xa3\xee\x5e\x6b\x4b\x0d\x32\x55\xbf\xef\x95\x60\x18\x90"
    b"\xaf\xd8\x07\x09",

"empty_sha224":
    b"\xd1\x4a\x02\x8c\x2a\x3a\x2b\xc9\x47\x61\x02\xbb\x28\x82\x34\xc4"
    b"\x15\xa2\xb0\x1f\x82\x8e\xa6\x2a\xc5\xb3\xe4\x2f",

"empty_sha224":
    b"\xe3\xb0\xc4\x42\x98\xfc\x1c\x14\x9a\xfb\xf4\xc8\x99\x6f\xb9\x24"
    b"\x27\xae\x41\xe4\x64\x9b\x93\x4c\xa4\x95\x99\x1b\x78\x52\xb8\x55",

"empty_sha384":
    b"\x38\xb0\x60\xa7\x51\xac\x96\x38\x4c\xd9\x32\x7e\xb1\xb1\xe3\x6a"
    b"\x21\xfd\xb7\x11\x14\xbe\x07\x43\x4c\x0c\xc7\xbf\x63\xf6\xe1\xda"
    b"\x27\x4e\xde\xbf\xe7\x6f\x65\xfb\xd5\x1a\xd2\xf1\x48\x98\xb9\x5b",

"empty_sha512":
    b"\xcf\x83\xe1\x35\x7e\xef\xb8\xbd\xf1\x54\x28\x50\xd6\x6d\x80\x07"
    b"\xd6\x20\xe4\x05\x0b\x57\x15\xdc\x83\xf4\xa9\x21\xd3\x6c\xe9\xce"
    b"\x47\xd0\xd1\x3c\x5d\x85\xf2\xb0\xff\x83\x18\xd2\x87\x7e\xec\x2f"
    b"\x63\xb9\x31\xbd\x47\x41\x7a\x81\xa5\x38\x32\x7a\xf9\x27\xda\x3e",

"aes_sbox":
    b"\x63\x7C\x77\x7B\xF2\x6B\x6F\xC5\x30\x01\x67\x2B\xFE\xD7\xAB\x76"
    b"\xCA\x82\xC9\x7D\xFA\x59\x47\xF0\xAD\xD4\xA2\xAF\x9C\xA4\x72\xC0"
    b"\xB7\xFD\x93\x26\x36\x3F\xF7\xCC\x34\xA5\xE5\xF1\x71\xD8\x31\x15"
    b"\x04\xC7\x23\xC3\x18\x96\x05\x9A\x07\x12\x80\xE2\xEB\x27\xB2\x75"
    b"\x09\x83\x2C\x1A\x1B\x6E\x5A\xA0\x52\x3B\xD6\xB3\x29\xE3\x2F\x84"
    b"\x53\xD1\x00\xED\x20\xFC\xB1\x5B\x6A\xCB\xBE\x39\x4A\x4C\x58\xCF"
    b"\xD0\xEF\xAA\xFB\x43\x4D\x33\x85\x45\xF9\x02\x7F\x50\x3C\x9F\xA8"
    b"\x51\xA3\x40\x8F\x92\x9D\x38\xF5\xBC\xB6\xDA\x21\x10\xFF\xF3\xD2"
    b"\xCD\x0C\x13\xEC\x5F\x97\x44\x17\xC4\xA7\x7E\x3D\x64\x5D\x19\x73"
    b"\x60\x81\x4F\xDC\x22\x2A\x90\x88\x46\xEE\xB8\x14\xDE\x5E\x0B\xDB"
    b"\xE0\x32\x3A\x0A\x49\x06\x24\x5C\xC2\xD3\xAC\x62\x91\x95\xE4\x79"
    b"\xE7\xC8\x37\x6D\x8D\xD5\x4E\xA9\x6C\x56\xF4\xEA\x65\x7A\xAE\x08"
    b"\xBA\x78\x25\x2E\x1C\xA6\xB4\xC6\xE8\xDD\x74\x1F\x4B\xBD\x8B\x8A"
    b"\x70\x3E\xB5\x66\x48\x03\xF6\x0E\x61\x35\x57\xB9\x86\xC1\x1D\x9E"
    b"\xE1\xF8\x98\x11\x69\xD9\x8E\x94\x9B\x1E\x87\xE9\xCE\x55\x28\xDF"
    b"\x8C\xA1\x89\x0D\xBF\xE6\x42\x68\x41\x99\x2D\x0F\xB0\x54\xBB\x16",

"aes_rbox":
    b"\x52\x09\x6A\xD5\x30\x36\xA5\x38\xBF\x40\xA3\x9E\x81\xF3\xD7\xFB"
    b"\x7C\xE3\x39\x82\x9B\x2F\xFF\x87\x34\x8E\x43\x44\xC4\xDE\xE9\xCB"
    b"\x54\x7B\x94\x32\xA6\xC2\x23\x3D\xEE\x4C\x95\x0B\x42\xFA\xC3\x4E"
    b"\x08\x2E\xA1\x66\x28\xD9\x24\xB2\x76\x5B\xA2\x49\x6D\x8B\xD1\x25"
    b"\x72\xF8\xF6\x64\x86\x68\x98\x16\xD4\xA4\x5C\xCC\x5D\x65\xB6\x92"
    b"\x6C\x70\x48\x50\xFD\xED\xB9\xDA\x5E\x15\x46\x57\xA7\x8D\x9D\x84"
    b"\x90\xD8\xAB\x00\x8C\xBC\xD3\x0A\xF7\xE4\x58\x05\xB8\xB3\x45\x06"
    b"\xD0\x2C\x1E\x8F\xCA\x3F\x0F\x02\xC1\xAF\xBD\x03\x01\x13\x8A\x6B"
    b"\x3A\x91\x11\x41\x4F\x67\xDC\xEA\x97\xF2\xCF\xCE\xF0\xB4\xE6\x73"
    b"\x96\xAC\x74\x22\xE7\xAD\x35\x85\xE2\xF9\x37\xE8\x1C\x75\xDF\x6E"
    b"\x47\xF1\x1A\x71\x1D\x29\xC5\x89\x6F\xB7\x62\x0E\xAA\x18\xBE\x1B"
    b"\xFC\x56\x3E\x4B\xC6\xD2\x79\x20\x9A\xDB\xC0\xFE\x78\xCD\x5A\xF4"
    b"\x1F\xDD\xA8\x33\x88\x07\xC7\x31\xB1\x12\x10\x59\x27\x80\xEC\x5F"
    b"\x60\x51\x7F\xA9\x19\xB5\x4A\x0D\x2D\xE5\x7A\x9F\x93\xC9\x9C\xEF"
    b"\xA0\xE0\x3B\x4D\xAE\x2A\xF5\xB0\xC8\xEB\xBB\x3C\x83\x53\x99\x61"
    b"\x17\x2B\x04\x7E\xBA\x77\xD6\x26\xE1\x69\x14\x63\x55\x21\x0C\x7D",

"des_sbox1":
    b"\x0e\x04\x0d\x01\x02\x0f\x0b\x08\x03\x0a\x06\x0c\x05\x09\x00\x07"
    b"\x00\x0f\x07\x04\x0e\x02\x0d\x01\x0a\x06\x0c\x0b\x09\x05\x03\x08"
    b"\x04\x01\x0e\x08\x0d\x06\x02\x0b\x0f\x0c\x09\x07\x03\x0a\x05\x00"
    b"\x0f\x0c\x08\x02\x04\x09\x01\x07\x05\x0b\x03\x0e\x0a\x00\x06\x0d",

"des_sbox2":
    b"\x0f\x01\x08\x0e\x06\x0b\x03\x04\x09\x07\x02\x0d\x0c\x00\x05\x0a"
    b"\x03\x0d\x04\x07\x0f\x02\x08\x0e\x0c\x00\x01\x0a\x06\x09\x0b\x05"
    b"\x00\x0e\x07\x0b\x0a\x04\x0d\x01\x05\x08\x0c\x06\x09\x03\x02\x0f"
    b"\x0d\x08\x0a\x01\x03\x0f\x04\x02\x0b\x06\x07\x0c\x00\x05\x0e\x09",

"des_sbox3":
    b"\x0a\x00\x09\x0e\x06\x03\x0f\x05\x01\x0d\x0c\x07\x0b\x04\x02\x08"
    b"\x0d\x07\x00\x09\x03\x04\x06\x0a\x02\x08\x05\x0e\x0c\x0b\x0f\x01"
    b"\x0d\x06\x04\x09\x08\x0f\x03\x00\x0b\x01\x02\x0c\x05\x0a\x0e\x07"
    b"\x01\x0a\x0d\x00\x06\x09\x08\x07\x04\x0f\x0e\x03\x0b\x05\x02\x0c",

"des_sbox4":
    b"\x07\x0d\x0e\x03\x00\x06\x09\x0a\x01\x02\x08\x05\x0b\x0c\x04\x0f"
    b"\x0d\x08\x0b\x05\x06\x0f\x00\x03\x04\x07\x02\x0c\x01\x0a\x0e\x09"
    b"\x0a\x06\x09\x00\x0c\x0b\x07\x0d\x0f\x01\x03\x0e\x05\x02\x08\x04"
    b"\x03\x0f\x00\x06\x0a\x01\x0d\x08\x09\x04\x05\x0b\x0c\x07\x02\x0e",

"des_sbox5":
    b"\x02\x0c\x04\x01\x07\x0a\x0b\x06\x08\x05\x03\x0f\x0d\x00\x0e\x09"
    b"\x0e\x0b\x02\x0c\x04\x07\x0d\x01\x05\x00\x0f\x0a\x03\x09\x08\x06"
    b"\x04\x02\x01\x0b\x0a\x0d\x07\x08\x0f\x09\x0c\x05\x06\x03\x00\x0e"
    b"\x0b\x08\x0c\x07\x01\x0e\x02\x0d\x06\x0f\x00\x09\x0a\x04\x05\x03",

"des_sbox6":
    b"\x0c\x01\x0a\x0f\x09\x02\x06\x08\x00\x0d\x03\x04\x0e\x07\x05\x0b"
    b"\x0a\x0f\x04\x02\x07\x0c\x09\x05\x06\x01\x0d\x0e\x00\x0b\x03\x08"
    b"\x09\x0e\x0f\x05\x02\x08\x0c\x03\x07\x00\x04\x0a\x01\x0d\x0b\x06"
    b"\x04\x03\x02\x0c\x09\x05\x0f\x0a\x0b\x0e\x01\x07\x06\x00\x08\x0d",

"des_sbox7":
    b"\x04\x0b\x02\x0e\x0f\x00\x08\x0d\x03\x0c\x09\x07\x05\x0a\x06\x01"
    b"\x0d\x00\x0b\x07\x04\x09\x01\x0a\x0e\x03\x05\x0c\x02\x0f\x08\x06"
    b"\x01\x04\x0b\x0d\x0c\x03\x07\x0e\x0a\x0f\x06\x08\x00\x05\x09\x02"
    b"\x06\x0b\x0d\x08\x01\x04\x0a\x07\x09\x05\x00\x0f\x0e\x02\x03\x0c",

"des_sbox8":
    b"\x0d\x02\x08\x04\x06\x0f\x0b\x01\x0a\x09\x03\x0e\x05\x00\x0c\x07"
    b"\x01\x0f\x0d\x08\x0a\x03\x07\x04\x0c\x05\x06\x0b\x00\x0e\x09\x02"
    b"\x07\x0b\x04\x01\x09\x0c\x0e\x02\x00\x06\x0a\x0d\x0f\x03\x05\x08"
    b"\x02\x01\x0e\x07\x04\x0a\x08\x0d\x0f\x0c\x09\x00\x03\x05\x06\x0b",

"blowfish_p_perm":
    b"\x88\x6a\x3f\x24\xd3\x08\xa3\x85\x2e\x8a\x19\x13\x44\x73\x70\x03"
    b"\x22\x38\x09\xa4\xd0\x31\x9f\x29\x98\xfa\x2e\x08\x89\x6c\x4e\xec"
    b"\xe6\x21\x28\x45\x77\x13\xd0\x38\xcf\x66\x54\xbe\x6c\x0c\xe9\x34"
    b"\xb7\x29\xac\xc0\xdd\x50\x7c\xc9\xb5\xd5\x84\x3f\x17\x09\x47\xb5"
    b"\xd9\xd5\x16\x92\x1b\xfb\x79\x89",

"blowfish_s_perm":
    b"\xa6\x0b\x31\xd1\xac\xb5\xdf\x98\xdb\x72\xfd\x2f\xb7\xdf\x1a\xd0"
    b"\xed\xaf\xe1\xb8\x96\x7e\x26\x6a\x45\x90\x7c\xba\x99\x7f\x2c\xf1"
    b"\x47\x99\xa1\x24\xf7\x6c\x91\xb3\xe2\xf2\x01\x08\x16\xfc\x8e\x85"
    b"\xd8\x20\x69\x63\x69\x4e\x57\x71\xa3\xfe\x58\xa4\x7e\x3d\x93\xf4"
    b"\x8f\x74\x95\x0d\x58\xb6\x8e\x72\x58\xcd\x8b\x71\xee\x4a\x15\x82"
    b"\x1d\xa4\x54\x7b\xb5\x59\x5a\xc2\x39\xd5\x30\x9c\x13\x60\xf2\x2a"
    b"\x23\xb0\xd1\xc5\xf0\x85\x60\x28\x18\x79\x41\xca\xef\x38\xdb\xb8"
    b"\xb0\xdc\x79\x8e\x0e\x18\x3a\x60\x8b\x0e\x9e\x6c\x3e\x8a\x1e\xb0"
    b"\xc1\x77\x15\xd7\x27\x4b\x31\xbd\xda\x2f\xaf\x78\x60\x5c\x60\x55"
    b"\xf3\x25\x55\xe6\x94\xab\x55\xaa\x62\x98\x48\x57\x40\x14\xe8\x63"
    b"\x6a\x39\xca\x55\xb6\x10\xab\x2a\x34\x5c\xcc\xb4\xce\xe8\x41\x11"
    b"\xaf\x86\x54\xa1\x93\xe9\x72\x7c\x11\x14\xee\xb3\x2a\xbc\x6f\x63"
    b"\x5d\xc5\xa9\x2b\xf6\x31\x18\x74\x16\x3e\x5c\xce\x1e\x93\x87\x9b"
    b"\x33\xba\xd6\xaf\x5c\xcf\x24\x6c\x81\x53\x32\x7a\x77\x86\x95\x28"
    b"\x98\x48\x8f\x3b\xaf\xb9\x4b\x6b\x1b\xe8\xbf\xc4\x93\x21\x28\x66"
    b"\xcc\x09\xd8\x61\x91\xa9\x21\xfb\x60\xac\x7c\x48\x32\x80\xec\x5d"
    b"\x5d\x5d\x84\xef\xb1\x75\x85\xe9\x02\x23\x26\xdc\x88\x1b\x65\xeb"
    b"\x81\x3e\x89\x23\xc5\xac\x96\xd3\xf3\x6f\x6d\x0f\x39\x42\xf4\x83"
    b"\x82\x44\x0b\x2e\x04\x20\x84\xa4\x4a\xf0\xc8\x69\x5e\x9b\x1f\x9e"
    b"\x42\x68\xc6\x21\x9a\x6c\xe9\xf6\x61\x9c\x0c\x67\xf0\x88\xd3\xab"
    b"\xd2\xa0\x51\x6a\x68\x2f\x54\xd8\x28\xa7\x0f\x96\xa3\x33\x51\xab"
    b"\x6c\x0b\xef\x6e\xe4\x3b\x7a\x13\x50\xf0\x3b\xba\x98\x2a\xfb\x7e"
    b"\x1d\x65\xf1\xa1\x76\x01\xaf\x39\x3e\x59\xca\x66\x88\x0e\x43\x82"
    b"\x19\x86\xee\x8c\xb4\x9f\x6f\x45\xc3\xa5\x84\x7d\xbe\x5e\x8b\x3b"
    b"\xd8\x75\x6f\xe0\x73\x20\xc1\x85\x9f\x44\x1a\x40\xa6\x6a\xc1\x56"
    b"\x62\xaa\xd3\x4e\x06\x77\x3f\x36\x72\xdf\xfe\x1b\x3d\x02\x9b\x42"
    b"\x24\xd7\xd0\x37\x48\x12\x0a\xd0\xd3\xea\x0f\xdb\x9b\xc0\xf1\x49"
    b"\xc9\x72\x53\x07\x7b\x1b\x99\x80\xd8\x79\xd4\x25\xf7\xde\xe8\xf6"
    b"\x1a\x50\xfe\xe3\x3b\x4c\x79\xb6\xbd\xe0\x6c\x97\xba\x06\xc0\x04"
    b"\xb6\x4f\xa9\xc1\xc4\x60\x9f\x40\xc2\x9e\x5c\x5e\x63\x24\x6a\x19"
    b"\xaf\x6f\xfb\x68\xb5\x53\x6c\x3e\xeb\xb2\x39\x13\x6f\xec\x52\x3b"
    b"\x1f\x51\xfc\x6d\x2c\x95\x30\x9b\x44\x45\x81\xcc\x09\xbd\x5e\xaf"
    b"\x04\xd0\xe3\xbe\xfd\x4a\x33\xde\x07\x28\x0f\x66\xb3\x4b\x2e\x19"
    b"\x57\xa8\xcb\xc0\x0f\x74\xc8\x45\x39\x5f\x0b\xd2\xdb\xfb\xd3\xb9"
    b"\xbd\xc0\x79\x55\x0a\x32\x60\x1a\xc6\x00\xa1\xd6\x79\x72\x2c\x40"
    b"\xfe\x25\x9f\x67\xcc\xa3\x1f\xfb\xf8\xe9\xa5\x8e\xf8\x22\x32\xdb"
    b"\xdf\x16\x75\x3c\x15\x6b\x61\xfd\xc8\x1e\x50\x2f\xab\x52\x05\xad"
    b"\xfa\xb5\x3d\x32\x60\x87\x23\xfd\x48\x7b\x31\x53\x82\xdf\x00\x3e"
    b"\xbb\x57\x5c\x9e\xa0\x8c\x6f\xca\x2e\x56\x87\x1a\xdb\x69\x17\xdf"
    b"\xf6\xa8\x42\xd5\xc3\xff\x7e\x28\xc6\x32\x67\xac\x73\x55\x4f\x8c"
    b"\xb0\x27\x5b\x69\xc8\x58\xca\xbb\x5d\xa3\xff\xe1\xa0\x11\xf0\xb8"
    b"\x98\x3d\xfa\x10\xb8\x83\x21\xfd\x6c\xb5\xfc\x4a\x5b\xd3\xd1\x2d"
    b"\x79\xe4\x53\x9a\x65\x45\xf8\xb6\xbc\x49\x8e\xd2\x90\x97\xfb\x4b"
    b"\xda\xf2\xdd\xe1\x33\x7e\xcb\xa4\x41\x13\xfb\x62\xe8\xc6\xe4\xce"
    b"\xda\xca\x20\xef\x01\x4c\x77\x36\xfe\x9e\x7e\xd0\xb4\x1f\xf1\x2b"
    b"\x4d\xda\xdb\x95\x98\x91\x90\xae\x71\x8e\xad\xea\xa0\xd5\x93\x6b"
    b"\xd0\xd1\x8e\xd0\xe0\x25\xc7\xaf\x2f\x5b\x3c\x8e\xb7\x94\x75\x8e"
    b"\xfb\xe2\xf6\x8f\x64\x2b\x12\xf2\x12\xb8\x88\x88\x1c\xf0\x0d\x90"
    b"\xa0\x5e\xad\x4f\x1c\xc3\x8f\x68\x91\xf1\xcf\xd1\xad\xc1\xa8\xb3"
    b"\x18\x22\x2f\x2f\x77\x17\x0e\xbe\xfe\x2d\x75\xea\xa1\x1f\x02\x8b"
    b"\x0f\xcc\xa0\xe5\xe8\x74\x6f\xb5\xd6\xf3\xac\x18\x99\xe2\x89\xce"
    b"\xe0\x4f\xa8\xb4\xb7\xe0\x13\xfd\x81\x3b\xc4\x7c\xd9\xa8\xad\xd2"
    b"\x66\xa2\x5f\x16\x05\x77\x95\x80\x14\x73\xcc\x93\x77\x14\x1a\x21"
    b"\x65\x20\xad\xe6\x86\xfa\xb5\x77\xf5\x42\x54\xc7\xcf\x35\x9d\xfb"
    b"\x0c\xaf\xcd\xeb\xa0\x89\x3e\x7b\xd3\x1b\x41\xd6\x49\x7e\x1e\xae"
    b"\x2d\x0e\x25\x00\x5e\xb3\x71\x20\xbb\x00\x68\x22\xaf\xe0\xb8\x57"
    b"\x9b\x36\x64\x24\x1e\xb9\x09\xf0\x1d\x91\x63\x55\xaa\xa6\xdf\x59"
    b"\x89\x43\xc1\x78\x7f\x53\x5a\xd9\xa2\x5b\x7d\x20\xc5\xb9\xe5\x02"
    b"\x76\x03\x26\x83\xa9\xcf\x95\x62\x68\x19\xc8\x11\x41\x4a\x73\x4e"
    b"\xca\x2d\x47\xb3\x4a\xa9\x14\x7b\x52\x00\x51\x1b\x15\x29\x53\x9a"
    b"\x3f\x57\x0f\xd6\xe4\xc6\x9b\xbc\x76\xa4\x60\x2b\x00\x74\xe6\x81"
    b"\xb5\x6f\xba\x08\x1f\xe9\x1b\x57\x6b\xec\x96\xf2\x15\xd9\x0d\x2a"
    b"\x21\x65\x63\xb6\xb6\xf9\xb9\xe7\x2e\x05\x34\xff\x64\x56\x85\xc5"
    b"\x5d\x2d\xb0\x53\xa1\x8f\x9f\xa9\x99\x47\xba\x08\x6a\x07\x85\x6e"
    b"\xe9\x70\x7a\x4b\x44\x29\xb3\xb5\x2e\x09\x75\xdb\x23\x26\x19\xc4"
    b"\xb0\xa6\x6e\xad\x7d\xdf\xa7\x49\xb8\x60\xee\x9c\x66\xb2\xed\x8f"
    b"\x71\x8c\xaa\xec\xff\x17\x9a\x69\x6c\x52\x64\x56\xe1\x9e\xb1\xc2"
    b"\xa5\x02\x36\x19\x29\x4c\x09\x75\x40\x13\x59\xa0\x3e\x3a\x18\xe4"
    b"\x9a\x98\x54\x3f\x65\x9d\x42\x5b\xd6\xe4\x8f\x6b\xd6\x3f\xf7\x99"
    b"\x07\x9c\xd2\xa1\xf5\x30\xe8\xef\xe6\x38\x2d\x4d\xc1\x5d\x25\xf0"
    b"\x86\x20\xdd\x4c\x26\xeb\x70\x84\xc6\xe9\x82\x63\x5e\xcc\x1e\x02"
    b"\x3f\x6b\x68\x09\xc9\xef\xba\x3e\x14\x18\x97\x3c\xa1\x70\x6a\x6b"
    b"\x84\x35\x7f\x68\x86\xe2\xa0\x52\x05\x53\x9c\xb7\x37\x07\x50\xaa"
    b"\x1c\x84\x07\x3e\x5c\xae\xde\x7f\xec\x44\x7d\x8e\xb8\xf2\x16\x57"
    b"\x37\xda\x3a\xb0\x0d\x0c\x50\xf0\x04\x1f\x1c\xf0\xff\xb3\x00\x02"
    b"\x1a\xf5\x0c\xae\xb2\x74\xb5\x3c\x58\x7a\x83\x25\xbd\x21\x09\xdc"
    b"\xf9\x13\x91\xd1\xf6\x2f\xa9\x7c\x73\x47\x32\x94\x01\x47\xf5\x22"
    b"\x81\xe5\xe5\x3a\xdc\xda\xc2\x37\x34\x76\xb5\xc8\xa7\xdd\xf3\x9a"
    b"\x46\x61\x44\xa9\x0e\x03\xd0\x0f\x3e\xc7\xc8\xec\x41\x1e\x75\xa4"
    b"\x99\xcd\x38\xe2\x2f\x0e\xea\x3b\xa1\xbb\x80\x32\x31\xb3\x3e\x18"
    b"\x38\x8b\x54\x4e\x08\xb9\x6d\x4f\x03\x0d\x42\x6f\xbf\x04\x0a\xf6"
    b"\x90\x12\xb8\x2c\x79\x7c\x97\x24\x72\xb0\x79\x56\xaf\x89\xaf\xbc"
    b"\x1f\x77\x9a\xde\x10\x08\x93\xd9\x12\xae\x8b\xb3\x2e\x3f\xcf\xdc"
    b"\x1f\x72\x12\x55\x24\x71\x6b\x2e\xe6\xdd\x1a\x50\x87\xcd\x84\x9f"
    b"\x18\x47\x58\x7a\x17\xda\x08\x74\xbc\x9a\x9f\xbc\x8c\x7d\x4b\xe9"
    b"\x3a\xec\x7a\xec\xfa\x1d\x85\xdb\x66\x43\x09\x63\xd2\xc3\x64\xc4"
    b"\x47\x18\x1c\xef\x08\xd9\x15\x32\x37\x3b\x43\xdd\x16\xba\xc2\x24"
    b"\x43\x4d\xa1\x12\x51\xc4\x65\x2a\x02\x00\x94\x50\xdd\xe4\x3a\x13"
    b"\x9e\xf8\xdf\x71\x55\x4e\x31\x10\xd6\x77\xac\x81\x9b\x19\x11\x5f"
    b"\xf1\x56\x35\x04\x6b\xc7\xa3\xd7\x3b\x18\x11\x3c\x09\xa5\x24\x59"
    b"\xed\xe6\x8f\xf2\xfa\xfb\xf1\x97\x2c\xbf\xba\x9e\x6e\x3c\x15\x1e"
    b"\x70\x45\xe3\x86\xb1\x6f\xe9\xea\x0a\x5e\x0e\x86\xb3\x2a\x3e\x5a"
    b"\x1c\xe7\x1f\x77\xfa\x06\x3d\x4e\xb9\xdc\x65\x29\x0f\x1d\xe7\x99"
    b"\xd6\x89\x3e\x80\x25\xc8\x66\x52\x78\xc9\x4c\x2e\x6a\xb3\x10\x9c"
    b"\xba\x0e\x15\xc6\x78\xea\xe2\x94\x53\x3c\xfc\xa5\xf4\x2d\x0a\x1e"
    b"\xa7\x4e\xf7\xf2\x3d\x2b\x1d\x36\x0f\x26\x39\x19\x60\x79\xc2\x19"
    b"\x08\xa7\x23\x52\xb6\x12\x13\xf7\x6e\xfe\xad\xeb\x66\x1f\xc3\xea"
    b"\x95\x45\xbc\xe3\x83\xc8\x7b\xa6\xd1\x37\x7f\xb1\x28\xff\x8c\x01"
    b"\xef\xdd\x32\xc3\xa5\x5a\x6c\xbe\x85\x21\x58\x65\x02\x98\xab\x68"
    b"\x0f\xa5\xce\xee\x3b\x95\x2f\xdb\xad\x7d\xef\x2a\x84\x2f\x6e\x5b"
    b"\x28\xb6\x21\x15\x70\x61\x07\x29\x75\x47\xdd\xec\x10\x15\x9f\x61"
    b"\x30\xa8\xcc\x13\x96\xbd\x61\xeb\x1e\xfe\x34\x03\xcf\x63\x03\xaa"
    b"\x90\x5c\x73\xb5\x39\xa2\x70\x4c\x0b\x9e\x9e\xd5\x14\xde\xaa\xcb"
    b"\xbc\x86\xcc\xee\xa7\x2c\x62\x60\xab\x5c\xab\x9c\x6e\x84\xf3\xb2"
    b"\xaf\x1e\x8b\x64\xca\xf0\xbd\x19\xb9\x69\x23\xa0\x50\xbb\x5a\x65"
    b"\x32\x5a\x68\x40\xb3\xb4\x2a\x3c\xd5\xe9\x9e\x31\xf7\xb8\x21\xc0"
    b"\x19\x0b\x54\x9b\x99\xa0\x5f\x87\x7e\x99\xf7\x95\xa8\x7d\x3d\x62"
    b"\x9a\x88\x37\xf8\x77\x2d\xe3\x97\x5f\x93\xed\x11\x81\x12\x68\x16"
    b"\x29\x88\x35\x0e\xd6\x1f\xe6\xc7\xa1\xdf\xde\x96\x99\xba\x58\x78"
    b"\xa5\x84\xf5\x57\x63\x72\x22\x1b\xff\xc3\x83\x9b\x96\x46\xc2\x1a"
    b"\xeb\x0a\xb3\xcd\x54\x30\x2e\x53\xe4\x48\xd9\x8f\x28\x31\xbc\x6d"
    b"\xef\xf2\xeb\x58\xea\xff\xc6\x34\x61\xed\x28\xfe\x73\x3c\x7c\xee"
    b"\xd9\x14\x4a\x5d\xe3\xb7\x64\xe8\x14\x5d\x10\x42\xe0\x13\x3e\x20"
    b"\xb6\xe2\xee\x45\xea\xab\xaa\xa3\x15\x4f\x6c\xdb\xd0\x4f\xcb\xfa"
    b"\x42\xf4\x42\xc7\xb5\xbb\x6a\xef\x1d\x3b\x4f\x65\x05\x21\xcd\x41"
    b"\x9e\x79\x1e\xd8\xc7\x4d\x85\x86\x6a\x47\x4b\xe4\x50\x62\x81\x3d"
    b"\xf2\xa1\x62\xcf\x46\x26\x8d\x5b\xa0\x83\x88\xfc\xa3\xb6\xc7\xc1"
    b"\xc3\x24\x15\x7f\x92\x74\xcb\x69\x0b\x8a\x84\x47\x85\xb2\x92\x56"
    b"\x00\xbf\x5b\x09\x9d\x48\x19\xad\x74\xb1\x62\x14\x00\x0e\x82\x23"
    b"\x2a\x8d\x42\x58\xea\xf5\x55\x0c\x3e\xf4\xad\x1d\x61\x70\x3f\x23"
    b"\x92\xf0\x72\x33\x41\x7e\x93\x8d\xf1\xec\x5f\xd6\xdb\x3b\x22\x6c"
    b"\x59\x37\xde\x7c\x60\x74\xee\xcb\xa7\xf2\x85\x40\x6e\x32\x77\xce"
    b"\x84\x80\x07\xa6\x9e\x50\xf8\x19\x55\xd8\xef\xe8\x35\x97\xd9\x61"
    b"\xaa\xa7\x69\xa9\xc2\x06\x0c\xc5\xfc\xab\x04\x5a\xdc\xca\x0b\x80"
    b"\x2e\x7a\x44\x9e\x84\x34\x45\xc3\x05\x67\xd5\xfd\xc9\x9e\x1e\x0e"
    b"\xd3\xdb\x73\xdb\xcd\x88\x55\x10\x79\xda\x5f\x67\x40\x43\x67\xe3"
    b"\x65\x34\xc4\xc5\xd8\x38\x3e\x71\x9e\xf8\x28\x3d\x20\xff\x6d\xf1"
    b"\xe7\x21\x3e\x15\x4a\x3d\xb0\x8f\x2b\x9f\xe3\xe6\xf7\xad\x83\xdb"
    b"\x68\x5a\x3d\xe9\xf7\x40\x81\x94\x1c\x26\x4c\xf6\x34\x29\x69\x94"
    b"\xf7\x20\x15\x41\xf7\xd4\x02\x76\x2e\x6b\xf4\xbc\x68\x00\xa2\xd4"
    b"\x71\x24\x08\xd4\x6a\xf4\x20\x33\xb7\xd4\xb7\x43\xaf\x61\x00\x50"
    b"\x2e\xf6\x39\x1e\x46\x45\x24\x97\x74\x4f\x21\x14\x40\x88\x8b\xbf"
    b"\x1d\xfc\x95\x4d\xaf\x91\xb5\x96\xd3\xdd\xf4\x70\x45\x2f\xa0\x66"
    b"\xec\x09\xbc\xbf\x85\x97\xbd\x03\xd0\x6d\xac\x7f\x04\x85\xcb\x31"
    b"\xb3\x27\xeb\x96\x41\x39\xfd\x55\xe6\x47\x25\xda\x9a\x0a\xca\xab"
    b"\x25\x78\x50\x28\xf4\x29\x04\x53\xda\x86\x2c\x0a\xfb\x6d\xb6\xe9"
    b"\x62\x14\xdc\x68\x00\x69\x48\xd7\xa4\xc0\x0e\x68\xee\x8d\xa1\x27"
    b"\xa2\xfe\x3f\x4f\x8c\xad\x87\xe8\x06\xe0\x8c\xb5\xb6\xd6\xf4\x7a"
    b"\x7c\x1e\xce\xaa\xec\x5f\x37\xd3\x99\xa3\x78\xce\x42\x2a\x6b\x40"
    b"\x35\x9e\xfe\x20\xb9\x85\xf3\xd9\xab\xd7\x39\xee\x8b\x4e\x12\x3b"
    b"\xf7\xfa\xc9\x1d\x56\x18\x6d\x4b\x31\x66\xa3\x26\xb2\x97\xe3\xea"
    b"\x74\xfa\x6e\x3a\x32\x43\x5b\xdd\xf7\xe7\x41\x68\xfb\x20\x78\xca"
    b"\x4e\xf5\x0a\xfb\x97\xb3\xfe\xd8\xac\x56\x40\x45\x27\x95\x48\xba"
    b"\x3a\x3a\x53\x55\x87\x8d\x83\x20\xb7\xa9\x6b\xfe\x4b\x95\x96\xd0"
    b"\xbc\x67\xa8\x55\x58\x9a\x15\xa1\x63\x29\xa9\xcc\x33\xdb\xe1\x99"
    b"\x56\x4a\x2a\xa6\xf9\x25\x31\x3f\x1c\x7e\xf4\x5e\x7c\x31\x29\x90"
    b"\x02\xe8\xf8\xfd\x70\x2f\x27\x04\x5c\x15\xbb\x80\xe3\x2c\x28\x05"
    b"\x48\x15\xc1\x95\x22\x6d\xc6\xe4\x3f\x13\xc1\x48\xdc\x86\x0f\xc7"
    b"\xee\xc9\xf9\x07\x0f\x1f\x04\x41\xa4\x79\x47\x40\x17\x6e\x88\x5d"
    b"\xeb\x51\x5f\x32\xd1\xc0\x9b\xd5\x8f\xc1\xbc\xf2\x64\x35\x11\x41"
    b"\x34\x78\x7b\x25\x60\x9c\x2a\x60\xa3\xe8\xf8\xdf\x1b\x6c\x63\x1f"
    b"\xc2\xb4\x12\x0e\x9e\x32\xe1\x02\xd1\x4f\x66\xaf\x15\x81\xd1\xca"
    b"\xe0\x95\x23\x6b\xe1\x92\x3e\x33\x62\x0b\x24\x3b\x22\xb9\xbe\xee"
    b"\x0e\xa2\xb2\x85\x99\x0d\xba\xe6\x8c\x0c\x72\xde\x28\xf7\xa2\x2d"
    b"\x45\x78\x12\xd0\xfd\x94\xb7\x95\x62\x08\x7d\x64\xf0\xf5\xcc\xe7"
    b"\x6f\xa3\x49\x54\xfa\x48\x7d\x87\x27\xfd\x9d\xc3\x1e\x8d\x3e\xf3"
    b"\x41\x63\x47\x0a\x74\xff\x2e\x99\xab\x6e\x6f\x3a\x37\xfd\xf8\xf4"
    b"\x60\xdc\x12\xa8\xf8\xdd\xeb\xa1\x4c\xe1\x1b\x99\x0d\x6b\x6e\xdb"
    b"\x10\x55\x7b\xc6\x37\x2c\x67\x6d\x3b\xd4\x65\x27\x04\xe8\xd0\xdc"
    b"\xc7\x0d\x29\xf1\xa3\xff\x00\xcc\x92\x0f\x39\xb5\x0b\xed\x0f\x69"
    b"\xfb\x9f\x7b\x66\x9c\x7d\xdb\xce\x0b\xcf\x91\xa0\xa3\x5e\x15\xd9"
    b"\x88\x2f\x13\xbb\x24\xad\x5b\x51\xbf\x79\x94\x7b\xeb\xd6\x3b\x76"
    b"\xb3\x2e\x39\x37\x79\x59\x11\xcc\x97\xe2\x26\x80\x2d\x31\x2e\xf4"
    b"\xa7\xad\x42\x68\x3b\x2b\x6a\xc6\xcc\x4c\x75\x12\x1c\xf1\x2e\x78"
    b"\x37\x42\x12\x6a\xe7\x51\x92\xb7\xe6\xbb\xa1\x06\x50\x63\xfb\x4b"
    b"\x18\x10\x6b\x1a\xfa\xed\xca\x11\xd8\xbd\x25\x3d\xc9\xc3\xe1\xe2"
    b"\x59\x16\x42\x44\x86\x13\x12\x0a\x6e\xec\x0c\xd9\x2a\xea\xab\xd5"
    b"\x4e\x67\xaf\x64\x5f\xa8\x86\xda\x88\xe9\xbf\xbe\xfe\xc3\xe4\x64"
    b"\x57\x80\xbc\x9d\x86\xc0\xf7\xf0\xf8\x7b\x78\x60\x4d\x60\x03\x60"
    b"\x46\x83\xfd\xd1\xb0\x1f\x38\xf6\x04\xae\x45\x77\xcc\xfc\x36\xd7"
    b"\x33\x6b\x42\x83\x71\xab\x1e\xf0\x87\x41\x80\xb0\x5f\x5e\x00\x3c"
    b"\xbe\x57\xa0\x77\x24\xae\xe8\xbd\x99\x42\x46\x55\x61\x2e\x58\xbf"
    b"\x8f\xf4\x58\x4e\xa2\xfd\xdd\xf2\x38\xef\x74\xf4\xc2\xbd\x89\x87"
    b"\xc3\xf9\x66\x53\x74\x8e\xb3\xc8\x55\xf2\x75\xb4\xb9\xd9\xfc\x46"
    b"\x61\x26\xeb\x7a\x84\xdf\x1d\x8b\x79\x0e\x6a\x84\xe2\x95\x5f\x91"
    b"\x8e\x59\x6e\x46\x70\x57\xb4\x20\x91\x55\xd5\x8c\x4c\xde\x02\xc9"
    b"\xe1\xac\x0b\xb9\xd0\x05\x82\xbb\x48\x62\xa8\x11\x9e\xa9\x74\x75"
    b"\xb6\x19\x7f\xb7\x09\xdc\xa9\xe0\xa1\x09\x2d\x66\x33\x46\x32\xc4"
    b"\x02\x1f\x5a\xe8\x8c\xbe\xf0\x09\x25\xa0\x99\x4a\x10\xfe\x6e\x1d"
    b"\x1d\x3d\xb9\x1a\xdf\xa4\xa5\x0b\x0f\xf2\x86\xa1\x69\xf1\x68\x28"
    b"\x83\xda\xb7\xdc\xfe\x06\x39\x57\x9b\xce\xe2\xa1\x52\x7f\xcd\x4f"
    b"\x01\x5e\x11\x50\xfa\x83\x06\xa7\xc4\xb5\x02\xa0\x27\xd0\xe6\x0d"
    b"\x27\x8c\xf8\x9a\x41\x86\x3f\x77\x06\x4c\x60\xc3\xb5\x06\xa8\x61"
    b"\x28\x7a\x17\xf0\xe0\x86\xf5\xc0\xaa\x58\x60\x00\x62\x7d\xdc\x30"
    b"\xd7\x9e\xe6\x11\x63\xea\x38\x23\x94\xdd\xc2\x53\x34\x16\xc2\xc2"
    b"\x56\xee\xcb\xbb\xde\xb6\xbc\x90\xa1\x7d\xfc\xeb\x76\x1d\x59\xce"
    b"\x09\xe4\x05\x6f\x88\x01\x7c\x4b\x3d\x0a\x72\x39\x24\x7c\x92\x7c"
    b"\x5f\x72\xe3\x86\xb9\x9d\x4d\x72\xb4\x5b\xc1\x1a\xfc\xb8\x9e\xd3"
    b"\x78\x55\x54\xed\xb5\xa5\xfc\x08\xd3\x7c\x3d\xd8\xc4\x0f\xad\x4d"
    b"\x5e\xef\x50\x1e\xf8\xe6\x61\xb1\xd9\x14\x85\xa2\x3c\x13\x51\x6c"
    b"\xe7\xc7\xd5\x6f\xc4\x4e\xe1\x56\xce\xbf\x2a\x36\x37\xc8\xc6\xdd"
    b"\x34\x32\x9a\xd7\x12\x82\x63\x92\x8e\xfa\x0e\x67\xe0\x00\x60\x40"
    b"\x37\xce\x39\x3a\xcf\xf5\xfa\xd3\x37\x77\xc2\xab\x1b\x2d\xc5\x5a"
    b"\x9e\x67\xb0\x5c\x42\x37\xa3\x4f\x40\x27\x82\xd3\xbe\x9b\xbc\x99"
    b"\x9d\x8e\x11\xd5\x15\x73\x0f\xbf\x7e\x1c\x2d\xd6\x7b\xc4\x00\xc7"
    b"\x6b\x1b\x8c\xb7\x45\x90\xa1\x21\xbe\xb1\x6e\xb2\xb4\x6e\x36\x6a"
    b"\x2f\xab\x48\x57\x79\x6e\x94\xbc\xd2\x76\xa3\xc6\xc8\xc2\x49\x65"
    b"\xee\xf8\x0f\x53\x7d\xde\x8d\x46\x1d\x0a\x73\xd5\xc6\x4d\xd0\x4c"
    b"\xdb\xbb\x39\x29\x50\x46\xba\xa9\xe8\x26\x95\xac\x04\xe3\x5e\xbe"
    b"\xf0\xd5\xfa\xa1\x9a\x51\x2d\x6a\xe2\x8c\xef\x63\x22\xee\x86\x9a"
    b"\xb8\xc2\x89\xc0\xf6\x2e\x24\x43\xaa\x03\x1e\xa5\xa4\xd0\xf2\x9c"
    b"\xba\x61\xc0\x83\x4d\x6a\xe9\x9b\x50\x15\xe5\x8f\xd6\x5b\x64\xba"
    b"\xf9\xa2\x26\x28\xe1\x3a\x3a\xa7\x86\x95\xa9\x4b\xe9\x62\x55\xef"
    b"\xd3\xef\x2f\xc7\xda\xf7\x52\xf7\x69\x6f\x04\x3f\x59\x0a\xfa\x77"
    b"\x15\xa9\xe4\x80\x01\x86\xb0\x87\xad\xe6\x09\x9b\x93\xe5\x3e\x3b"
    b"\x5a\xfd\x90\xe9\x97\xd7\x34\x9e\xd9\xb7\xf0\x2c\x51\x8b\x2b\x02"
    b"\x3a\xac\xd5\x96\x7d\xa6\x7d\x01\xd6\x3e\xcf\xd1\x28\x2d\x7d\x7c"
    b"\xcf\x25\x9f\x1f\x9b\xb8\xf2\xad\x72\xb4\xd6\x5a\x4c\xf5\x88\x5a"
    b"\x71\xac\x29\xe0\xe6\xa5\x19\xe0\xfd\xac\xb0\x47\x9b\xfa\x93\xed"
    b"\x8d\xc4\xd3\xe8\xcc\x57\x3b\x28\x29\x66\xd5\xf8\x28\x2e\x13\x79"
    b"\x91\x01\x5f\x78\x55\x60\x75\xed\x44\x0e\x96\xf7\x8c\x5e\xd3\xe3"
    b"\xd4\x6d\x05\x15\xba\x6d\xf4\x88\x25\x61\xa1\x03\xbd\xf0\x64\x05"
    b"\x15\x9e\xeb\xc3\xa2\x57\x90\x3c\xec\x1a\x27\x97\x2a\x07\x3a\xa9"
    b"\x9b\x6d\x3f\x1b\xf5\x21\x63\x1e\xfb\x66\x9c\xf5\x19\xf3\xdc\x26"
    b"\x28\xd9\x33\x75\xf5\xfd\x55\xb1\x82\x34\x56\x03\xbb\x3c\xba\x8a"
    b"\x11\x77\x51\x28\xf8\xd9\x0a\xc2\x67\x51\xcc\xab\x5f\x92\xad\xcc"
    b"\x51\x17\xe8\x4d\x8e\xdc\x30\x38\x62\x58\x9d\x37\x91\xf9\x20\x93"
    b"\xc2\x90\x7a\xea\xce\x7b\x3e\xfb\x64\xce\x21\x51\x32\xbe\x4f\x77"
    b"\x7e\xe3\xb6\xa8\x46\x3d\x29\xc3\x69\x53\xde\x48\x80\xe6\x13\x64"
    b"\x10\x08\xae\xa2\x24\xb2\x6d\xdd\xfd\x2d\x85\x69\x66\x21\x07\x09"
    b"\x0a\x46\x9a\xb3\xdd\xc0\x45\x64\xcf\xde\x6c\x58\xae\xc8\x20\x1c"
    b"\xdd\xf7\xbe\x5b\x40\x8d\x58\x1b\x7f\x01\xd2\xcc\xbb\xe3\xb4\x6b"
    b"\x7e\x6a\xa2\xdd\x45\xff\x59\x3a\x44\x0a\x35\x3e\xd5\xcd\xb4\xbc"
    b"\xa8\xce\xea\x72\xbb\x84\x64\xfa\xae\x12\x66\x8d\x47\x6f\x3c\xbf"
    b"\x63\xe4\x9b\xd2\x9e\x5d\x2f\x54\x1b\x77\xc2\xae\x70\x63\x4e\xf6"
    b"\x8d\x0d\x0e\x74\x57\x13\x5b\xe7\x71\x16\x72\xf8\x5d\x7d\x53\xaf"
    b"\x08\xcb\x40\x40\xcc\xe2\xb4\x4e\x6a\x46\xd2\x34\x84\xaf\x15\x01"
    b"\x28\x04\xb0\xe1\x1d\x3a\x98\x95\xb4\x9f\xb8\x06\x48\xa0\x6e\xce"
    b"\x82\x3b\x3f\x6f\x82\xab\x20\x35\x4b\x1d\x1a\x01\xf8\x27\x72\x27"
    b"\xb1\x60\x15\x61\xdc\x3f\x93\xe7\x2b\x79\x3a\xbb\xbd\x25\x45\x34"
    b"\xe1\x39\x88\xa0\x4b\x79\xce\x51\xb7\xc9\x32\x2f\xc9\xba\x1f\xa0"
    b"\x7e\xc8\x1c\xe0\xf6\xd1\xc7\xbc\xc3\x11\x01\xcf\xc7\xaa\xe8\xa1"
    b"\x49\x87\x90\x1a\x9a\xbd\x4f\xd4\xcb\xde\xda\xd0\x38\xda\x0a\xd5"
    b"\x2a\xc3\x39\x03\x67\x36\x91\xc6\x7c\x31\xf9\x8d\x4f\x2b\xb1\xe0"
    b"\xb7\x59\x9e\xf7\x3a\xbb\xf5\x43\xff\x19\xd5\xf2\x9c\x45\xd9\x27"
    b"\x2c\x22\x97\xbf\x2a\xfc\xe6\x15\x71\xfc\x91\x0f\x25\x15\x94\x9b"
    b"\x61\x93\xe5\xfa\xeb\x9c\xb6\xce\x59\x64\xa8\xc2\xd1\xa8\xba\x12"
    b"\x5e\x07\xc1\xb6\x0c\x6a\x05\xe3\x65\x50\xd2\x10\x42\xa4\x03\xcb"
    b"\x0e\x6e\xec\xe0\x3b\xdb\x98\x16\xbe\xa0\x98\x4c\x64\xe9\x78\x32"
    b"\x32\x95\x1f\x9f\xdf\x92\xd3\xe0\x2b\x34\xa0\xd3\x1e\xf2\x71\x89"
    b"\x41\x74\x0a\x1b\x8c\x34\xa3\x4b\x20\x71\xbe\xc5\xd8\x32\x76\xc3"
    b"\x8d\x9f\x35\xdf\x2e\x2f\x99\x9b\x47\x6f\x0b\xe6\x1d\xf1\xe3\x0f"
    b"\x54\xda\x4c\xe5\x91\xd8\xda\x1e\xcf\x79\x62\xce\x6f\x7e\x3e\xcd"
    b"\x66\xb1\x18\x16\x05\x1d\x2c\xfd\xc5\xd2\x8f\x84\x99\x22\xfb\xf6"
    b"\x57\xf3\x23\xf5\x23\x76\x32\xa6\x31\x35\xa8\x93\x02\xcd\xcc\x56"
    b"\x62\x81\xf0\xac\xb5\xeb\x75\x5a\x97\x36\x16\x6e\xcc\x73\xd2\x88"
    b"\x92\x62\x96\xde\xd0\x49\xb9\x81\x1b\x90\x50\x4c\x14\x56\xc6\x71"
    b"\xbd\xc7\xc6\xe6\x0a\x14\x7a\x32\x06\xd0\xe1\x45\x9a\x7b\xf2\xc3"
    b"\xfd\x53\xaa\xc9\x00\x0f\xa8\x62\xe2\xbf\x25\xbb\xf6\xd2\xbd\x35"
    b"\x05\x69\x12\x71\x22\x02\x04\xb2\x7c\xcf\xcb\xb6\x2b\x9c\x76\xcd"
    b"\xc0\x3e\x11\x53\xd3\xe3\x40\x16\x60\xbd\xab\x38\xf0\xad\x47\x25"
    b"\x9c\x20\x38\xba\x76\xce\x46\xf7\xc5\xa1\xaf\x77\x60\x60\x75\x20"
    b"\x4e\xfe\xcb\x85\xd8\x8d\xe8\x8a\xb0\xf9\xaa\x7a\x7e\xaa\xf9\x4c"
    b"\x5c\xc2\x48\x19\x8c\x8a\xfb\x02\xe4\x6a\xc3\x01\xf9\xe1\xeb\xd6"
    b"\x69\xf8\xd4\x90\xa0\xde\x5c\xa6\x2d\x25\x09\x3f\x9f\xe6\x08\xc2"
    b"\x32\x61\x4e\xb7\x5b\xe2\x77\xce\xe3\xdf\x8f\x57\xe6\x72\xc3\x3a",

"crc32_box":
    b"\x00\x00\x00\x00\x96\x30\x07\x77\x2c\x61\x0e\xee\xba\x51\x09\x99"
    b"\x19\xc4\x6d\x07\x8f\xf4\x6a\x70\x35\xa5\x63\xe9\xa3\x95\x64\x9e"
    b"\x32\x88\xdb\x0e\xa4\xb8\xdc\x79\x1e\xe9\xd5\xe0\x88\xd9\xd2\x97"
    b"\x2b\x4c\xb6\x09\xbd\x7c\xb1\x7e\x07\x2d\xb8\xe7\x91\x1d\xbf\x90"
    b"\x64\x10\xb7\x1d\xf2\x20\xb0\x6a\x48\x71\xb9\xf3\xde\x41\xbe\x84"
    b"\x7d\xd4\xda\x1a\xeb\xe4\xdd\x6d\x51\xb5\xd4\xf4\xc7\x85\xd3\x83"
    b"\x56\x98\x6c\x13\xc0\xa8\x6b\x64\x7a\xf9\x62\xfd\xec\xc9\x65\x8a"
    b"\x4f\x5c\x01\x14\xd9\x6c\x06\x63\x63\x3d\x0f\xfa\xf5\x0d\x08\x8d"
    b"\xc8\x20\x6e\x3b\x5e\x10\x69\x4c\xe4\x41\x60\xd5\x72\x71\x67\xa2"
    b"\xd1\xe4\x03\x3c\x47\xd4\x04\x4b\xfd\x85\x0d\xd2\x6b\xb5\x0a\xa5"
    b"\xfa\xa8\xb5\x35\x6c\x98\xb2\x42\xd6\xc9\xbb\xdb\x40\xf9\xbc\xac"
    b"\xe3\x6c\xd8\x32\x75\x5c\xdf\x45\xcf\x0d\xd6\xdc\x59\x3d\xd1\xab"
    b"\xac\x30\xd9\x26\x3a\x00\xde\x51\x80\x51\xd7\xc8\x16\x61\xd0\xbf"
    b"\xb5\xf4\xb4\x21\x23\xc4\xb3\x56\x99\x95\xba\xcf\x0f\xa5\xbd\xb8"
    b"\x9e\xb8\x02\x28\x08\x88\x05\x5f\xb2\xd9\x0c\xc6\x24\xe9\x0b\xb1"
    b"\x87\x7c\x6f\x2f\x11\x4c\x68\x58\xab\x1d\x61\xc1\x3d\x2d\x66\xb6"
    b"\x90\x41\xdc\x76\x06\x71\xdb\x01\xbc\x20\xd2\x98\x2a\x10\xd5\xef"
    b"\x89\x85\xb1\x71\x1f\xb5\xb6\x06\xa5\xe4\xbf\x9f\x33\xd4\xb8\xe8"
    b"\xa2\xc9\x07\x78\x34\xf9\x00\x0f\x8e\xa8\x09\x96\x18\x98\x0e\xe1"
    b"\xbb\x0d\x6a\x7f\x2d\x3d\x6d\x08\x97\x6c\x64\x91\x01\x5c\x63\xe6"
    b"\xf4\x51\x6b\x6b\x62\x61\x6c\x1c\xd8\x30\x65\x85\x4e\x00\x62\xf2"
    b"\xed\x95\x06\x6c\x7b\xa5\x01\x1b\xc1\xf4\x08\x82\x57\xc4\x0f\xf5"
    b"\xc6\xd9\xb0\x65\x50\xe9\xb7\x12\xea\xb8\xbe\x8b\x7c\x88\xb9\xfc"
    b"\xdf\x1d\xdd\x62\x49\x2d\xda\x15\xf3\x7c\xd3\x8c\x65\x4c\xd4\xfb"
    b"\x58\x61\xb2\x4d\xce\x51\xb5\x3a\x74\x00\xbc\xa3\xe2\x30\xbb\xd4"
    b"\x41\xa5\xdf\x4a\xd7\x95\xd8\x3d\x6d\xc4\xd1\xa4\xfb\xf4\xd6\xd3"
    b"\x6a\xe9\x69\x43\xfc\xd9\x6e\x34\x46\x88\x67\xad\xd0\xb8\x60\xda"
    b"\x73\x2d\x04\x44\xe5\x1d\x03\x33\x5f\x4c\x0a\xaa\xc9\x7c\x0d\xdd"
    b"\x3c\x71\x05\x50\xaa\x41\x02\x27\x10\x10\x0b\xbe\x86\x20\x0c\xc9"
    b"\x25\xb5\x68\x57\xb3\x85\x6f\x20\x09\xd4\x66\xb9\x9f\xe4\x61\xce"
    b"\x0e\xf9\xde\x5e\x98\xc9\xd9\x29\x22\x98\xd0\xb0\xb4\xa8\xd7\xc7"
    b"\x17\x3d\xb3\x59\x81\x0d\xb4\x2e\x3b\x5c\xbd\xb7\xad\x6c\xba\xc0"
    b"\x20\x83\xb8\xed\xb6\xb3\xbf\x9a\x0c\xe2\xb6\x03\x9a\xd2\xb1\x74"
    b"\x39\x47\xd5\xea\xaf\x77\xd2\x9d\x15\x26\xdb\x04\x83\x16\xdc\x73"
    b"\x12\x0b\x63\xe3\x84\x3b\x64\x94\x3e\x6a\x6d\x0d\xa8\x5a\x6a\x7a"
    b"\x0b\xcf\x0e\xe4\x9d\xff\x09\x93\x27\xae\x00\x0a\xb1\x9e\x07\x7d"
    b"\x44\x93\x0f\xf0\xd2\xa3\x08\x87\x68\xf2\x01\x1e\xfe\xc2\x06\x69"
    b"\x5d\x57\x62\xf7\xcb\x67\x65\x80\x71\x36\x6c\x19\xe7\x06\x6b\x6e"
    b"\x76\x1b\xd4\xfe\xe0\x2b\xd3\x89\x5a\x7a\xda\x10\xcc\x4a\xdd\x67"
    b"\x6f\xdf\xb9\xf9\xf9\xef\xbe\x8e\x43\xbe\xb7\x17\xd5\x8e\xb0\x60"
    b"\xe8\xa3\xd6\xd6\x7e\x93\xd1\xa1\xc4\xc2\xd8\x38\x52\xf2\xdf\x4f"
    b"\xf1\x67\xbb\xd1\x67\x57\xbc\xa6\xdd\x06\xb5\x3f\x4b\x36\xb2\x48"
    b"\xda\x2b\x0d\xd8\x4c\x1b\x0a\xaf\xf6\x4a\x03\x36\x60\x7a\x04\x41"
    b"\xc3\xef\x60\xdf\x55\xdf\x67\xa8\xef\x8e\x6e\x31\x79\xbe\x69\x46"
    b"\x8c\xb3\x61\xcb\x1a\x83\x66\xbc\xa0\xd2\x6f\x25\x36\xe2\x68\x52"
    b"\x95\x77\x0c\xcc\x03\x47\x0b\xbb\xb9\x16\x02\x22\x2f\x26\x05\x55"
    b"\xbe\x3b\xba\xc5\x28\x0b\xbd\xb2\x92\x5a\xb4\x2b\x04\x6a\xb3\x5c"
    b"\xa7\xff\xd7\xc2\x31\xcf\xd0\xb5\x8b\x9e\xd9\x2c\x1d\xae\xde\x5b"
    b"\xb0\xc2\x64\x9b\x26\xf2\x63\xec\x9c\xa3\x6a\x75\x0a\x93\x6d\x02"
    b"\xa9\x06\x09\x9c\x3f\x36\x0e\xeb\x85\x67\x07\x72\x13\x57\x00\x05"
    b"\x82\x4a\xbf\x95\x14\x7a\xb8\xe2\xae\x2b\xb1\x7b\x38\x1b\xb6\x0c"
    b"\x9b\x8e\xd2\x92\x0d\xbe\xd5\xe5\xb7\xef\xdc\x7c\x21\xdf\xdb\x0b"
    b"\xd4\xd2\xd3\x86\x42\xe2\xd4\xf1\xf8\xb3\xdd\x68\x6e\x83\xda\x1f"
    b"\xcd\x16\xbe\x81\x5b\x26\xb9\xf6\xe1\x77\xb0\x6f\x77\x47\xb7\x18"
    b"\xe6\x5a\x08\x88\x70\x6a\x0f\xff\xca\x3b\x06\x66\x5c\x0b\x01\x11"
    b"\xff\x9e\x65\x8f\x69\xae\x62\xf8\xd3\xff\x6b\x61\x45\xcf\x6c\x16"
    b"\x78\xe2\x0a\xa0\xee\xd2\x0d\xd7\x54\x83\x04\x4e\xc2\xb3\x03\x39"
    b"\x61\x26\x67\xa7\xf7\x16\x60\xd0\x4d\x47\x69\x49\xdb\x77\x6e\x3e"
    b"\x4a\x6a\xd1\xae\xdc\x5a\xd6\xd9\x66\x0b\xdf\x40\xf0\x3b\xd8\x37"
    b"\x53\xae\xbc\xa9\xc5\x9e\xbb\xde\x7f\xcf\xb2\x47\xe9\xff\xb5\x30"
    b"\x1c\xf2\xbd\xbd\x8a\xc2\xba\xca\x30\x93\xb3\x53\xa6\xa3\xb4\x24"
    b"\x05\x36\xd0\xba\x93\x06\xd7\xcd\x29\x57\xde\x54\xbf\x67\xd9\x23"
    b"\x2e\x7a\x66\xb3\xb8\x4a\x61\xc4\x02\x1b\x68\x5d\x94\x2b\x6f\x2a"
    b"\x37\xbe\x0b\xb4\xa1\x8e\x0c\xc3\x1b\xdf\x05\x5a\x8d\xef\x02\x2d",
}

for s in api.iter_sections():
    for dataname, buf in HEXA_CONSTS.items():
        idx = s.data.find(buf)
        while idx != -1:
            ad = s.start + idx
            print(hex(ad), dataname)
            api.add_symbol(ad, dataname)
            api.set_array(ad, len(buf), MEM_BYTE)
            idx = s.data.find(buf, idx+1)
