# -*- coding: binary -*-

module Msf

# This mixin provides helper functions for building Git repositories
module Exploit::Git

  # Generate a commit message using fake names and emails
  def fake_commit_message
    email = Rex::Text.rand_mail_address
    first, last, company = email.scan(/([^\.]+)\.([^\.]+)@(.*)$/).flatten
    full_name = "#{first.capitalize} #{last.capitalize}"
    tstamp = Time.now.to_i
    author_time = rand(tstamp)
    commit_time = rand(author_time)
    tz_off = rand(10)
    commit = "author #{full_name} <#{email}> #{author_time} -0#{tz_off}00\n" \
             "committer #{full_name} <#{email}> #{commit_time} -0#{tz_off}00\n" \
             "\n" \
             "Initial commit to open git repository for #{company}!\n"
    commit
  end

  # Build's a Git object
  def build_object(type, content)
    # taken from http://schacon.github.io/gitbook/7_how_git_stores_objects.html
    header = "#{type} #{content.size}\0"
    store = header + content
    [Digest::SHA1.hexdigest(store), Zlib::Deflate.deflate(store)]
  end

  # Returns the Git object path name that a file with the provided SHA1 will reside in
  def get_path(sha1)
    sha1[0...2] + '/' + sha1[2..40]
  end

end
end
