/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid.editors;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.editing.UnsupportedEditorException;
import com.paterva.maltego.typing.editing.propertygrid.editors.ArrayPropertyEditor;
import com.paterva.maltego.typing.editing.propertygrid.editors.AttachmentsPropertyEditor;
import com.paterva.maltego.typing.editing.propertygrid.editors.CheckListPropertyEditor;
import com.paterva.maltego.typing.editing.propertygrid.editors.ColorPropertyEditor;
import com.paterva.maltego.typing.editing.propertygrid.editors.ComboBoxPropertyEditor;
import com.paterva.maltego.typing.editing.propertygrid.editors.DatePropertyEditor;
import com.paterva.maltego.typing.editing.propertygrid.editors.DateRangePropertyEditor;
import com.paterva.maltego.typing.editing.propertygrid.editors.DateTimePropertyEditor;
import com.paterva.maltego.typing.editing.propertygrid.editors.PasswordPropertyEditor;
import com.paterva.maltego.typing.editing.propertygrid.editors.TimeSpanPropertyEditor;
import com.paterva.maltego.typing.editing.propertygrid.editors.TypePropertyEditor;
import com.paterva.maltego.typing.editors.OptionEditorDescriptor;
import com.paterva.maltego.typing.editors.PasswordEditorDescriptor;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.typing.types.DateRange;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.typing.types.TimeSpan;
import com.paterva.maltego.util.FastURL;
import java.awt.Color;
import java.beans.PropertyEditor;
import java.util.Date;

class DefaultPropertyEditorFactory {
    DefaultPropertyEditorFactory() {
    }

    public PropertyEditor createEditor(DisplayDescriptor descriptor, DataSource data) throws UnsupportedEditorException {
        if (descriptor.getEditor() == null) {
            return this.createTypeEditor(descriptor, data);
        }
        if (descriptor.getEditor() instanceof OptionEditorDescriptor) {
            return this.createOptionEditor(descriptor, (OptionEditorDescriptor)descriptor.getEditor());
        }
        if (descriptor.getEditor() instanceof PasswordEditorDescriptor) {
            return new PasswordPropertyEditor();
        }
        throw new UnsupportedEditorException(descriptor);
    }

    private PropertyEditor createOptionEditor(DisplayDescriptor descriptor, OptionEditorDescriptor editor) {
        if (descriptor.getTypeDescriptor().isArrayType()) {
            if (editor.isUserSpecified()) {
                return new ArrayPropertyEditor(descriptor.getType(), descriptor.getFormat());
            }
            return new CheckListPropertyEditor(descriptor.getType(), descriptor.getFormat(), editor.getItems());
        }
        return new ComboBoxPropertyEditor(editor.getItems(), editor.isUserSpecified(), descriptor.getFormat());
    }

    private PropertyEditor createTypeEditor(DisplayDescriptor descriptor, DataSource data) {
        if (Date.class.isAssignableFrom(descriptor.getType())) {
            return new DatePropertyEditor();
        }
        if (DateTime.class.isAssignableFrom(descriptor.getType())) {
            return new DateTimePropertyEditor();
        }
        if (DateRange.class.isAssignableFrom(descriptor.getType())) {
            return new DateRangePropertyEditor(descriptor, data);
        }
        if (TimeSpan.class.isAssignableFrom(descriptor.getType())) {
            return new TimeSpanPropertyEditor();
        }
        if (FastURL.class.isAssignableFrom(descriptor.getType())) {
            return new TypePropertyEditor(FastURL.class, null);
        }
        if (Attachments.class.isAssignableFrom(descriptor.getType())) {
            return new AttachmentsPropertyEditor(data);
        }
        if (descriptor.getType().isArray()) {
            return new ArrayPropertyEditor(descriptor.getType(), descriptor.getFormat());
        }
        if (Color.class.isAssignableFrom(descriptor.getType())) {
            return new ColorPropertyEditor();
        }
        return null;
    }
}

