/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.chat.users;

import com.paterva.maltego.chat.users.UserPresenceIconFactory;
import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.user.User;
import com.paterva.maltego.chatapi.user.UserPresence;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import com.paterva.maltego.util.ui.table.RowHeightProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIDefaults;
import javax.swing.table.TableCellRenderer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class UsersTableCellRenderer
extends JPanel
implements TableCellRenderer,
RowHeightProvider {
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private static final String CTL_FirstRow1 = "collaboration-user-table-first-row1";
    private static final String CTL_FirstRow2 = "collaboration-user-table-first-row2";
    private static final String CTL_NoHover1 = "collaboration-user-table-ctl-no-hover1";
    private static final String CTL_NoHover2 = "collaboration-user-table-ctl-no-hover2";
    private static final String CTL_Hover1 = "collaboration-user-table-ctl-hover1";
    private static final String CTL_Hover2 = "collaboration-user-table-ctl-hover2";
    private static final String CTL_Border = "collaboration-user-table-ctl-border";
    private static final String statusLabelForeground = "collaboration-user-table-status-label-fg";
    private static final String lastseenLabelForeground = "collaboration-user-table-lastseen-label-fg";
    private ChatRoom _chatRoom;
    private int _hoverRow = -1;
    private boolean _hover = false;
    private int _row = -1;
    private JLabel _iconLabel;
    private JLabel _lastSeenLabel;
    private JLabel _nameLabel;
    private JLabel _statusLabel;
    private JLabel _versionLabel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;

    public UsersTableCellRenderer() {
        this.initComponents();
        this._versionLabel.setVisible(false);
        this._lastSeenLabel.setVisible(false);
        this._iconLabel.setText("");
    }

    public void setChatRoom(ChatRoom chatRoom) {
        this._chatRoom = chatRoom;
    }

    public int getHoverRow() {
        return this._hoverRow;
    }

    public void setHoverRow(int row) {
        this._hoverRow = row;
    }

    public int getCollapsedHeight(int row) {
        return this.getHeight(row, false);
    }

    public int getExpandedHeight(int row) {
        return this.getHeight(row, true);
    }

    private int getHeight(int row, boolean expanded) {
        boolean savedExpanded = this.isExpanded();
        this.setExpanded(expanded);
        int height = this.getPreferredSize().height;
        this.setExpanded(savedExpanded);
        return height;
    }

    private boolean isExpanded() {
        return this._versionLabel.isVisible();
    }

    private void setExpanded(boolean expanded) {
        if (expanded != this.isExpanded()) {
            this._versionLabel.setVisible(expanded);
            this._lastSeenLabel.setVisible(expanded);
            this.doLayout();
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Rectangle cellRect = table.getCellRect(row, column, false);
        this.setSize(cellRect.width, cellRect.height);
        if (this._chatRoom != null && value instanceof User) {
            User user = (User)value;
            String name = this._chatRoom.getAlias(user);
            this._nameLabel.setText(name);
            UserPresence presence = this._chatRoom.getPresence(user);
            Icon icon = UserPresenceIconFactory.getIcon(presence);
            this._iconLabel.setIcon(icon);
            String statusText = user.getStatusText();
            if (row == 0 && StringUtilities.isNullOrEmpty((String)statusText)) {
                statusText = "(click to set status)";
            }
            this._statusLabel.setText(statusText != null ? statusText : "");
            String version = user.getClientVersion();
            this._versionLabel.setText(version);
            Date lastSeen = user.getLastSeen();
            this._lastSeenLabel.setText(lastSeen != null ? "last seen " + new SimpleDateFormat("dd MMM h:mm a").format(lastSeen) : "");
        }
        this._nameLabel.setForeground(Color.BLACK);
        this._hover = row == this._hoverRow;
        this._row = row;
        this.setExpanded(this._hover);
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        this._statusLabel.setForeground(LAF.getColor(statusLabelForeground));
        this._lastSeenLabel.setForeground(LAF.getColor(lastseenLabelForeground));
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color nextColor1 = LAF.getColor(this._hover ? CTL_Hover1 : CTL_NoHover1);
        Color nextColor2 = LAF.getColor(this._hover ? CTL_Hover2 : CTL_NoHover2);
        Color color1 = this._row != 0 ? nextColor1 : LAF.getColor(CTL_FirstRow1);
        Color color2 = this._row != 0 ? nextColor2 : LAF.getColor(CTL_FirstRow2);
        Color borderColor = LAF.getColor(CTL_Border);
        boolean isNotLastRow = this._row < this._chatRoom.getUsers().size() - 1;
        int x = 4;
        int y = -10;
        int width = this.getWidth() - 2 * x;
        int height = this.getHeight() - y;
        int borderSize = 1;
        if (isNotLastRow) {
            g2D.setColor(borderColor);
            g2D.drawLine(x, y, x, y + height);
            g2D.drawLine(x + width - 1, y, x + width - 1, y + height);
            g2D.setPaint(new GradientPaint(0.0f, 0.0f, nextColor1, this.getWidth(), 0.0f, nextColor2));
            g2D.fillRect(x + 1, y + 1, width - 2, height - 1);
        }
        g2D.setColor(borderColor);
        g2D.fillRect(x, y, width, height);
        g2D.setPaint(new GradientPaint(0.0f, 0.0f, color1, this.getWidth(), 0.0f, color2));
        g2D.fillRect(x + 1, y + 1, width - borderSize - 1, height - borderSize - 1);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this._iconLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this._nameLabel = new JLabel();
        this._statusLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this._versionLabel = new JLabel();
        this._lastSeenLabel = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.setLayout(new BorderLayout());
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this._iconLabel, (String)NbBundle.getMessage(UsersTableCellRenderer.class, (String)"UsersTableCellRenderer._iconLabel.text"));
        this._iconLabel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this._iconLabel.setMinimumSize(new Dimension(28, 28));
        this._iconLabel.setPreferredSize(new Dimension(28, 28));
        this.jPanel1.add((Component)this._iconLabel, "West");
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new GridBagLayout());
        this._nameLabel.setFont(this._nameLabel.getFont().deriveFont(this._nameLabel.getFont().getStyle() | 1, this._nameLabel.getFont().getSize() + 1));
        Mnemonics.setLocalizedText((JLabel)this._nameLabel, (String)NbBundle.getMessage(UsersTableCellRenderer.class, (String)"UsersTableCellRenderer._nameLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 8, 10);
        this.jPanel3.add((Component)this._nameLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._statusLabel, (String)NbBundle.getMessage(UsersTableCellRenderer.class, (String)"UsersTableCellRenderer._statusLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this._statusLabel, gridBagConstraints);
        this.jPanel1.add((Component)this.jPanel3, "Center");
        this.add((Component)this.jPanel1, "North");
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this._versionLabel, (String)NbBundle.getMessage(UsersTableCellRenderer.class, (String)"UsersTableCellRenderer._versionLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 28, 6, 0);
        this.jPanel2.add((Component)this._versionLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._lastSeenLabel, (String)NbBundle.getMessage(UsersTableCellRenderer.class, (String)"UsersTableCellRenderer._lastSeenLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 24;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.jPanel2.add((Component)this._lastSeenLabel, gridBagConstraints);
        this.add((Component)this.jPanel2, "Center");
    }
}

