/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.notifications;

import com.paterva.maltego.notifications.ServerNotificationDisplayer;
import com.paterva.maltego.notifications.ServerNotificationsDownloader;
import com.paterva.maltego.notifications.data.ServerNotification;
import com.paterva.maltego.util.ui.dialog.UIRunQueue;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class ServerNotificationChecker {
    private static final Logger LOG = Logger.getLogger(ServerNotificationChecker.class.getName());

    public void checkForNotifications() {
        Thread thread = new Thread(() -> {
            try {
                LOG.info("Checking for notifications");
                ServerNotificationsDownloader downloader = new ServerNotificationsDownloader();
                List<ServerNotification> notifications = downloader.download();
                LOG.log(Level.INFO, "{0} notification(s)", notifications.size());
                if (!notifications.isEmpty()) {
                    UIRunQueue.instance().queue(100, () -> {
                        ServerNotificationDisplayer displayer = new ServerNotificationDisplayer();
                        displayer.show(notifications);
                    });
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }, "Notifications Download");
        thread.setDaemon(true);
        thread.start();
    }
}

