/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.feeder.websocket;

import com.paterva.maltego.graph.external.text.TextGraphXEntryPoint;
import java.net.InetSocketAddress;
import javax.swing.SwingUtilities;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public class GraphXWebSocketServer
extends WebSocketServer {
    private final TextGraphXEntryPoint _graphX = new TextGraphXEntryPoint();

    public GraphXWebSocketServer(int port) {
        super(new InetSocketAddress(port));
    }

    public void onOpen(WebSocket conn, ClientHandshake handshake) {
        System.out.println("GraphX WebSocket opened");
    }

    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        System.out.println("GraphX WebSocket closed");
    }

    public void onMessage(final WebSocket conn, final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.out.println("GraphX WebSocket msg: " + msg);
                String result = GraphXWebSocketServer.this._graphX.execute(msg);
                System.out.println("GraphX WebSocket result: " + result);
                conn.send(result);
            }
        });
    }

    public void onError(WebSocket ws, Exception excptn) {
        System.out.println("GraphX WebSocket error: " + excptn.getMessage());
    }
}

