/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jbosh;

import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class RequestIDSequence {
    private static final int MAX_BITS = 53;
    private static final int INCREMENT_BITS = 32;
    private static final long MIN_INCREMENTS = 0x100000000L;
    private static final long MAX_INITIAL = 0x1FFFFF00000000L;
    private static final long MASK = 0x1FFFFFFFFFFFFFL;
    private static final SecureRandom RAND = new SecureRandom();
    private static final Lock LOCK = new ReentrantLock();
    private AtomicLong nextRequestID = new AtomicLong(this.generateInitialValue());

    RequestIDSequence() {
    }

    public long getNextRID() {
        return this.nextRequestID.getAndIncrement();
    }

    private long generateInitialValue() {
        long result;
        LOCK.lock();
        try {
            while ((result = RAND.nextLong() & 0x1FFFFFFFFFFFFFL) > 0x1FFFFF00000000L) {
            }
        }
        finally {
            LOCK.unlock();
        }
        return result;
    }
}

